/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.emf.mapping.impl.MappingFactoryImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.CompareFactory;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceGuidelines;
import org.teiid.designer.compare.DifferenceProcessor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.DifferenceType;
import org.teiid.designer.compare.ModelerComparePlugin;
import org.teiid.designer.compare.PropertyDifference;
import org.teiid.designer.compare.impl.CompareFactoryImpl;
import org.teiid.designer.compare.processor.NullDifferenceGuidelines;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.compare.EObjectMatcher;
import org.teiid.designer.core.compare.EObjectMatcherCache;
import org.teiid.designer.core.compare.EObjectMatcherFactory;
import org.teiid.designer.core.compare.MappingProducer;
import org.w3c.dom.Node;

public class DifferenceProcessorImpl
implements DifferenceProcessor {
    private static final String PLUGINID = "org.teiid.designer.compare";
    protected static final int PROCESSOR_ALREADY_CLOSED = 50001;
    protected static final int ERROR_LOADING_RESOURCES = 50002;
    protected static final int ERROR_CREATING_MAPPING = 50003;
    protected static final int ERROR_COMPUTING_DIFFERENCES = 50004;
    protected static final int MISSING_MAPPING_ADAPTERS = 50005;
    protected static final int NO_PROBLEMS = 50010;
    protected static final int HAS_WARNINGS = 50011;
    protected static final int HAS_ERRORS = 50012;
    protected static final int HAS_WARNINGS_AND_ERRORS = 50013;
    protected static final int NO_WARNINGS_AND_ERRORS = 50014;
    protected static final int AMOUNT_OF_WORK_FOR_LOADING_RESOURCES = 300;
    protected static final int AMOUNT_OF_WORK_FOR_MAPPING_RESOURCES = 1000;
    protected static final int AMOUNT_OF_WORK_FOR_COMUTING_DIFFERENCES = 400;
    protected static final int AMOUNT_OF_WORK_FOR_CREATING_RESULTS = 100;
    protected static final Collection DOM_FEATURE_NAMES = new ArrayList();
    private final ModelSelector beforeSelector;
    private final ModelSelector afterSelector;
    private CompareFactory compareFactory;
    private MappingFactory mappingFactory;
    private DifferenceReport report;
    private boolean closed;
    private final List matcherFactories;
    private final HashMap inputsToObjects;
    private int totalAdditions;
    private int totalDeletions;
    private int totalChanges;
    private DifferenceGuidelines guidelines;
    private MappingProducer mappingProducer;
    private boolean isMultiModel;

    public DifferenceProcessorImpl(ModelSelector selector) {
        this(selector, selector);
    }

    public DifferenceProcessorImpl(ModelSelector beforeSelector, ModelSelector afterSelector) {
        this(beforeSelector, afterSelector, null);
    }

    public DifferenceProcessorImpl(ModelSelector beforeSelector, ModelSelector afterSelector, HashMap mappings) {
        DOM_FEATURE_NAMES.add("description");
        DOM_FEATURE_NAMES.add("applicationInformation");
        DOM_FEATURE_NAMES.add("userInformation");
        CoreArgCheck.isNotNull((Object)beforeSelector);
        CoreArgCheck.isNotNull((Object)afterSelector);
        this.beforeSelector = beforeSelector;
        this.afterSelector = afterSelector;
        this.closed = false;
        this.compareFactory = new CompareFactoryImpl();
        this.mappingFactory = new MappingFactoryImpl();
        this.matcherFactories = new ArrayList();
        this.guidelines = NullDifferenceGuidelines.INSTANCE;
        if (mappings == null) {
            this.inputsToObjects = new HashMap();
        } else {
            this.inputsToObjects = mappings;
            this.isMultiModel = true;
        }
    }

    @Override
    public DifferenceGuidelines getDifferenceGuidelines() {
        return this.guidelines;
    }

    @Override
    public void setDifferenceGuidelines(DifferenceGuidelines guidelines) {
        this.guidelines = guidelines != null ? guidelines : NullDifferenceGuidelines.INSTANCE;
    }

    @Override
    public IStatus execute(IProgressMonitor progressMonitor) {
        IStatus status;
        String msg;
        LinkedList<IStatus> problems;
        IProgressMonitor monitor;
        block43: {
            String analysisSubTask;
            Object[] params;
            block41: {
                List<EObject> afterRoots;
                List<EObject> beforeRoots;
                block39: {
                    if (this.closed) {
                        String msg2 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.The_processor_has_already_been_closed_and_cannot_be_reused", new Object[0]);
                        Status status2 = new Status(4, PLUGINID, 50001, msg2, null);
                        return status2;
                    }
                    monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
                    Object[] taskParams = new Object[]{this.beforeSelector.getLabel(), this.afterSelector.getLabel()};
                    String taskName = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.execute_task_name", taskParams);
                    monitor.beginTask(taskName, 1800);
                    problems = new LinkedList<IStatus>();
                    try {
                        this.report = this.createDifferenceReport();
                    }
                    finally {
                        monitor.worked(100);
                    }
                    beforeRoots = null;
                    afterRoots = null;
                    ModelSelector selector = this.beforeSelector;
                    try {
                        try {
                            String loadingSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Loading_resources_subtask_name", new Object[0]);
                            monitor.subTask(loadingSubTask);
                            selector.open();
                            beforeRoots = selector.getRootObjects();
                            selector = this.afterSelector;
                            selector.open();
                            afterRoots = selector.getRootObjects();
                        }
                        catch (ModelerCoreException e) {
                            params = new Object[]{selector.getLabel(), e.getMessage()};
                            msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Error_loading_resource", params);
                            status = this.newError(50002, msg, e);
                            problems.add(status);
                            monitor.worked(300);
                            break block39;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.worked(300);
                        throw throwable;
                    }
                    monitor.worked(300);
                }
                try {
                    try {
                        analysisSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Performing_mapping", new Object[0]);
                        monitor.subTask(analysisSubTask);
                        if (beforeRoots != null && afterRoots != null) {
                            Mapping mapping = this.createMapping(beforeRoots, afterRoots, problems, monitor, analysisSubTask);
                            this.report.setMapping(mapping);
                        }
                    }
                    catch (Throwable e) {
                        params = new Object[]{e.getMessage()};
                        msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Error_performing_mapping", params);
                        status = this.newError(50003, msg, e);
                        problems.add(status);
                        monitor.worked(1000);
                        break block41;
                    }
                }
                catch (Throwable throwable) {
                    monitor.worked(1000);
                    throw throwable;
                }
                monitor.worked(1000);
            }
            try {
                try {
                    if (this.report.getMapping() != null) {
                        this.totalAdditions = 0;
                        this.totalChanges = 0;
                        this.totalDeletions = 0;
                        analysisSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Computing_differences", new Object[0]);
                        monitor.subTask(analysisSubTask);
                        Mapping rootMapping = this.report.getMapping();
                        if (rootMapping != null) {
                            this.addDifferencesInTransaction(rootMapping, monitor, analysisSubTask);
                        }
                        this.report.setTotalAdditions(this.totalAdditions);
                        this.report.setTotalChanges(this.totalChanges);
                        this.report.setTotalDeletions(this.totalDeletions);
                    }
                }
                catch (Throwable e) {
                    params = new Object[]{e.getMessage()};
                    msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Error_computing_differences", params);
                    status = this.newError(50004, msg, e);
                    problems.add(status);
                    if (!this.isMultiModel) {
                        this.inputsToObjects.clear();
                    }
                    this.totalAdditions = 0;
                    this.totalChanges = 0;
                    this.totalDeletions = 0;
                    monitor.worked(400);
                    break block43;
                }
            }
            catch (Throwable throwable) {
                if (!this.isMultiModel) {
                    this.inputsToObjects.clear();
                }
                this.totalAdditions = 0;
                this.totalChanges = 0;
                this.totalDeletions = 0;
                monitor.worked(400);
                throw throwable;
            }
            if (!this.isMultiModel) {
                this.inputsToObjects.clear();
            }
            this.totalAdditions = 0;
            this.totalChanges = 0;
            this.totalDeletions = 0;
            monitor.worked(400);
        }
        IStatus resultStatus = null;
        try {
            String analysisSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Analyzing_problems", new Object[0]);
            monitor.subTask(analysisSubTask);
            if (problems.isEmpty()) {
                msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_completed", new Object[0]);
                resultStatus = status = new Status(0, PLUGINID, 50010, msg, null);
            } else if (problems.size() == 1) {
                resultStatus = (IStatus)problems.get(0);
            } else {
                int numErrors = 0;
                int numWarnings = 0;
                for (IStatus aStatus : problems) {
                    if (aStatus.getSeverity() == 2) {
                        ++numWarnings;
                        continue;
                    }
                    if (aStatus.getSeverity() != 4) continue;
                    ++numErrors;
                }
                IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
                if (numWarnings != 0 && numErrors == 0) {
                    Object[] params = new Object[]{new Integer(numWarnings)};
                    String msg3 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_resulted_in_warnings", params);
                    resultStatus = new MultiStatus(PLUGINID, 50011, statusArray, msg3, null);
                } else if (numWarnings == 0 && numErrors != 0) {
                    Object[] params = new Object[]{new Integer(numErrors)};
                    String msg4 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_resulted_in_errors", params);
                    resultStatus = new MultiStatus(PLUGINID, 50012, statusArray, msg4, null);
                } else if (numWarnings != 0 && numErrors != 0) {
                    Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                    String msg5 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_resulted_in_warnings_and_errors", params);
                    resultStatus = new MultiStatus(PLUGINID, 50013, statusArray, msg5, null);
                } else {
                    String msg6 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_completed_with_no_warnings_or_errors", new Object[0]);
                    resultStatus = new MultiStatus(PLUGINID, 50014, statusArray, msg6, null);
                }
            }
        }
        finally {
            monitor.worked(100);
        }
        return resultStatus;
    }

    private void addDifferencesInTransaction(Mapping rootMapping, IProgressMonitor monitor, String analysisSubTask) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Differences", (Object)this);
        boolean succeeded = false;
        try {
            try {
                this.addDifferences(rootMapping, monitor, analysisSubTask);
                succeeded = true;
            }
            catch (Exception ex) {
                ModelerCore.Util.log(4, (Throwable)ex, ex.getMessage());
                if (started && succeeded) {
                    ModelerCore.commitTxn();
                }
            }
        }
        finally {
            if (started && succeeded) {
                ModelerCore.commitTxn();
            }
        }
    }

    @Override
    public DifferenceReport getDifferenceReport() {
        return this.report;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.report = null;
        if (this.beforeSelector != null) {
            this.beforeSelector.close();
        }
        if (this.afterSelector != null) {
            this.afterSelector.close();
        }
        this.closed = true;
    }

    protected IStatus newWarning(int code, String msg, Throwable t) {
        return new Status(2, PLUGINID, code, msg, t);
    }

    protected IStatus newInfo(int code, String msg, Throwable t) {
        return new Status(1, PLUGINID, code, msg, t);
    }

    protected IStatus newError(int code, String msg, Throwable t) {
        return new Status(4, PLUGINID, code, msg, t);
    }

    protected IStatus newOk(int code, String msg, Throwable t) {
        return new Status(0, PLUGINID, code, msg, t);
    }

    protected Mapping createMapping(List beforeSiblings, List afterSiblings, List problems, IProgressMonitor monitor, String subtaskPrefix) {
        this.mappingProducer = new MappingProducer(this.inputsToObjects);
        EObjectMatcherCache cache = this.mappingProducer.getEObjectMatcherCache();
        cache.addEObjectMatcherFactories(this.matcherFactories);
        this.doAddMappingAdapters(cache);
        if (cache.getEObjectMatcherFactories().isEmpty()) {
            String msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.No_mapping_adapters", new Object[0]);
            IStatus status = this.newError(50005, msg, null);
            problems.add(status);
            return null;
        }
        MappingFactory factory = this.getMappingFactory();
        Mapping mapping = this.mappingProducer.createMappings(beforeSiblings, afterSiblings, true, factory, monitor);
        DifferenceDescriptor rootDesc = this.getCompareFactory().createDifferenceDescriptor();
        mapping.setHelper((MappingHelper)rootDesc);
        rootDesc.setType(DifferenceType.CHANGE_BELOW_LITERAL);
        return mapping;
    }

    protected void addDifferences(Mapping mapping, IProgressMonitor monitor, String subtaskPrefix) {
        LinkedList<Mapping> mappingsToRemove = new LinkedList<Mapping>();
        for (Mapping nestedMapping : mapping.getNested()) {
            if (this.includeInReport(nestedMapping)) {
                EList inputs = nestedMapping.getInputs();
                EList outputs = nestedMapping.getOutputs();
                if (inputs.isEmpty()) {
                    if (!outputs.isEmpty()) {
                        this.setDescriptor(nestedMapping, DifferenceType.ADDITION_LITERAL);
                        ++this.totalAdditions;
                    }
                } else if (outputs.isEmpty()) {
                    this.setDescriptor(nestedMapping, DifferenceType.DELETION_LITERAL);
                    ++this.totalDeletions;
                } else {
                    DifferenceDescriptor desc = this.setDescriptor(nestedMapping, DifferenceType.NO_CHANGE_LITERAL);
                    boolean changed = this.computeFeatureDifferences(desc, (List)inputs, (List)outputs);
                    if (changed) {
                        desc.setType(DifferenceType.CHANGE_LITERAL);
                        ++this.totalChanges;
                    }
                }
                this.addDifferences(nestedMapping, monitor, subtaskPrefix);
                DifferenceDescriptor descriptor = (DifferenceDescriptor)mapping.getHelper();
                if (((DifferenceDescriptor)nestedMapping.getHelper()).getType() == DifferenceType.NO_CHANGE_LITERAL || descriptor.getType() != DifferenceType.NO_CHANGE_LITERAL) continue;
                descriptor.setType(DifferenceType.CHANGE_BELOW_LITERAL);
                continue;
            }
            mappingsToRemove.add(nestedMapping);
        }
        for (Mapping nestedMapping : mappingsToRemove) {
            nestedMapping.setNestedIn(null);
        }
    }

    protected boolean includeInReport(Mapping nestedMapping) {
        EList inputs = nestedMapping.getInputs();
        EList outputs = nestedMapping.getOutputs();
        EList objects = null;
        if (outputs != null && outputs.size() != 0) {
            objects = outputs;
        }
        if (inputs != null && inputs.size() != 0) {
            objects = inputs;
        }
        if (objects != null) {
            for (EObject obj : objects) {
                if (this.includeInReport(obj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean includeInReport(EObject eobject) {
        EClass eclass = eobject.eClass();
        EPackage epkg = eclass.getEPackage();
        if (!this.guidelines.includeMetamodel(epkg.getNsURI())) {
            return false;
        }
        return this.guidelines.includeMetaclass(eclass);
    }

    protected boolean includeInReport(EStructuralFeature feature) {
        if (!feature.isChangeable()) {
            return false;
        }
        return this.guidelines.includeFeature(feature);
    }

    protected DifferenceDescriptor setDescriptor(Mapping mapping, DifferenceType type) {
        MappingHelper currentHelper = mapping.getHelper();
        DifferenceDescriptor desc = null;
        if (currentHelper == null) {
            desc = this.getCompareFactory().createDifferenceDescriptor();
            desc.setType(type);
            mapping.setHelper((MappingHelper)desc);
        } else if (currentHelper instanceof DifferenceDescriptor) {
            desc = (DifferenceDescriptor)currentHelper;
            if (desc.getType().getValue() == 3) {
                desc.getPropertyDifferences().clear();
            }
            desc.setType(type);
        } else {
            for (MappingHelper childHelper : currentHelper.getNested()) {
                if (!(childHelper instanceof DifferenceDescriptor)) continue;
                desc = (DifferenceDescriptor)currentHelper;
            }
            if (desc == null) {
                desc = this.getCompareFactory().createDifferenceDescriptor();
                desc.setType(type);
                currentHelper.getNested().add((Object)desc);
            }
        }
        return desc;
    }

    protected boolean computeFeatureDifferences(DifferenceDescriptor descriptor, List inputs, List outputs) {
        boolean changed = false;
        if (inputs.size() == 1 && outputs.size() == 1) {
            EObject input = (EObject)inputs.get(0);
            EObject output = (EObject)outputs.get(0);
            changed = this.computeFeatureDifferences(descriptor, input, output);
        }
        return changed;
    }

    protected boolean computeFeatureDifferences(DifferenceDescriptor descriptor, EObject input, EObject output) {
        EClass eclass = input.eClass();
        boolean changed = false;
        EList features = eclass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            boolean sameValue;
            if (!this.includeInReport(feature) || !(feature instanceof EAttribute) && (((EReference)feature).isContainment() || ((EReference)feature).isContainer())) continue;
            Object inputValue = input.eGet(feature);
            Object outputValue = output.eGet(feature);
            boolean bl = sameValue = feature.isMany() ? this.isEqual(feature, (EList)inputValue, (EList)outputValue) : this.isEqual(feature, inputValue, outputValue);
            if (sameValue) continue;
            PropertyDifference diff = this.getCompareFactory().createPropertyDifference();
            diff.setAffectedFeature(feature);
            diff.setDescriptor(descriptor);
            diff.setNewValue(outputValue);
            diff.setOldValue(inputValue);
            changed = true;
        }
        return changed;
    }

    protected boolean isEqual(EStructuralFeature feature, Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (feature instanceof EReference) {
            EObject expectedOutput = (EObject)this.inputsToObjects.get(object1);
            if (!object2.equals(expectedOutput)) {
                URI uri1 = EcoreUtil.getURI((EObject)((EObject)object1));
                URI uri2 = EcoreUtil.getURI((EObject)((EObject)object2));
                if (uri1 != null && uri2 != null && uri1.equals(uri2)) {
                    return true;
                }
                if (this.mappingProducer != null) {
                    EReference reference = (EReference)feature;
                    ArrayList<Object> object1List = new ArrayList<Object>(1);
                    ArrayList<Object> object2List = new ArrayList<Object>(1);
                    object1List.add(object1);
                    object2List.add(object2);
                    List matchers = this.mappingProducer.getEObjectMatcherCache().getEObjectMatchers(reference);
                    Mapping temp = this.mappingFactory.createMapping();
                    for (EObjectMatcher matcher : matchers) {
                        matcher.addMappings(reference, object1List, object2List, temp, this.mappingFactory);
                        if (!object1List.isEmpty()) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        if (object1 instanceof Node && object2 instanceof Node) {
            if (DOM_FEATURE_NAMES.contains(feature.getName())) {
                String txt1 = this.getChildText((Node)object1);
                String txt2 = this.getChildText((Node)object2);
                boolean txtMatch = txt1 == null ? txt2 == null : txt1.equals(txt2);
                return txtMatch;
            }
            return true;
        }
        return object1.equals(object2);
    }

    protected boolean isEqual(EStructuralFeature feature, EList list1, EList list2) {
        int list1Size = list1.size();
        int list2Size = list2.size();
        if (list1Size == 0 && list2Size == 0) {
            return true;
        }
        if (list1Size != list2Size) {
            return false;
        }
        Iterator iter1 = list1.iterator();
        Iterator iter2 = list2.iterator();
        while (iter2.hasNext()) {
            Object obj2;
            Object obj1 = iter1.next();
            boolean valuesAreEqual = this.isEqual(feature, obj1, obj2 = iter2.next());
            if (valuesAreEqual) continue;
            return false;
        }
        return true;
    }

    private String getChildText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
            } else if (type == 4) {
                str.append(this.getChildText(child));
            }
            child = child.getNextSibling();
        }
        return str.toString();
    }

    protected DifferenceReport createDifferenceReport() {
        DifferenceReport reportObj = this.getCompareFactory().createDifferenceReport();
        long now = System.currentTimeMillis();
        String sourceUri = this.beforeSelector.getUri().toString();
        String resultUri = this.afterSelector.getUri().toString();
        reportObj.setAnalysisTime(now);
        reportObj.setSourceUri(sourceUri);
        reportObj.setResultUri(resultUri);
        String label = this.beforeSelector.getLabel();
        if (label != null && label.trim().length() != 0) {
            reportObj.setTitle(label);
        }
        return reportObj;
    }

    public CompareFactory getCompareFactory() {
        return this.compareFactory;
    }

    public MappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    public void setCompareFactory(CompareFactory factory) {
        this.compareFactory = factory;
    }

    public void setMappingFactory(MappingFactory factory) {
        this.mappingFactory = factory;
    }

    @Override
    public List getEObjectMatcherFactories() {
        return this.matcherFactories;
    }

    @Override
    public synchronized void addEObjectMatcherFactories(List factories) {
        for (Object obj : factories) {
            EObjectMatcherFactory factory;
            if (!(obj instanceof EObjectMatcherFactory) || this.matcherFactories.contains(factory = (EObjectMatcherFactory)obj)) continue;
            this.matcherFactories.add(factory);
        }
    }

    protected void doAddMappingAdapters(EObjectMatcherCache cache) {
    }

    public ModelSelector getAfterSelector() {
        return this.afterSelector;
    }

    public ModelSelector getBeforeSelector() {
        return this.beforeSelector;
    }

    public boolean isMultiModel() {
        return this.isMultiModel;
    }
}

