/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.compare.DifferenceProcessor;
import org.teiid.designer.compare.MergeProcessor;
import org.teiid.designer.compare.impl.ComparePackageImpl;
import org.teiid.designer.compare.processor.DifferenceProcessorImpl;
import org.teiid.designer.compare.processor.MergeProcessorImpl;
import org.teiid.designer.compare.selector.EmfResourceSelector;
import org.teiid.designer.compare.selector.InputStreamModelSelector;
import org.teiid.designer.compare.selector.ModelResourceSelector;
import org.teiid.designer.compare.selector.URIModelSelector;
import org.teiid.designer.core.MappingAdapterDescriptor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.compare.EObjectMatcherFactory;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;

public class ModelerComparePlugin
extends Plugin {
    private static final String MISSING_RESOURCE = "<Missing message for key";
    public static final String PLUGIN_ID = "org.teiid.designer.compare";
    public static final String PACKAGE_ID = ModelerComparePlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static final PluginUtil Util = new PluginUtilImpl("org.teiid.designer.compare", I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    private static final ResourceLocator RESOURCE_LOCATOR = new ResourceLocator(){
        private ResourceLocator delegate = EcorePlugin.INSTANCE.getPluginResourceLocator();

        public URL getBaseURL() {
            if (INSTANCE != null) {
                URL baseUrl;
                try {
                    baseUrl = FileLocator.resolve((URL)INSTANCE.getBundle().getEntry("/"));
                }
                catch (IOException iOException) {
                    baseUrl = null;
                }
                return baseUrl;
            }
            try {
                URI uri = URI.createURI((String)this.getClass().getResource("plugin.properties").toString());
                URL baseUrl = new URL(String.valueOf(uri.trimSegments(1).toString()) + "/");
                return baseUrl;
            }
            catch (IOException exception) {
                throw new WrappedException((Exception)exception);
            }
        }

        public Object getImage(String key) {
            try {
                URL baseUrl = this.getBaseURL();
                URL url = new URL(baseUrl + "icons/" + key + ".gif");
                InputStream inputStream = url.openStream();
                inputStream.close();
                return url;
            }
            catch (MalformedURLException exception) {
                throw new WrappedException((Exception)exception);
            }
            catch (IOException iOException) {
                return this.delegate.getImage(key);
            }
        }

        public String getString(String key) {
            String result = Util.getString(key, new Object[0]);
            if (result.startsWith(ModelerComparePlugin.MISSING_RESOURCE)) {
                result = this.delegate.getString(key);
            }
            return result;
        }

        public String getString(String key, Object[] substitutions) {
            String result = Util.getString(key, new Object[0]);
            if (result.startsWith(ModelerComparePlugin.MISSING_RESOURCE)) {
                result = this.delegate.getString(key, substitutions);
            }
            return result;
        }

        public String getString(String key, boolean translate) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.getString(key, substitutions);
        }
    };
    public static boolean DEBUG = false;
    static ModelerComparePlugin INSTANCE = null;

    static {
        ModelerCore.getMetamodelRegistry();
        ComparePackageImpl.init();
    }

    public static ResourceLocator getPluginResourceLocator() {
        return RESOURCE_LOCATOR;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public static DifferenceProcessor createDifferenceProcessor(ModelResource modelResource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource);
        ModelResourceSelector currentSelector = new ModelResourceSelector(modelResource);
        currentSelector.setLabel(modelResource.getPath().toString());
        DifferenceProcessorImpl processor = null;
        if (!modelResource.hasUnsavedChanges()) {
            processor = new DifferenceProcessorImpl(currentSelector);
        } else {
            URI uri = URI.createFileURI((String)modelResource.getResource().getLocation().toFile().getAbsolutePath());
            URIModelSelector savedSelector = new URIModelSelector(uri);
            Object[] params = new Object[]{modelResource.getPath().toString()};
            savedSelector.setLabel(Util.getString("ModelerComparePlugin.SavedModel", params));
            currentSelector.setLabel(Util.getString("ModelerComparePlugin.OpenedModel", params));
            processor = new DifferenceProcessorImpl(savedSelector, currentSelector);
        }
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(ModelResource startingResource, ModelResource endingResource) {
        CoreArgCheck.isNotNull((Object)startingResource);
        CoreArgCheck.isNotNull((Object)endingResource);
        ModelResourceSelector startingSelector = new ModelResourceSelector(startingResource);
        ModelResourceSelector endingSelector = new ModelResourceSelector(endingResource);
        endingSelector.setLabel(startingResource.getPath().toString());
        endingSelector.setLabel(endingResource.getPath().toString());
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(InputStream startingResource, IPath startingResourcePath, ModelResource endingResource, String startingResourceDesc) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)startingResource);
        CoreArgCheck.isNotNull((Object)startingResourcePath);
        CoreArgCheck.isNotNull((Object)endingResource);
        IResource resource = endingResource.getCorrespondingResource();
        URI temporayURI = null;
        if (ModelUtil.isXsdFile((IResource)resource)) {
            temporayURI = InputStreamModelSelector.XSD_URI;
        } else if (ModelUtil.isModelFile((IResource)resource)) {
            temporayURI = InputStreamModelSelector.XMI_URI;
        } else if (ModelUtil.isVdbArchiveFile((IResource)resource)) {
            temporayURI = InputStreamModelSelector.VDB_URI;
        }
        if (temporayURI == null) {
            return null;
        }
        InputStreamModelSelector startingSelector = new InputStreamModelSelector(startingResource, temporayURI);
        ModelResourceSelector endingSelector = new ModelResourceSelector(endingResource);
        startingSelector.setLabel(startingResourceDesc);
        endingSelector.setLabel(endingResource.getPath().toString());
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(Resource startingResource, Resource endingResource) {
        CoreArgCheck.isNotNull((Object)startingResource);
        CoreArgCheck.isNotNull((Object)endingResource);
        EmfResourceSelector startingSelector = new EmfResourceSelector(startingResource);
        EmfResourceSelector endingSelector = new EmfResourceSelector(endingResource);
        startingSelector.setLabel(URI.decode((String)startingResource.getURI().toString()));
        endingSelector.setLabel(URI.decode((String)endingResource.getURI().toString()));
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(Resource startingResource, Resource endingResource, HashMap mappings) {
        CoreArgCheck.isNotNull((Object)startingResource);
        CoreArgCheck.isNotNull((Object)endingResource);
        EmfResourceSelector startingSelector = new EmfResourceSelector(startingResource);
        EmfResourceSelector endingSelector = new EmfResourceSelector(endingResource);
        startingSelector.setLabel(URI.decode((String)startingResource.getURI().toString()));
        endingSelector.setLabel(URI.decode((String)endingResource.getURI().toString()));
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector, mappings);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static MergeProcessor createMergeProcessor(DifferenceProcessor difference) {
        CoreArgCheck.isInstanceOf(DifferenceProcessorImpl.class, (Object)difference);
        return new MergeProcessorImpl((DifferenceProcessorImpl)difference);
    }

    public static MergeProcessor createMergeProcessor(DifferenceProcessor difference, EObject[] externalReferences) {
        CoreArgCheck.isInstanceOf(DifferenceProcessorImpl.class, (Object)difference);
        return new MergeProcessorImpl((DifferenceProcessorImpl)difference, externalReferences);
    }

    public static MergeProcessor createMergeProcessor(DifferenceProcessor difference, EObject[] externalReferences, boolean moveAddsRatherThanCopy) {
        CoreArgCheck.isInstanceOf(DifferenceProcessorImpl.class, (Object)difference);
        return new MergeProcessorImpl((DifferenceProcessorImpl)difference, externalReferences, moveAddsRatherThanCopy);
    }

    public static List createEObjectMatcherFactories() {
        LinkedList<EObjectMatcherFactory> factories = new LinkedList<EObjectMatcherFactory>();
        List adapterDescriptors = ModelerCore.getMappingAdapterDescriptors();
        for (MappingAdapterDescriptor desc : adapterDescriptors) {
            EObjectMatcherFactory factory;
            if (desc == null || (factory = (EObjectMatcherFactory)desc.getExtensionClassInstance()) == null) continue;
            factories.add(factory);
        }
        return factories;
    }
}

