/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbIndexedEntry;
import org.teiid.designer.vdb.manifest.PropertyElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
public class EntryElement
implements Serializable {
    public static final String CHECKSUM = "checksum";
    public static final String INDEX_NAME = "indexName";
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="path")
    private String path;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="property", type=PropertyElement.class)
    private List<PropertyElement> properties;

    public EntryElement() {
    }

    EntryElement(VdbEntry entry) {
        this.path = entry.getName().toString();
        if (entry.getDescription() != null && !entry.getDescription().isEmpty()) {
            this.description = entry.getDescription();
        }
        this.getProperties().add(new PropertyElement(CHECKSUM, Long.toString(entry.getChecksum())));
        if (entry instanceof VdbIndexedEntry) {
            this.getProperties().add(new PropertyElement(INDEX_NAME, ((VdbIndexedEntry)entry).getIndexName()));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getPath() {
        return this.path;
    }

    public List<PropertyElement> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyElement>();
        }
        return this.properties;
    }
}

