/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.vdb.Vdb;

public class VdbSource {
    private Vdb vdb;
    private String name;
    private String jndiName;
    private String translatorName;

    public VdbSource(Vdb vdb, String name, String jndiName, String translatorName) {
        this.vdb = vdb;
        this.name = name;
        this.jndiName = jndiName;
        this.translatorName = translatorName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtilities.equals((String)this.name, (String)name)) {
            this.name = name;
            this.vdb.setModified(this, "modelentry.sourceName", name, this.name);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        if (!StringUtilities.equals((String)this.jndiName, (String)jndiName)) {
            this.jndiName = jndiName;
            this.vdb.setModified(this, "modelEntry.jndiName", jndiName, this.jndiName);
        }
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public void setTranslatorName(String translatorName) {
        if (!StringUtilities.equals((String)this.translatorName, (String)translatorName)) {
            this.translatorName = translatorName;
            this.vdb.setModified(this, "modelEntry.translator", translatorName, this.translatorName);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("VdbSource : ");
        text.append("\n\tsource name = ").append(this.getName());
        text.append("\n\ttranslator name = ").append(this.getTranslatorName());
        text.append("\n\tjndi name = ").append(this.getJndiName());
        return text.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VdbSource other = (VdbSource)object;
        return this.vdb.equals(other.vdb) && CoreStringUtil.equals((String)this.name, (String)other.name) && CoreStringUtil.equals((String)this.translatorName, (String)other.translatorName) && CoreStringUtil.equals((String)this.jndiName, (String)other.jndiName);
    }
}

