/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.debug.model.CamelDebugElement;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;

public class BaseCamelVariable
extends CamelDebugElement
implements IVariable {
    private String fName;
    private Class fType;
    boolean valueChanged = false;
    private BaseCamelValue value;

    public BaseCamelVariable(CamelDebugTarget debugTarget, String name, Class type) {
        super(debugTarget);
        this.fName = name;
        this.fType = type;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.valueChanged;
    }

    public void setValue(String expression) throws DebugException {
        this.notSupported("No variable modifications!", null);
    }

    public void setValue(IValue value) throws DebugException {
        this.value = (BaseCamelValue)value;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    public Class getReferenceType() {
        return this.fType;
    }

    public String getReferenceTypeName() throws DebugException {
        return String.format("%s (id=%d)", this.getVariableDisplayString(), this.getVariableIDCode());
    }

    protected int getVariableIDCode() throws DebugException {
        return this.getValue().getValueString().hashCode();
    }

    protected String getVariableDisplayString() {
        return this.fType.getName();
    }

    public void markChanged() throws DebugException {
        this.valueChanged = true;
    }

    protected String getCurrentEndpointNodeId() throws DebugException {
        CamelDebugTarget cdt = (CamelDebugTarget)this.getDebugTarget();
        return cdt.getSuspendedNodeId();
    }

    protected void updateValueOnRuntime(CamelDebugFacade debugger) throws DebugException {
    }
}

