/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;

public class CamelProcessorValue
extends BaseCamelValue {
    private ArrayList<IVariable> fVariables = new ArrayList();
    private CamelDebugTarget debugTarget;
    private CamelStackFrame stackFrame;
    private String processorId;

    public CamelProcessorValue(CamelDebugTarget target, CamelStackFrame stackFrame, String value, Class type) {
        super(target, value, type);
        this.debugTarget = target;
        this.stackFrame = stackFrame;
        this.processorId = value;
        try {
            this.init();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void init() throws DebugException {
        BaseCamelVariable var = null;
        BaseCamelValue val = null;
        var = new BaseCamelVariable(this.debugTarget, "ProcessorId", String.class);
        val = new BaseCamelValue(this.fTarget, this.getValueString(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "RouteId", String.class);
        val = new BaseCamelValue(this.fTarget, this.getRouteId(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "CamelId", String.class);
        val = new BaseCamelValue(this.fTarget, this.getCamelId(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "CompletedExchanges", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getExchangesCompleted(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "FailedExchanges", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getExchangesFailed(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "TotalExchanges", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getTotalExchanges(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "Redeliveries", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getRedeliveries(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "ExternalRedeliveries", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getExternalRedeliveries(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "HandledFailures", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getFailuresHandled(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "LastProcessingTime", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getLastProcessingTime(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "MinProcessingTime", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getMinProcessingTime(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "AverageProcessingTime", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getMeanProcessingTime(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "MaxProcessingTime", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getMaxProcessingTime(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "TotalProcessingTime", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getTotalProcessingTime(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.fVariables.size() > 0;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    private String getCamelId() {
        return this.stackFrame.getDebugger().getCamelId(this.processorId);
    }

    private String getRouteId() {
        return this.stackFrame.getDebugger().getRouteId(this.processorId);
    }

    private long getExchangesCompleted() {
        return this.stackFrame.getDebugger().getCompletedExchanges(this.processorId);
    }

    private long getExchangesFailed() {
        return this.stackFrame.getDebugger().getFailedExchanges(this.processorId);
    }

    private long getTotalExchanges() {
        return this.stackFrame.getDebugger().getTotalExchanges(this.processorId);
    }

    private long getExternalRedeliveries() {
        return this.stackFrame.getDebugger().getExternalRedeliveries(this.processorId);
    }

    private long getFailuresHandled() {
        return this.stackFrame.getDebugger().getHandledFailures(this.processorId);
    }

    private long getRedeliveries() {
        return this.stackFrame.getDebugger().getRedeliveries(this.processorId);
    }

    private long getLastProcessingTime() {
        return this.stackFrame.getDebugger().getLastProcessingTime(this.processorId);
    }

    private long getMinProcessingTime() {
        return this.stackFrame.getDebugger().getMinProcessingTime(this.processorId);
    }

    private long getMaxProcessingTime() {
        return this.stackFrame.getDebugger().getMaxProcessingTime(this.processorId);
    }

    private long getMeanProcessingTime() {
        return this.stackFrame.getDebugger().getAverageProcessingTime(this.processorId);
    }

    private long getTotalProcessingTime() {
        return this.stackFrame.getDebugger().getTotalProcessingTime(this.processorId);
    }

    @Override
    protected String getVariableDisplayString() {
        return "CamelProcessor";
    }
}

