/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelBodyIncludeFilesVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelBodyIncludeStreamsVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelBodyMaxCharsVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelLogLevelVariable;

public class CamelDebuggerValue
extends BaseCamelValue {
    private ArrayList<IVariable> fVariables = new ArrayList();
    private CamelDebugTarget debugTarget;
    private CamelStackFrame stackFrame;

    public CamelDebuggerValue(CamelDebugTarget target, CamelStackFrame stackFrame, Class type) {
        super(target, "" + ((Object)((Object)target)).hashCode(), type);
        this.debugTarget = target;
        this.stackFrame = stackFrame;
        try {
            this.init();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void init() throws DebugException {
        BaseCamelVariable var = null;
        BaseCamelValue val = null;
        var = new CamelBodyMaxCharsVariable(this.debugTarget, "BodyMaxChars", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getBodyMaxChars(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new CamelBodyIncludeFilesVariable(this.debugTarget, "BodyIncludeFiles", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.isBodyIncludeFiles(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new CamelBodyIncludeStreamsVariable(this.debugTarget, "BodyIncludeStreams", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.isBodyIncludeStreams(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "DebugCounter", String.class);
        val = new BaseCamelValue(this.fTarget, "" + this.getDebugCounter(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new CamelLogLevelVariable(this.debugTarget, "LogLevel", String.class);
        val = new BaseCamelValue(this.fTarget, this.getLogLevel(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.fVariables.size() > 0;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    @Override
    protected String getVariableDisplayString() {
        return "CamelDebuggerSettings";
    }

    private String getLogLevel() {
        return this.stackFrame.getDebugger().getLoggingLevel();
    }

    private long getDebugCounter() {
        return this.stackFrame.getDebugger().getDebugCounter();
    }

    private int getBodyMaxChars() {
        return this.stackFrame.getDebugger().getBodyMaxChars();
    }

    private boolean isBodyIncludeFiles() {
        return this.stackFrame.getDebugger().isBodyIncludeFiles();
    }

    private boolean isBodyIncludeStreams() {
        return this.stackFrame.getDebugger().isBodyIncludeStreams();
    }
}

