/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.event;

import java.util.EventObject;
import java.util.List;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.event.AbstractEventSource;
import org.teiid.core.designer.event.EventBroker;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.util.CoreArgCheck;

public abstract class AbstractEventBroker
extends AbstractEventSource
implements EventBroker {
    private static final String CANNOT_ADD_SELF_AS_LISTENER_MESSAGE = CoreModelerPlugin.Util.getString("AbstractEventBroker.CannotAddSelfAsListener", new Object[0]);
    private boolean shutdownRequested = false;
    private boolean shutdownComplete = false;
    private String name = "";
    private static final boolean EVENT_PERF;
    private static final double EVENT_FLOOR;
    private StringBuffer eventPerfMsg = new StringBuffer();

    static {
        boolean bl = EVENT_PERF = System.getProperty("eventPerf") != null;
        if (EVENT_PERF) {
            double temp = 10.0;
            String txt = System.getProperty("eventFloor");
            if (txt != null) {
                try {
                    temp = Double.parseDouble(txt);
                    temp = temp < 0.0 ? 0.0 : temp;
                }
                catch (NumberFormatException numberFormatException) {
                    temp = 10.0;
                }
            }
            EVENT_FLOOR = temp;
        } else {
            EVENT_FLOOR = 0.0;
        }
    }

    protected AbstractEventBroker() {
    }

    protected void setName(String name) {
        if (name == null) {
            CoreArgCheck.isNotNull(name, CoreModelerPlugin.Util.getString("AbstractEventBroker.The_name_of_the_event_broker_may_not_be_null", new Object[0]));
        }
        if (name.length() == 0) {
            CoreArgCheck.isNotZeroLength(name, CoreModelerPlugin.Util.getString("AbstractEventBroker.The_name_of_the_event_broker_may_not_be_zero-length", new Object[0]));
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void addListener(Class eventClass, EventObjectListener listener) {
        CoreArgCheck.isNotNull(listener, CANNOT_ADD_SELF_AS_LISTENER_MESSAGE);
        this.assertReady();
        super.addListener(eventClass, listener);
    }

    @Override
    public void addListener(EventObjectListener listener) {
        CoreArgCheck.isNotNull(listener, CANNOT_ADD_SELF_AS_LISTENER_MESSAGE);
        this.assertReady();
        super.addListener(listener);
    }

    @Override
    public void processEvent(EventObject obj) {
        this.assertReady();
        if (obj != null) {
            this.process(obj);
        }
    }

    public boolean isShutdown() {
        return this.isShutdownComplete();
    }

    protected void notifyListeners(EventObject obj) {
        if (obj != null) {
            if (EVENT_PERF && this.eventPerfMsg.length() == 0) {
                this.eventPerfMsg.append('\n');
            }
            double eventTime = 0.0;
            int count = 0;
            List listeners = super.getListeners(obj.getClass());
            for (EventObjectListener listener : listeners) {
                if (listener == null) continue;
                try {
                    if (EVENT_PERF) {
                        double start = System.currentTimeMillis();
                        listener.processEvent(obj);
                        double totalTime = (double)System.currentTimeMillis() - start;
                        eventTime += totalTime;
                        ++count;
                        if (!(totalTime >= EVENT_FLOOR)) continue;
                        Object[] params = new Object[]{new Double(totalTime), AbstractEventBroker.getShortClassName(listener)};
                        this.eventPerfMsg.append(CoreModelerPlugin.Util.getString("AbstractEventBroker.eventFloorExceeded", params));
                        continue;
                    }
                    listener.processEvent(obj);
                }
                catch (Throwable t) {
                    CoreModelerPlugin.Util.log(4, t, CoreModelerPlugin.Util.getString("AbstractEventBroker.Error_during_event_processing", (Object)this.getName()));
                }
            }
            if (EVENT_PERF && eventTime >= EVENT_FLOOR) {
                Object[] params = new Object[]{new Double(eventTime), new Integer(count), AbstractEventBroker.getShortClassName(obj), AbstractEventBroker.getShortClassName(obj.getSource())};
                this.eventPerfMsg.append(CoreModelerPlugin.Util.getString("AbstractEventBroker.basePerformanceMessage", params));
                this.eventPerfMsg.append('\n');
                CoreModelerPlugin.Util.log(4, this.eventPerfMsg.toString());
                this.eventPerfMsg.setLength(0);
            }
        }
    }

    protected void assertReady() {
        if (this.shutdownRequested || this.shutdownComplete) {
            throw new IllegalStateException(CoreModelerPlugin.Util.getString("AbstractEventBroker.No_events_can_be_processed_EventBroker_is_shutdown", (Object)this.getName()));
        }
    }

    private static String getShortClassName(Object theObject) {
        String className = theObject.getClass().getName();
        int index = className.lastIndexOf(46);
        return index == -1 ? className : className.substring(index + 1);
    }

    protected abstract void process(EventObject var1);

    protected abstract void waitToCompleteShutdown();

    protected boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    protected boolean isShutdownComplete() {
        return this.shutdownComplete;
    }

    protected void setShutdownComplete(boolean shutdownComplete) {
        this.shutdownComplete = shutdownComplete;
    }
}

