/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDElementDeclarationImpl;
import org.eclipse.xsd.impl.XSDModelGroupImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.teiid.designer.modelgenerator.wsdl.model.Part;

public class SchemaTreeModel {
    Collection<SchemaNode> nodeList = new ArrayList<SchemaNode>();
    String namespace = null;
    String rootPath = null;
    public static Map<String, String> namespaceMap = new HashMap<String, String>();
    public Part[] partArray = null;

    public Map<String, String> getNamespaceMap() {
        return namespaceMap;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Part[] getPartArray() {
        return this.partArray;
    }

    public void setPartArray(Part[] partArray) {
        this.partArray = partArray;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        SchemaTreeModel.namespaceMap = namespaceMap;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public Collection<SchemaNode> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(Collection<SchemaNode> nodeList) {
        this.nodeList = nodeList;
    }

    public String getRootNodeXpath() {
        for (SchemaNode node : this.nodeList) {
            if (!node.isRoot) continue;
            return node.getRelativeXpath();
        }
        return "";
    }

    public String determineRootPath() {
        StringBuilder commonRoot = new StringBuilder();
        ArrayList<String> segmentList = new ArrayList<String>();
        for (SchemaNode node : this.nodeList) {
            String path;
            if (!node.children.isEmpty() || (path = node.getFullPathMinusLastSegment()).equals("")) continue;
            segmentList.add(path);
        }
        String[][] segments = new String[segmentList.size()][];
        int shortestPathLength = 0;
        int i = 0;
        while (i < segmentList.size()) {
            segments[i] = ((String)segmentList.get(i)).split("/");
            if (i == 0) {
                shortestPathLength = segments[i].length;
            }
            if (shortestPathLength > segments[i].length) {
                shortestPathLength = segments[i].length;
            }
            ++i;
        }
        int j = 0;
        while (j < shortestPathLength) {
            String thisSegment = segments[0][j];
            boolean allMatched = true;
            int i2 = 0;
            while (i2 < segments.length && allMatched) {
                if (segments[i2].length < j) {
                    allMatched = false;
                    break;
                }
                allMatched &= segments[i2][j].equals(thisSegment);
                ++i2;
            }
            if (!allMatched) break;
            commonRoot.append("/").append(thisSegment);
            ++j;
        }
        commonRoot = new StringBuilder(commonRoot.toString().replaceAll("//", "/"));
        return commonRoot.toString();
    }

    private String getNamespacePrefix(Object obj) {
        String nsPrefix = "";
        String ns = "";
        if (obj instanceof XSDParticleImpl && ((XSDParticleImpl)obj).getContent() instanceof XSDElementDeclarationImpl) {
            ns = ((XSDElementDeclarationImpl)((XSDParticleImpl)obj).getContent()).getTargetNamespace();
        } else if (obj instanceof XSDElementDeclarationImpl) {
            ns = ((XSDElementDeclarationImpl)obj).getTargetNamespace();
        }
        for (String nsKey : namespaceMap.keySet()) {
            if (!namespaceMap.get(nsKey).equals(ns)) continue;
            nsPrefix = nsKey;
            break;
        }
        if (nsPrefix == null) {
            nsPrefix = "";
        }
        return nsPrefix.equals("") ? nsPrefix : String.valueOf(nsPrefix) + ":";
    }

    public class SchemaNode {
        protected Object element;
        protected SchemaNode parent;
        protected boolean isRoot = false;
        protected Collection<SchemaNode> children = new ArrayList<SchemaNode>();

        public SchemaNode() {
            this.parent = null;
            this.element = null;
        }

        public SchemaNode(Object element, SchemaNode parent, SchemaNode child, boolean isRoot) {
            this.element = element;
            this.parent = parent;
            this.setRoot(isRoot);
            if (child != null) {
                this.children.add(child);
            }
        }

        public void addChild(SchemaNode child) {
            this.children.add(child);
        }

        public Collection<SchemaNode> getChildren() {
            return this.children;
        }

        public void setParent(SchemaNode parent) {
            this.parent = parent;
        }

        public void setElement(Object element) {
            this.element = element;
        }

        public SchemaNode getParent() {
            return this.parent;
        }

        public Object getElement() {
            return this.element;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public void setRoot(boolean isRoot) {
            this.isRoot = isRoot;
        }

        public String getRelativeXpath() {
            String name = "";
            if (this.element instanceof XSDTypeDefinition) {
                name = ((XSDTypeDefinition)this.element).getName();
                if (name == null) {
                    name = ((XSDTypeDefinition)this.element).getAliasName();
                }
            } else if (this.element instanceof XSDParticleImpl && ((XSDParticleImpl)this.element).getTerm() instanceof XSDElementDeclaration) {
                XSDElementDeclaration xed = (XSDElementDeclaration)((XSDParticleImpl)this.element).getTerm();
                name = xed.getName() != null ? xed.getName() : xed.getAliasName();
            }
            return "/" + SchemaTreeModel.this.getNamespacePrefix(this.element) + name;
        }

        public String getParentXpath() {
            Stack stack = new Stack();
            SchemaNode parent = this.getParent();
            StringBuilder xpath = new StringBuilder();
            if (parent == null) {
                return "";
            }
            this.getParentXpath(stack, parent);
            int stackSize = stack.size();
            int i = 0;
            while (i < stackSize) {
                xpath.append(stack.pop());
                ++i;
            }
            return xpath.toString();
        }

        public String getFullPath() {
            return String.valueOf(this.getParentXpath()) + this.getRelativeXpath();
        }

        public String getFullPathMinusLastSegment() {
            String relativePath = this.getRelativeXpath();
            if (!relativePath.isEmpty()) {
                int i = relativePath.lastIndexOf("/");
                relativePath = i == 0 ? "" : relativePath.substring(0, i - 1);
            }
            return String.valueOf(this.getParentXpath()) + relativePath;
        }

        private void getParentXpath(Stack stack, SchemaNode parent) {
            if (parent == null) {
                return;
            }
            Object parentElement = parent.getElement();
            String name = null;
            if (parentElement instanceof XSDParticleImpl && ((XSDParticleImpl)parentElement).getContent() instanceof XSDElementDeclarationImpl) {
                name = ((XSDElementDeclarationImpl)((XSDParticleImpl)parentElement).getContent()).getName();
                if (name == null) {
                    name = ((XSDElementDeclarationImpl)((XSDParticleImpl)parentElement).getContent()).getResolvedElementDeclaration().getName();
                }
                stack.push("/" + SchemaTreeModel.this.getNamespacePrefix(parentElement) + name);
            } else if (parentElement instanceof XSDElementDeclarationImpl) {
                name = ((XSDElementDeclarationImpl)parentElement).getName();
                stack.push("/" + SchemaTreeModel.this.getNamespacePrefix(parentElement) + name);
            } else if (!(parentElement instanceof XSDModelGroupImpl)) {
                return;
            }
            if (parent.getParent() != null) {
                this.getParentXpath(stack, parent.getParent());
            }
        }

        public String toString() {
            return "" + this.getElement();
        }
    }
}

