/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.impl.ModelImpl;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureGenerator;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaTreeModel;
import org.teiid.designer.query.proc.wsdl.IWsdlConstants;
import org.teiid.designer.query.proc.wsdl.IWsdlProcedureInfo;
import org.teiid.designer.query.sql.ISQLConstants;

public abstract class ProcedureInfo
implements IWsdlProcedureInfo,
ISQLConstants {
    private StringNameValidator nameValidator;
    public SchemaTreeModel treeModel = null;
    public HashMap<String, String> reverseNSMap;
    private Collection<ColumnInfo> bodyColumnInfoList;
    private Collection<ColumnInfo> headerColumnInfoList;
    private Map<String, String> namespaceMap;
    private Operation operation;
    private ProcedureGenerator generator;
    private String procedureName;
    private String rootPath = "";
    private IWsdlConstants.ProcedureType type;
    private boolean changed;
    private boolean initializing = true;

    public ProcedureInfo(Operation operation, IWsdlConstants.ProcedureType type, ProcedureGenerator generator) {
        this.operation = operation;
        this.bodyColumnInfoList = new ArrayList<ColumnInfo>();
        this.headerColumnInfoList = new ArrayList<ColumnInfo>();
        this.namespaceMap = new HashMap<String, String>();
        try {
            this.reverseNSMap = (HashMap)((ModelImpl)generator.getImportManager().getWSDLModel()).getReverseNamespaces();
        }
        catch (ModelGenerationException ex) {
            ex.printStackTrace();
        }
        this.type = type;
        this.generator = generator;
        this.nameValidator = new StringNameValidator(true);
        this.initializing = false;
    }

    public abstract String getDefaultProcedureName();

    protected ProcedureGenerator getGenerator() {
        return this.generator;
    }

    public ProcedureGenerator getWrapperProcedure() {
        return this.generator;
    }

    public SchemaTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(SchemaTreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public void addNamespace(String key, String value) {
        for (String nsKey : this.namespaceMap.keySet()) {
            String ns = this.namespaceMap.get(nsKey);
            if (!value.endsWith(ns)) continue;
            return;
        }
        this.namespaceMap.put(key, value);
        this.setChanged(true);
    }

    public void addNamespaces(Map<String, String> namespaces) {
        this.namespaceMap.putAll(namespaces);
        this.setChanged(true);
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    public IWsdlConstants.ProcedureType getType() {
        return this.type;
    }

    public ColumnInfo[] getBodyColumnInfoList() {
        return this.bodyColumnInfoList.toArray(new ColumnInfo[this.bodyColumnInfoList.size()]);
    }

    public ColumnInfo addBodyColumn(String name, boolean ordinality, String datatype, String defaultValue, String path, String namespace) {
        ColumnInfo newInfo = new ColumnInfo(name, ordinality, datatype, defaultValue, path, namespace);
        this.bodyColumnInfoList.add(newInfo);
        this.setChanged(true);
        return newInfo;
    }

    public void removeBodyColumn(ColumnInfo theInfo) {
        this.bodyColumnInfoList.remove(theInfo);
        this.setChanged(true);
    }

    public void moveBodyColumnUp(ColumnInfo columnInfo) {
        int startIndex = this.getBodyColumnIndex(columnInfo);
        if (startIndex > 0) {
            ColumnInfo priorInfo = this.getBodyColumnInfoList()[startIndex - 1];
            ColumnInfo[] infos = this.getBodyColumnInfoList();
            infos[startIndex - 1] = columnInfo;
            infos[startIndex] = priorInfo;
            ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>(infos.length);
            ColumnInfo[] columnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo info = columnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.bodyColumnInfoList = colInfos;
            this.setChanged(true);
        }
    }

    public void moveBodyColumnDown(ColumnInfo columnInfo) {
        int startIndex = this.getBodyColumnIndex(columnInfo);
        if (startIndex < this.getBodyColumnInfoList().length - 1) {
            ColumnInfo afterInfo = this.getBodyColumnInfoList()[startIndex + 1];
            ColumnInfo[] infos = this.getBodyColumnInfoList();
            infos[startIndex + 1] = columnInfo;
            infos[startIndex] = afterInfo;
            ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>(infos.length);
            ColumnInfo[] columnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo info = columnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.bodyColumnInfoList = colInfos;
            this.setChanged(true);
        }
    }

    public boolean canMoveBodyColumnUp(ColumnInfo columnInfo) {
        return this.getBodyColumnIndex(columnInfo) > 0;
    }

    public boolean canMoveBodyColumnDown(ColumnInfo columnInfo) {
        return this.getBodyColumnIndex(columnInfo) < this.getBodyColumnInfoList().length - 1;
    }

    private int getBodyColumnIndex(ColumnInfo columnInfo) {
        int i = 0;
        ColumnInfo[] columnInfoArray = this.getBodyColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo colInfo = columnInfoArray[n2];
            if (colInfo == columnInfo) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public ColumnInfo[] getHeaderColumnInfoList() {
        return this.headerColumnInfoList.toArray(new ColumnInfo[this.headerColumnInfoList.size()]);
    }

    public ColumnInfo addHeaderColumn(String name, boolean ordinality, String datatype, String defaultValue, String path, String namespace) {
        ColumnInfo newInfo = new ColumnInfo(name, ordinality, datatype, defaultValue, path, namespace);
        this.headerColumnInfoList.add(newInfo);
        this.setChanged(true);
        return newInfo;
    }

    public void removeHeaderColumn(ColumnInfo theInfo) {
        this.headerColumnInfoList.remove(theInfo);
        this.setChanged(true);
    }

    public void moveHeaderColumnUp(ColumnInfo columnInfo) {
        int startIndex = this.getHeaderColumnIndex(columnInfo);
        if (startIndex > 0) {
            ColumnInfo priorInfo = this.getHeaderColumnInfoList()[startIndex - 1];
            ColumnInfo[] infos = this.getHeaderColumnInfoList();
            infos[startIndex - 1] = columnInfo;
            infos[startIndex] = priorInfo;
            ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>(infos.length);
            ColumnInfo[] columnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo info = columnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.headerColumnInfoList = colInfos;
            this.setChanged(true);
        }
    }

    public void moveHeaderColumnDown(ColumnInfo columnInfo) {
        int startIndex = this.getHeaderColumnIndex(columnInfo);
        if (startIndex < this.getHeaderColumnInfoList().length - 1) {
            ColumnInfo afterInfo = this.getHeaderColumnInfoList()[startIndex + 1];
            ColumnInfo[] infos = this.getHeaderColumnInfoList();
            infos[startIndex + 1] = columnInfo;
            infos[startIndex] = afterInfo;
            ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>(infos.length);
            ColumnInfo[] columnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo info = columnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.headerColumnInfoList = colInfos;
            this.setChanged(true);
        }
    }

    public boolean canMoveHeaderColumnUp(ColumnInfo columnInfo) {
        return this.getHeaderColumnIndex(columnInfo) > 0;
    }

    public boolean canMoveHeaderColumnDown(ColumnInfo columnInfo) {
        return this.getHeaderColumnIndex(columnInfo) < this.getHeaderColumnInfoList().length - 1;
    }

    private int getHeaderColumnIndex(ColumnInfo columnInfo) {
        int i = 0;
        ColumnInfo[] columnInfoArray = this.getHeaderColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo colInfo = columnInfoArray[n2];
            if (colInfo == columnInfo) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public void columnChanged(ColumnInfo columnInfo) {
        this.setChanged(true);
    }

    public void setOrdinality(ColumnInfo columnInfo, boolean value) {
        if (!value) {
            columnInfo.setOrdinality(false);
        } else {
            for (ColumnInfo info : this.bodyColumnInfoList) {
                if (info == columnInfo || !info.getOrdinality()) continue;
                info.setOrdinality(false);
            }
            if (!columnInfo.getDatatype().equalsIgnoreCase("integer")) {
                columnInfo.setDatatype("integer");
            }
            columnInfo.setOrdinality(true);
        }
        this.setChanged(true);
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getRootPath() {
        return this.getGenerator().getImportManager().isMessageServiceMode() ? "/soap:Envelope" : this.rootPath;
    }

    public void setRootPath(String path) {
        ColumnInfo colInfo;
        this.rootPath = path;
        ColumnInfo[] columnInfoArray = this.getBodyColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            colInfo = columnInfoArray[n2];
            colInfo.setRootPath(this.rootPath);
            ++n2;
        }
        columnInfoArray = this.getHeaderColumnInfoList();
        n = columnInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            colInfo = columnInfoArray[n2];
            colInfo.setRootPath(this.rootPath);
            ++n2;
        }
        this.setChanged(true);
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
        this.setChanged(true);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public String getUniqueBodyColumnName(String proposedName) {
        ColumnInfo[] columnInfoArray = this.getBodyColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo info = columnInfoArray[n2];
            this.nameValidator.addExistingName(info.getName());
            ++n2;
        }
        String changedName = this.nameValidator.createUniqueName(proposedName);
        String finalName = changedName == null ? proposedName : changedName;
        this.nameValidator.clearExistingNames();
        return finalName;
    }

    public String getUniqueHeaderColumnName(String proposedName) {
        ColumnInfo[] columnInfoArray = this.getHeaderColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo info = columnInfoArray[n2];
            this.nameValidator.addExistingName(info.getName());
            ++n2;
        }
        String changedName = this.nameValidator.createUniqueName(proposedName);
        String finalName = changedName == null ? proposedName : changedName;
        this.nameValidator.clearExistingNames();
        return finalName;
    }

    public void setChanged(boolean value) {
        this.changed = value;
        if (this.changed && !this.initializing) {
            this.generator.setChanged(this.changed);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    abstract String getSqlStringTemplate();

    abstract String getSqlString(Properties var1);

    public HashMap<String, String> getReverseNSMap() {
        return this.reverseNSMap;
    }
}

