/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureGenerator;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;

public class ImportManagerValidator {
    public static final DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();
    String PLUGIN_ID = "org.teiid.designer.modelgenerator.wsdl.ui";
    WSDLImportWizardManager manager;
    IStatus connectionProfileStatus;
    IStatus operationsStatus;
    IStatus modelsStatus;
    Map<ProcedureGenerator, IStatus> proceduresStatusMap;

    public ImportManagerValidator(WSDLImportWizardManager manager) {
        this.manager = manager;
        this.proceduresStatusMap = new HashMap<ProcedureGenerator, IStatus>(10);
    }

    public void validate() {
        this.connectionProfileStatus = this.validateConnectionProfile();
        this.modelsStatus = this.validateResourceInfo();
        this.operationsStatus = this.validateProcedures();
    }

    public IStatus getConnectionProfileStatus() {
        if (this.connectionProfileStatus == null) {
            this.validate();
        }
        return this.connectionProfileStatus;
    }

    public IStatus getOperationsStatus() {
        if (this.operationsStatus == null) {
            this.validate();
        }
        return this.operationsStatus;
    }

    public IStatus getModelsStatus() {
        if (this.modelsStatus == null) {
            this.validate();
        }
        return this.modelsStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPrimaryMessage(IStatus status) {
        if (!(status instanceof MultiStatus) || status.getChildren().length <= 0) return status.getMessage();
        if (status.getMessage() == null || status.getMessage().trim().length() != 0) return status.getMessage();
        int maxSeverity = status.getSeverity();
        IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus childStatus = iStatusArray[n2];
            if (maxSeverity == childStatus.getSeverity()) {
                return childStatus.getMessage();
            }
            ++n2;
        }
        return "";
    }

    public IStatus getProcedureStatus(ProcedureGenerator generator) {
        return this.proceduresStatusMap.get(generator);
    }

    public IStatus getWorstProcedureStatus() {
        MultiStatus status = new MultiStatus(this.PLUGIN_ID, 0, null, null);
        for (ProcedureGenerator generator : this.manager.getProcedureGenerators()) {
            IStatus theStatus = this.proceduresStatusMap.get(generator);
            if (theStatus == null) continue;
            status.merge(theStatus);
        }
        return status;
    }

    private IStatus validateConnectionProfile() {
        String[] expectedProperties;
        MultiStatus status = new MultiStatus(this.PLUGIN_ID, 0, null, null);
        IConnectionProfile connectionProfile = this.manager.getConnectionProfile();
        if (connectionProfile == null) {
            status.add(this.createStatus(4, Messages.Status_ConnectionProfileMissing));
            return status;
        }
        Properties properties = connectionProfile.getBaseProperties();
        String[] stringArray = expectedProperties = new String[]{"EndPointName", "EndPoint", "DefaultBinding", "SecurityType"};
        int n = expectedProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyKey = stringArray[n2];
            if (properties.get(propertyKey) == null) {
                status.add(this.createStatus(4, NLS.bind((String)Messages.Status_ConnectionProfilePropertyMissing, (Object)propertyKey)));
                break;
            }
            ++n2;
        }
        return status;
    }

    private IStatus validateResourceInfo() {
        Status newStatus;
        MultiStatus status = new MultiStatus(this.PLUGIN_ID, 0, null, null);
        if (this.manager.getSourceModelLocation() == null) {
            status.add(this.createStatus(4, Messages.Status_SourceModelLocationUndefined));
        }
        IStatus nameStatus = null;
        if (CoreStringUtil.isEmpty((String)this.manager.getSourceModelName())) {
            status.add(this.createStatus(4, Messages.Status_SourceModelNameUndefined));
        } else {
            nameStatus = ModelNameUtil.validate((String)this.manager.getSourceModelName(), (String)".xmi", (int)1);
            if (nameStatus.getSeverity() == 4) {
                newStatus = new Status(nameStatus.getSeverity(), nameStatus.getPlugin(), String.valueOf(ModelNameUtil.MESSAGES.INVALID_SOURCE_MODEL_NAME) + nameStatus.getMessage());
                status.add((IStatus)newStatus);
            }
        }
        if (this.manager.getViewModelLocation() == null) {
            status.add(this.createStatus(4, Messages.Status_ViewModelLocationUndefined));
        }
        if (CoreStringUtil.isEmpty((String)this.manager.getViewModelName())) {
            status.add(this.createStatus(4, Messages.Status_ViewModelNameUndefined));
        } else {
            nameStatus = ModelNameUtil.validate((String)this.manager.getViewModelName(), (String)".xmi", (int)1);
            if (nameStatus.getSeverity() == 4) {
                newStatus = new Status(nameStatus.getSeverity(), nameStatus.getPlugin(), String.valueOf(ModelNameUtil.MESSAGES.INVALID_VIEW_MODEL_NAME) + nameStatus.getMessage());
                status.add((IStatus)newStatus);
            }
        }
        if (status.isOK()) {
            if (this.manager.doGenerateDefaultProcedures()) {
                return this.createStatus(0, Messages.Status_AllOkClickFinishToGenerateProcedures);
            }
            return this.createStatus(0, Messages.Status_AllOkClickNextToDefineProcedures);
        }
        this.manager.setChanged(false);
        return status;
    }

    private IStatus validateProcedures() {
        if (this.manager.getProcedureGenerators().isEmpty()) {
            return this.createStatus(2, Messages.Error_NoOperationsSelected);
        }
        MultiStatus status = new MultiStatus(this.PLUGIN_ID, 0, null, null);
        for (ProcedureGenerator generator : this.manager.getProcedureGenerators()) {
            IStatus theStatus = generator.validate();
            this.proceduresStatusMap.put(generator, theStatus);
            if (theStatus == null) continue;
            status.merge(theStatus);
        }
        return status;
    }

    private IStatus createStatus(int severity, String message) {
        return new Status(severity, this.PLUGIN_ID, message);
    }

    public static boolean isValidDatatype(String type) {
        if (type == null) {
            return false;
        }
        EObject dType = null;
        try {
            dType = datatypeManager.findDatatype(type);
        }
        catch (ModelerCoreException ex) {
            ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)ex);
        }
        return dType != null;
    }
}

