/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.util.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.ui.dialogs.ConnectionProfileWorker;
import org.teiid.designer.datatools.ui.dialogs.IProfileChangedListener;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.util.ModelGeneratorWsdlUiUtil;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.ui.common.dialog.FolderSelectionDialog;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class SelectWsdlPage
extends WizardPage
implements Listener,
IProfileChangedListener,
FileUtils.Constants,
ModelGeneratorWsdlUiConstants,
ModelGeneratorWsdlUiConstants.Images,
ModelGeneratorWsdlUiConstants.HelpContexts {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SelectWsdlPage.class);
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private static final String EMPTY_STR = "";
    private Button buttonValidateWSDL;
    CLabel wsdlURIText;
    Text textFieldTargetModelLocation;
    Button buttonSelectTargetModelLocation;
    private Button newCPButton;
    private Button editCPButton;
    private WSDLImportWizardManager importManager;
    private MultiStatus wsdlStatus;
    private Text sourceModelContainerText;
    private Text sourceModelFileText;
    private Text sourceHelpText;
    private IPath sourceModelFilePath;
    private IContainer targetModelLocation;
    private boolean initializing = false;
    private Combo connectionProfilesCombo;
    private ILabelProvider profileLabelProvider;
    private ConnectionProfileWorker profileWorker;
    boolean synchronizing = false;
    private ViewerFilter targetLocationFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean projectOpen;
            boolean result = false;
            if (element instanceof IResource && (projectOpen = ((IResource)element).getProject().isOpen())) {
                if (element instanceof IProject) {
                    result = true;
                } else if (element instanceof IFolder) {
                    result = true;
                }
            }
            return result;
        }
    };
    final ViewerFilter sourceModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            ModelerCore.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalSourceModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    public SelectWsdlPage(WSDLImportWizardManager theImportManager) {
        super(SelectWsdlPage.class.getSimpleName(), SelectWsdlPage.getString("title"), null);
        this.importManager = theImportManager;
        this.setImageDescriptor(ModelGeneratorWsdlUiUtil.getImageDescriptor("icons/full/wizban/new_wsdl_wiz.gif"));
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.buttonSelectTargetModelLocation) {
                this.handleBrowseWorkspaceForTargetModelLocation();
                validate = true;
            } else if (event.widget == this.buttonValidateWSDL) {
                this.handleValidateWSDLButtonPressed();
                validate = true;
            }
            if (validate) {
                this.setPageStatus();
            }
        }
    }

    private void updateWidgetEnablements() {
        this.updateValidateWSDLButtonEnablement();
    }

    private void updateValidateWSDLButtonEnablement() {
        if (this.wsdlStatus != null && this.wsdlStatus.isOK()) {
            this.buttonValidateWSDL.setEnabled(false);
        } else if (this.importManager.getWSDLFileUri() != null) {
            this.buttonValidateWSDL.setEnabled(true);
        } else {
            this.buttonValidateWSDL.setEnabled(false);
        }
    }

    public void createControl(Composite theParent) {
        this.profileWorker = new ConnectionProfileWorker(this.getShell(), "org.eclipse.datatools.enablement.oda.ws", (IProfileChangedListener)this);
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "org.teiid.designer.modelgenerator.wsdl.ui.wsdlSelectionPage");
        this.createSourceSelectionComposite(pnlMain);
        this.createSourceModelGroup(pnlMain);
        this.createTargetSelectionComposite(pnlMain);
        this.setPageStatus();
        this.restoreState();
    }

    private void createSourceSelectionComposite(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        Group profileGroup = WidgetFactory.createGroup((Composite)pnl, (String)SelectWsdlPage.getString("profileLabel.text"), (int)0, (int)2, (int)3);
        profileGroup.setLayoutData((Object)new GridData(768));
        this.profileLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((IConnectionProfile)source).getName();
            }
        };
        this.connectionProfilesCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, (List)this.profileWorker.getProfiles(), (ILabelProvider)this.profileLabelProvider, (boolean)true);
        this.connectionProfilesCombo.setForeground(Display.getCurrent().getSystemColor(10));
        this.connectionProfilesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectWsdlPage.this.handleConnectionProfileSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.connectionProfilesCombo.setVisibleItemCount(10);
        this.newCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)SelectWsdlPage.getString("new.label"));
        this.newCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectWsdlPage.this.profileWorker.create();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)SelectWsdlPage.getString("edit.label"));
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectWsdlPage.this.profileWorker.edit();
            }
        });
        Group optionsGroup = WidgetFactory.createGroup((Composite)pnl, (String)SelectWsdlPage.getString("wsdlLabel.text"), (int)4, (int)2, (int)2);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.wsdlURIText = WidgetFactory.createLabel((Composite)optionsGroup, (int)768);
        this.wsdlURIText.setToolTipText(SelectWsdlPage.getString("workspaceTextField.tooltip"));
        this.wsdlURIText.setForeground(Display.getCurrent().getSystemColor(10));
        this.buttonValidateWSDL = WidgetFactory.createButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("validateWsdlButton.text"), (int)128, (int)1);
        this.buttonValidateWSDL.setToolTipText(SelectWsdlPage.getString("validateWsdlButton.tooltip"));
        this.buttonValidateWSDL.addListener(13, (Listener)this);
        this.updateWidgetEnablements();
    }

    private void handleConnectionProfileSelected() {
        String name;
        int selIndex = this.connectionProfilesCombo.getSelectionIndex();
        if (selIndex >= 0 && (name = this.connectionProfilesCombo.getItem(selIndex)) != null) {
            IConnectionProfile profile = this.profileWorker.getProfile(name);
            this.profileWorker.setSelection(profile);
            this.importManager.setConnectionProfile(profile);
            this.refreshUiFromManager();
        }
    }

    private void createTargetSelectionComposite(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        Group optionsGroup = WidgetFactory.createGroup((Composite)pnl, (String)SelectWsdlPage.getString("targetLocationGroup.text"), (int)0, (int)1, (int)2);
        GridData gdRadioGroup = new GridData(768);
        optionsGroup.setLayoutData((Object)gdRadioGroup);
        IContainer location = this.importManager.getViewModelLocation();
        String name = location == null ? null : location.getFullPath().makeRelative().toString();
        this.textFieldTargetModelLocation = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
        String text = SelectWsdlPage.getString("targetModelLocationTextField.tooltip");
        this.textFieldTargetModelLocation.setToolTipText(text);
        if (name != null) {
            this.textFieldTargetModelLocation.setText(name);
        }
        this.textFieldTargetModelLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SelectWsdlPage.this.setPageStatus();
            }
        });
        this.buttonSelectTargetModelLocation = WidgetFactory.createButton((Composite)optionsGroup, (String)SelectWsdlPage.getString("targetModelLocationBrowseButton.text"), (int)4);
        this.buttonSelectTargetModelLocation.setToolTipText(SelectWsdlPage.getString("targetModelLocationBrowseButton.tooltip"));
        this.buttonSelectTargetModelLocation.addListener(13, (Listener)this);
    }

    private void createSourceModelGroup(Composite parent) {
        Group sourceGroup = WidgetFactory.createGroup((Composite)parent, (String)"Source Model Definition", (int)0, (int)1, (int)3);
        sourceGroup.setLayoutData((Object)new GridData(768));
        Label locationLabel = new Label((Composite)sourceGroup, 0);
        locationLabel.setText("Location");
        this.sourceModelContainerText = new Text((Composite)sourceGroup, 2052);
        GridData gridData = new GridData(768);
        this.sourceModelContainerText.setLayoutData((Object)gridData);
        this.sourceModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
        this.sourceModelContainerText.setForeground(WidgetUtil.getDarkBlueColor());
        this.sourceModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectWsdlPage.this.handleSourceModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)sourceGroup, 0);
        fileLabel.setText("Name :");
        this.sourceModelFileText = new Text((Composite)sourceGroup, 2052);
        gridData = new GridData(768);
        this.sourceModelFileText.setLayoutData((Object)gridData);
        this.sourceModelFileText.setForeground(WidgetUtil.getDarkBlueColor());
        this.sourceModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectWsdlPage.this.handleSourceModelTextChanged();
            }
        });
        browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectWsdlPage.this.handleSourceModelBrowse();
            }
        });
        new Label((Composite)sourceGroup, 0);
        Group helpGroup = WidgetFactory.createGroup((Composite)sourceGroup, (String)"Model Status", (int)2, (int)2);
        helpGroup.setLayoutData((Object)new GridData(768));
        this.sourceHelpText = new Text((Composite)helpGroup, 72);
        this.sourceHelpText.setBackground(WidgetUtil.getReadOnlyBackgroundColor());
        this.sourceHelpText.setForeground(WidgetUtil.getDarkBlueColor());
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        gd.horizontalSpan = 3;
        this.sourceHelpText.setLayoutData((Object)gd);
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("ModelGeneratorWsdlUi");
            settings = temp == null ? settings.addNewSection("ModelGeneratorWsdlUi") : temp;
        }
        return settings;
    }

    static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    private static String getString(String theKey, Object parameter) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), parameter);
    }

    void handleBrowseWorkspaceForTargetModelLocation() {
        IContainer location;
        FolderSelectionDialog dlg = new FolderSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dlg.setInitialSelection((Object)this.importManager.getViewModelLocation());
        dlg.addFilter((ViewerFilter)new ModelingResourceFilter(this.targetLocationFilter));
        dlg.setValidator((ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        dlg.setAllowMultiple(false);
        dlg.setInput((Object)ModelerCore.getWorkspace().getRoot());
        Object[] objs = new Object[1];
        if (dlg.open() == 0) {
            objs = dlg.getResult();
        }
        IContainer iContainer = location = objs.length == 0 ? null : (IContainer)objs[0];
        if (location != null) {
            this.textFieldTargetModelLocation.setText(location.getFullPath().makeRelative().toString());
            this.setPageStatus();
        }
    }

    void handleSourceModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.sourceModelContainerText != null) {
            this.importManager.setSourceModelLocation(folder);
        }
        this.refreshUiFromManager();
        this.setPageStatus();
    }

    void handleSourceModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)SelectWsdlPage.getString("selectSourceModelTitle"), (String)SelectWsdlPage.getString("selectSourceModelMessage"), (boolean)false, null, (ViewerFilter)this.sourceModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.sourceModelFileText != null && selections[0] instanceof IFile) {
            IFile modelFile = (IFile)selections[0];
            String modelName = modelFile.getFullPath().lastSegment();
            this.importManager.setSourceModelExists(true);
            this.importManager.setSourceModelLocation(modelFile.getParent());
            this.importManager.setSourceModelName(modelName);
        }
        this.refreshUiFromManager();
        this.setPageStatus();
    }

    void handleSourceModelTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = EMPTY_STR;
        if (this.sourceModelFileText.getText() != null && this.sourceModelFileText.getText().length() > -1) {
            newName = this.sourceModelFileText.getText();
            this.importManager.setSourceModelName(newName);
            this.importManager.setSourceModelExists(this.sourceModelExists());
        }
        this.refreshUiFromManager();
        this.setPageStatus();
    }

    private void handleValidateWSDLButtonPressed() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                SelectWsdlPage.this.validateWSDL(monitor);
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dlg.run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception err) {
            err.printStackTrace(System.err);
        }
        if (!this.wsdlStatus.isOK()) {
            Shell shell = this.getShell();
            ErrorDialog.openError((Shell)shell, (String)SelectWsdlPage.getString("dialog.wsdlValidationError.title"), (String)SelectWsdlPage.getString("dialog.wsdlValidationError.msg"), (IStatus)this.wsdlStatus);
        }
        this.updateValidateWSDLButtonEnablement();
        this.setPageStatus();
    }

    void validateWSDL(IProgressMonitor monitor) {
        this.wsdlStatus = this.importManager.validateWSDL(monitor);
    }

    public boolean isValidUri(String str) {
        try {
            new URI(str);
        }
        catch (URI.MalformedURIException malformedURIException) {
            return false;
        }
        return true;
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void refreshUiFromManager() {
        this.synchronizing = true;
        if (this.importManager != null) {
            if (this.importManager.getSourceModelLocation() != null) {
                this.sourceModelContainerText.setText(this.importManager.getSourceModelLocation().getFullPath().makeRelative().toString());
            } else {
                this.sourceModelContainerText.setText(EMPTY_STR);
            }
            if (this.importManager.getSourceModelName() != null) {
                this.sourceModelFilePath = this.importManager.getSourceModelLocation().getFullPath().makeRelative();
                this.sourceModelFileText.setText(this.importManager.getSourceModelName());
            } else {
                this.sourceModelFileText.setText(EMPTY_STR);
            }
            IContainer tgtModelLocation = this.importManager.getViewModelLocation();
            if (tgtModelLocation != null) {
                String targetFolder = tgtModelLocation.getFullPath().makeRelative().toString();
                if (this.textFieldTargetModelLocation != null) {
                    this.textFieldTargetModelLocation.setText(targetFolder);
                }
                this.sourceModelContainerText.setText(targetFolder);
            }
            if (this.connectionProfilesCombo.getItems() == null || this.connectionProfilesCombo.getItems().length == 0) {
                if (this.profileWorker.getProfiles().isEmpty()) {
                    this.setErrorMessage(SelectWsdlPage.getString("no.profile"));
                    this.wsdlURIText.setText(EMPTY_STR);
                    this.buttonValidateWSDL.setEnabled(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setMessage(SelectWsdlPage.getString("select.profile"));
                return;
            }
            if (this.connectionProfilesCombo.getSelectionIndex() < 0) {
                return;
            }
            String profileName = this.connectionProfilesCombo.getText();
            IConnectionProfile profile = this.profileWorker.getConnectionProfile();
            if (profile == null) {
                this.setMessage(null);
                this.setErrorMessage(SelectWsdlPage.getString("no.profile.match", new Object[]{profileName}));
                this.buttonValidateWSDL.setEnabled(false);
                return;
            }
            if (this.importManager.getWSDLFileUri() != null) {
                this.wsdlURIText.setText(this.importManager.getWSDLFileUri());
            }
            this.updateWidgetEnablements();
        }
        this.synchronizing = false;
    }

    public void profileChanged(IConnectionProfile profile) {
        this.resetCPComboItems();
        this.selectConnectionProfile(profile.getName());
        this.importManager.setConnectionProfile(profile);
        this.setPageStatus();
    }

    void setPageStatus() {
        boolean sourceValid = this.validateSourceSelection();
        if (!sourceValid) {
            return;
        }
        boolean targetValid = this.validateTargetModelNameAndLocation();
        if (!targetValid) {
            return;
        }
        if (this.wsdlStatus.getSeverity() > 2) {
            WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("wsdlErrorContinuation.msg"), (int)2);
        } else {
            WizardUtil.setPageComplete((WizardPage)this);
        }
        this.getContainer().updateButtons();
    }

    public void setInitialSelection(ISelection theSelection) {
        this.importManager.setWSDLFileUri(null);
        if (!theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            IContainer container;
            Object[] selectedObjects = ((IStructuredSelection)theSelection).toArray();
            if (selectedObjects.length == 1 && (container = ModelUtil.getContainer((Object)selectedObjects[0])) != null) {
                this.importManager.setViewModelLocation(container);
            }
            int i = 0;
            while (i < selectedObjects.length) {
                File fNew;
                if (selectedObjects[i] instanceof IFile && (ModelUtilities.isWsdlFile((IResource)((IFile)selectedObjects[i])) || ModelUtilities.isModelFile((IResource)((IFile)selectedObjects[i]))) && (fNew = ((IFile)selectedObjects[i]).getLocation().toFile()) != null) {
                    String uriStr = null;
                    try {
                        uriStr = fNew.toURI().toURL().toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {}
                    if (ModelUtilities.isWsdlFile((IResource)((IFile)selectedObjects[i]))) {
                        this.importManager.setUriSource(0);
                        this.importManager.setWSDLFileUri(uriStr);
                        break;
                    }
                    if (ModelUtilities.isModelFile((IResource)((IFile)selectedObjects[i]))) {
                        this.importManager.setViewModelName(uriStr.substring(uriStr.lastIndexOf(47) + 1));
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private boolean validateSourceSelection() {
        String msg = SelectWsdlPage.getString("pageComplete.msg");
        String sourceWsdl = this.importManager.getWSDLFileUri();
        if (sourceWsdl == null) {
            msg = SelectWsdlPage.getString("noWsdlSelected.msg");
            WizardUtil.setPageComplete((WizardPage)this, (String)msg, (int)3);
            return false;
        }
        if (this.wsdlStatus == null) {
            msg = SelectWsdlPage.getString("validateWsdl.msg");
            WizardUtil.setPageComplete((WizardPage)this, (String)msg, (int)3);
            return false;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        return true;
    }

    private boolean validateTargetModelNameAndLocation() {
        block5: {
            block4: {
                try {
                    this.targetModelLocation = this.validateFileAndFolder(this.textFieldTargetModelLocation, ".xmi");
                    if (this.targetModelLocation != null) break block4;
                    return false;
                }
                catch (CoreException err) {
                    UTIL.log((Throwable)err);
                    WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
                    return false;
                }
            }
            if (this.targetModelLocation.getProject().getNature("org.teiid.designer.core.modelNature") != null) break block5;
            this.setErrorMessage(SelectWsdlPage.getString("notModelProjectMessage"));
            this.setPageComplete(false);
            this.targetModelLocation = null;
            return false;
        }
        this.importManager.setViewModelLocation(this.targetModelLocation);
        this.getContainer().updateButtons();
        WizardUtil.setPageComplete((WizardPage)this);
        return true;
    }

    private IContainer validateFileAndFolder(Text folderText, String fileExtension) {
        CoreArgCheck.isNotNull((Object)folderText);
        CoreArgCheck.isNotNull((Object)fileExtension);
        String folderName = folderText.getText();
        if (CoreStringUtil.isEmpty((String)folderName)) {
            WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("missingFolderMessage"), (int)3);
        } else {
            IResource resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName);
            if (resrc == null || !(resrc instanceof IContainer) || resrc.getProject() == null) {
                WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("invalidFolderMessage"), (int)3);
            } else if (!resrc.getProject().isOpen()) {
                WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlPage.getString("closedProjectMessage"), (int)3);
            } else {
                IContainer folder = (IContainer)resrc;
                WizardUtil.setPageComplete((WizardPage)this);
                return folder;
            }
        }
        return null;
    }

    void resetCPComboItems() {
        if (this.connectionProfilesCombo != null) {
            ArrayList<IConnectionProfile> profileList = new ArrayList<IConnectionProfile>();
            for (IConnectionProfile prof : this.profileWorker.getProfiles()) {
                profileList.add(prof);
            }
            WidgetUtil.setComboItems((Combo)this.connectionProfilesCombo, profileList, (ILabelProvider)this.profileLabelProvider, (boolean)true);
        }
    }

    void selectConnectionProfile(String name) {
        if (name == null) {
            return;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.connectionProfilesCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (cpIndex > -1) {
            this.connectionProfilesCombo.select(cpIndex);
        }
        this.refreshUiFromManager();
    }

    private boolean sourceModelExists() {
        ModelWorkspaceItem item;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.connectionProfilesCombo.getItemCount() > 0) {
                this.connectionProfilesCombo.select(0);
                this.handleConnectionProfileSelected();
            }
            this.refreshUiFromManager();
        }
    }
}

