/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.editor.panels;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;
import org.teiid.designer.vdb.ui.editor.VdbEditor;
import org.teiid.designer.vdb.ui.editor.panels.AddLanguagePropertyDialog;
import org.teiid.designer.vdb.ui.util.RestVdbUtil;

public class PropertiesPanel {
    static final String PREFIX = I18nUtil.getPropertyPrefix(PropertiesPanel.class);
    static final String INVALID_INTEGER_INPUT_TITLE = PropertiesPanel.i18n("invalidQueryTimeoutValueTitle");
    static final String INVALID_INTEGER_INPUT_MESSAGE = PropertiesPanel.i18n("invalidQueryTimeoutValueMessage");
    static final String NO_REST_PROCEDURES_TITLE = PropertiesPanel.i18n("noValidRestProceduresTitle");
    static final String NO_REST_PROCEDURES_MESSAGE = PropertiesPanel.i18n("noValidRestProceduresMessage");
    VdbEditor vdbEditor;
    ListViewer allowedLanguagesViewer;
    List<String> languages = new ArrayList<String>();
    Button addLanguageButton;
    Button removeLanguageButton;
    Text securityDomainText;
    Text gssPatternText;
    Text passwordPatternText;
    Text authenticationTypeText;

    static String i18n(String id) {
        return VdbUiConstants.Util.getString(id, new Object[0]);
    }

    static String prefixedI18n(String id) {
        return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + id, new Object[0]);
    }

    public PropertiesPanel(Composite parent, VdbEditor editor) {
        this.vdbEditor = editor;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Composite panel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808, (int)1, (int)2);
        panel.setLayout((Layout)new GridLayout(2, false));
        Group propertiesGroup = WidgetFactory.createGroup((Composite)panel, (String)PropertiesPanel.prefixedI18n("general"), (int)4, (int)1, (int)2);
        GridData gd_1 = new GridData(1808);
        gd_1.widthHint = 240;
        propertiesGroup.setLayoutData((Object)gd_1);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PropertiesPanel.i18n("queryTimeoutLabel"));
        final Text queryTimeoutText = new Text((Composite)propertiesGroup, 2052);
        queryTimeoutText.setLayoutData((Object)new GridData(768));
        queryTimeoutText.setText(Integer.toString(this.vdbEditor.getVdb().getQueryTimeout()));
        queryTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int valueInSecs = Integer.parseInt(queryTimeoutText.getText());
                    if (valueInSecs > -1) {
                        PropertiesPanel.this.vdbEditor.getVdb().setQueryTimeout(valueInSecs);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)INVALID_INTEGER_INPUT_TITLE, (String)INVALID_INTEGER_INPUT_MESSAGE);
                    queryTimeoutText.setText(Integer.toString(PropertiesPanel.this.vdbEditor.getVdb().getQueryTimeout()));
                }
            }
        });
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PropertiesPanel.prefixedI18n("securityDomain"));
        label.setToolTipText(PropertiesPanel.prefixedI18n("securityDomainTooltip"));
        this.securityDomainText = new Text((Composite)propertiesGroup, 2052);
        this.securityDomainText.setLayoutData((Object)new GridData(768));
        WidgetUtil.setText((Text)this.securityDomainText, (String)this.vdbEditor.getVdb().getSecurityDomain());
        this.securityDomainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesPanel.this.vdbEditor.getVdb().setSecurityDomain(PropertiesPanel.this.securityDomainText.getText());
                PropertiesPanel.this.updateSecurityWidgets();
            }
        });
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PropertiesPanel.prefixedI18n("gssPattern"));
        label.setToolTipText(PropertiesPanel.prefixedI18n("passwordPatternTooltip"));
        this.gssPatternText = new Text((Composite)propertiesGroup, 2052);
        this.gssPatternText.setLayoutData((Object)new GridData(768));
        WidgetUtil.setText((Text)this.gssPatternText, (String)this.vdbEditor.getVdb().getGssPattern());
        this.gssPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesPanel.this.vdbEditor.getVdb().setGssPattern(PropertiesPanel.this.gssPatternText.getText());
                PropertiesPanel.this.updateSecurityWidgets();
            }
        });
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PropertiesPanel.prefixedI18n("passwordPattern"));
        label.setToolTipText(PropertiesPanel.prefixedI18n("passwordPatternTooltip"));
        this.passwordPatternText = new Text((Composite)propertiesGroup, 2052);
        this.passwordPatternText.setLayoutData((Object)new GridData(768));
        WidgetUtil.setText((Text)this.passwordPatternText, (String)this.vdbEditor.getVdb().getPasswordPattern());
        this.passwordPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesPanel.this.vdbEditor.getVdb().setPasswordPattern(PropertiesPanel.this.passwordPatternText.getText());
                PropertiesPanel.this.updateSecurityWidgets();
            }
        });
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PropertiesPanel.prefixedI18n("authenticationType"));
        label.setToolTipText(PropertiesPanel.prefixedI18n("authenticationTypeTooltip"));
        this.authenticationTypeText = new Text((Composite)propertiesGroup, 2052);
        this.authenticationTypeText.setLayoutData((Object)new GridData(768));
        WidgetUtil.setText((Text)this.authenticationTypeText, (String)this.vdbEditor.getVdb().getAuthenticationType());
        this.authenticationTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesPanel.this.vdbEditor.getVdb().setAuthenticationType(PropertiesPanel.this.authenticationTypeText.getText());
                PropertiesPanel.this.updateSecurityWidgets();
            }
        });
        this.updateSecurityWidgets();
        new Label((Composite)propertiesGroup, 0);
        Button autoGenRESTCheckbox = WidgetFactory.createCheckBox((Composite)propertiesGroup, (String)PropertiesPanel.i18n("autoGenerateRESTWAR"), (boolean)this.vdbEditor.getVdb().isAutoGenerateRESTWAR());
        autoGenRESTCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                boolean validRestVdb = false;
                try {
                    validRestVdb = RestVdbUtil.isRestWarVdb(PropertiesPanel.this.vdbEditor.getVdb().getFile());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                if (!validRestVdb) {
                    ((Button)e.getSource()).setSelection(false);
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)NO_REST_PROCEDURES_TITLE, (String)NO_REST_PROCEDURES_MESSAGE);
                }
                PropertiesPanel.this.vdbEditor.getVdb().setAutoGenerateRESTWAR(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                boolean validRestVdb = false;
                try {
                    validRestVdb = RestVdbUtil.isRestWarVdb(PropertiesPanel.this.vdbEditor.getVdb().getFile());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                if (!validRestVdb) {
                    ((Button)e.getSource()).setSelection(false);
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)NO_REST_PROCEDURES_TITLE, (String)NO_REST_PROCEDURES_MESSAGE);
                }
                PropertiesPanel.this.vdbEditor.getVdb().setAutoGenerateRESTWAR(((Button)e.getSource()).getSelection());
            }
        });
        Group languageGroup = WidgetFactory.createGroup((Composite)panel, (String)PropertiesPanel.prefixedI18n("allowedLanguages"), (int)4, (int)1, (int)1);
        GridData gd_2 = new GridData(1808);
        gd_2.widthHint = 220;
        languageGroup.setLayoutData((Object)gd_2);
        this.allowedLanguagesViewer = new ListViewer((Composite)languageGroup, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.allowedLanguagesViewer.getControl().setLayoutData((Object)data);
        this.allowedLanguagesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.allowedLanguagesViewer.setInput(this.languages);
        for (String value : this.vdbEditor.getVdb().getAllowedLanguages()) {
            this.languages.add(value);
        }
        this.allowedLanguagesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertiesPanel.this.handleLanguageSelected();
            }
        });
        this.allowedLanguagesViewer.refresh();
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)languageGroup, (int)0, (int)2, (int)1, (int)2);
        this.addLanguageButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addLanguageButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/add.png"));
        this.addLanguageButton.setToolTipText(PropertiesPanel.prefixedI18n("addLanguageButton.tooltip"));
        this.addLanguageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesPanel.this.handleAddLanguage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeLanguageButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removeLanguageButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/remove.png"));
        this.removeLanguageButton.setToolTipText(PropertiesPanel.prefixedI18n("removeLangueButton.tooltip"));
        this.removeLanguageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesPanel.this.handleRemoveLanguage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeLanguageButton.setEnabled(false);
    }

    void updateSecurityWidgets() {
        boolean enabled = this.vdbEditor.getVdb().getSecurityDomain() != null;
        this.gssPatternText.setEnabled(enabled);
        this.passwordPatternText.setEnabled(enabled);
        this.authenticationTypeText.setEnabled(enabled);
    }

    void handleLanguageSelected() {
        boolean hasSelection = !this.allowedLanguagesViewer.getSelection().isEmpty();
        this.removeLanguageButton.setEnabled(hasSelection);
    }

    private String getSelectedLanguage() {
        IStructuredSelection selection = (IStructuredSelection)this.allowedLanguagesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (String)selection.getFirstElement();
    }

    void handleAddLanguage() {
        assert (!this.allowedLanguagesViewer.getSelection().isEmpty());
        AddLanguagePropertyDialog dialog = new AddLanguagePropertyDialog(this.allowedLanguagesViewer.getControl().getShell(), this.vdbEditor.getVdb().getAllowedLanguages());
        if (dialog.open() == 0) {
            String language = dialog.getLanguage();
            this.vdbEditor.getVdb().addAllowedLanguage(language);
            this.languages.add(language);
            this.allowedLanguagesViewer.refresh();
            String lang = null;
            String[] stringArray = this.allowedLanguagesViewer.getList().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.equals(language)) {
                    lang = item;
                    break;
                }
                ++n2;
            }
            if (lang != null) {
                this.allowedLanguagesViewer.setSelection((ISelection)new StructuredSelection(lang), true);
            }
        }
    }

    void handleRemoveLanguage() {
        String selectedLanguage = this.getSelectedLanguage();
        assert (selectedLanguage != null);
        this.vdbEditor.getVdb().removeAllowedLanguage(selectedLanguage);
        this.languages.remove(selectedLanguage);
        this.allowedLanguagesViewer.refresh();
    }
}

