/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.editor.panels;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.roles.ui.wizard.DataRoleWizard;
import org.teiid.designer.ui.common.table.ColumnProvider;
import org.teiid.designer.ui.common.table.DefaultTableProvider;
import org.teiid.designer.ui.common.table.TableAndToolBar;
import org.teiid.designer.ui.common.table.TableProvider;
import org.teiid.designer.ui.common.table.TextColumnProvider;
import org.teiid.designer.ui.common.widget.ButtonProvider;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbDataRole;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;
import org.teiid.designer.vdb.ui.editor.ConfirmationDialog;
import org.teiid.designer.vdb.ui.editor.VdbEditor;

public class DataRolesPanel {
    static final String CONFIRM_OVERWRITE_UDFJAR_MESSAGE = DataRolesPanel.i18n("confirmOverwriteUdfJarMessage");
    static final String INFORM_DATA_ROLES_ON_ADD_MESSAGE = DataRolesPanel.i18n("informDataRolesExistOnAddMessage");
    static final String WEB_SERVICES_VIEW_MODEL_URI = "http://www.metamatrix.com/metamodels/WebService";
    static final String DESCRIPTION_COLUMN_NAME = DataRolesPanel.i18n("descriptionColumnName");
    static final String CONFIRM_REMOVE_MESSAGE = DataRolesPanel.i18n("confirmRemoveMessage");
    VdbEditor vdbEditor;
    TableAndToolBar<VdbDataRole> dataRolesGroup;
    Action cloneDataRoleAction;
    VdbDataRole selectedDataRole;

    static String i18n(String id) {
        return VdbUiConstants.Util.getString(id, new Object[0]);
    }

    public DataRolesPanel(Composite parent, VdbEditor editor) {
        this.vdbEditor = editor;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        final String DATA_POLICY_COLUMN_NAME = DataRolesPanel.i18n("dataPolicyName");
        final ButtonProvider editProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/edit-role.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return DataRolesPanel.i18n("editRoleToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return selection.size() == 1;
            }

            public void selected(IStructuredSelection selection) {
                DataRole dp;
                ContainerImpl tempContainer;
                VdbDataRole vdbDataRole;
                block9: {
                    vdbDataRole = (VdbDataRole)selection.getFirstElement();
                    if (vdbDataRole == null) {
                        return;
                    }
                    tempContainer = null;
                    try {
                        try {
                            Collection modelFiles = DataRolesPanel.this.vdbEditor.getVdb().getModelFiles();
                            tempContainer = (ContainerImpl)ModelerCore.createContainer((String)"tempVdbModelContainer");
                            ModelEditorImpl.setContainer((ContainerImpl)tempContainer);
                            for (File modelFile : modelFiles) {
                                boolean isVisible = true;
                                Resource r = tempContainer.getResource(URI.createFileURI((String)modelFile.getPath()), true);
                                if (isVisible && ModelUtil.isModelFile((Resource)r) && !ModelUtil.isXsdFile((Resource)r)) {
                                    EObject firstEObj = (EObject)r.getContents().get(0);
                                    ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation(firstEObj);
                                    String mmURI = ma.getPrimaryMetamodelUri();
                                    if ("http://www.metamatrix.com/metamodels/Relational".equalsIgnoreCase(mmURI) || "http://www.metamatrix.com/metamodels/XmlDocument".equalsIgnoreCase(mmURI) || DataRolesPanel.WEB_SERVICES_VIEW_MODEL_URI.equalsIgnoreCase(mmURI) || "http://www.metamatrix.com/metamodels/MetaMatrixFunction".equals(mmURI)) continue;
                                    tempContainer.getResources().remove((Object)r);
                                    continue;
                                }
                                tempContainer.getResources().remove((Object)r);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            ModelEditorImpl.setContainer(null);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        ModelEditorImpl.setContainer(null);
                        throw throwable;
                    }
                    ModelEditorImpl.setContainer(null);
                }
                DataRole dataPolicy = new DataRole(vdbDataRole.getName(), vdbDataRole.getDescription(), vdbDataRole.isAnyAuthenticated(), vdbDataRole.allowCreateTempTables(), vdbDataRole.doGrantAll(), (Collection)vdbDataRole.getMappedRoleNames(), (Collection)vdbDataRole.getPermissions());
                IWorkbenchWindow iww = VdbUiPlugin.singleton.getCurrentWorkbenchWindow();
                Set roleNames = VdbUtil.getDataRoleNames((Vdb)DataRolesPanel.this.vdbEditor.getVdb(), (String)vdbDataRole.getName());
                DataRoleWizard wizard = new DataRoleWizard((Container)tempContainer, dataPolicy, DataRolesPanel.this.vdbEditor.getVdb().getAllowedLanguages(), roleNames);
                wizard.init(iww.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)DataRolesPanel.this.vdbEditor.getVdb().getModelEntries()));
                WizardDialog dialog = new WizardDialog(wizard.getShell(), (IWizard)wizard);
                int rc = dialog.open();
                if (rc == 0 && (dp = wizard.getFinalDataRole()) != null) {
                    DataRolesPanel.this.vdbEditor.getVdb().removeDataPolicy(vdbDataRole);
                    DataRolesPanel.this.vdbEditor.getVdb().addDataPolicy(dp, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        this.dataRolesGroup = new TableAndToolBar(parent, 1, (TableProvider)new DefaultTableProvider<VdbDataRole>(){

            public void doubleClicked(VdbDataRole element) {
                editProvider.selected((IStructuredSelection)new StructuredSelection((Object)element));
            }

            public VdbDataRole[] getElements() {
                Set entries = DataRolesPanel.this.vdbEditor.getVdb().getDataPolicyEntries();
                return entries.toArray(new VdbDataRole[entries.size()]);
            }

            public boolean isDoubleClickSupported() {
                return true;
            }
        }, new ColumnProvider[]{new TextColumnProvider<VdbDataRole>(){

            public Image getImage(VdbDataRole element) {
                return null;
            }

            public String getName() {
                return DATA_POLICY_COLUMN_NAME;
            }

            public Image getImage() {
                return null;
            }

            public String getValue(VdbDataRole element) {
                return element.getName();
            }
        }, new TextColumnProvider<VdbDataRole>(){

            public String getName() {
                return DESCRIPTION_COLUMN_NAME;
            }

            public Image getImage() {
                return null;
            }

            public String getValue(VdbDataRole element) {
                return element.getDescription();
            }

            public boolean isEditable(VdbDataRole element) {
                return true;
            }

            public void setValue(VdbDataRole element, String value) {
                element.setDescription(value);
            }
        }});
        ButtonProvider newProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/add-role.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return DataRolesPanel.i18n("addRoleToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return true;
            }

            public void selected(IStructuredSelection selection) {
                DataRole dp;
                ContainerImpl tempContainer;
                block8: {
                    tempContainer = null;
                    try {
                        try {
                            Collection modelFiles = DataRolesPanel.this.vdbEditor.getVdb().getModelFiles();
                            tempContainer = (ContainerImpl)ModelerCore.createContainer((String)"tempVdbModelContainer");
                            ModelEditorImpl.setContainer((ContainerImpl)tempContainer);
                            for (File modelFile : modelFiles) {
                                boolean isVisible = true;
                                Resource r = tempContainer.getResource(URI.createFileURI((String)modelFile.getPath()), true);
                                if (isVisible && ModelUtil.isModelFile((Resource)r) && !ModelUtil.isXsdFile((Resource)r)) {
                                    EObject firstEObj = (EObject)r.getContents().get(0);
                                    ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation(firstEObj);
                                    String mmURI = ma.getPrimaryMetamodelUri();
                                    if ("http://www.metamatrix.com/metamodels/Relational".equalsIgnoreCase(mmURI) || "http://www.metamatrix.com/metamodels/XmlDocument".equalsIgnoreCase(mmURI) || DataRolesPanel.WEB_SERVICES_VIEW_MODEL_URI.equalsIgnoreCase(mmURI) || "http://www.metamatrix.com/metamodels/MetaMatrixFunction".equals(mmURI)) continue;
                                    tempContainer.getResources().remove((Object)r);
                                    continue;
                                }
                                tempContainer.getResources().remove((Object)r);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            ModelEditorImpl.setContainer(null);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        ModelEditorImpl.setContainer(null);
                        throw throwable;
                    }
                    ModelEditorImpl.setContainer(null);
                }
                IWorkbenchWindow iww = VdbUiPlugin.singleton.getCurrentWorkbenchWindow();
                Set roleNames = VdbUtil.getDataRoleNames((Vdb)DataRolesPanel.this.vdbEditor.getVdb(), null);
                DataRoleWizard wizard = new DataRoleWizard((Container)tempContainer, null, DataRolesPanel.this.vdbEditor.getVdb().getAllowedLanguages(), roleNames);
                wizard.init(iww.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)DataRolesPanel.this.vdbEditor.getVdb().getModelEntries()));
                WizardDialog dialog = new WizardDialog(wizard.getShell(), (IWizard)wizard);
                int rc = dialog.open();
                if (rc == 0 && (dp = wizard.getFinalDataRole()) != null) {
                    DataRolesPanel.this.vdbEditor.getVdb().addDataPolicy(dp, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        this.dataRolesGroup.add(newProvider);
        this.dataRolesGroup.add(editProvider);
        ButtonProvider removeProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/remove-role.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return DataRolesPanel.i18n("removeRoleToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return !selection.isEmpty();
            }

            public void selected(IStructuredSelection selection) {
                if (ConfirmationDialog.confirm(CONFIRM_REMOVE_MESSAGE)) {
                    for (Object element : selection.toList()) {
                        if (!(element instanceof VdbDataRole)) continue;
                        DataRolesPanel.this.vdbEditor.getVdb().removeDataPolicy((VdbDataRole)element);
                    }
                }
            }
        };
        this.dataRolesGroup.add(removeProvider);
        this.dataRolesGroup.setInput((Object)this.vdbEditor.getVdb());
        this.cloneDataRoleAction = new Action(DataRolesPanel.i18n("cloneDataRoleActionLabel")){

            public void run() {
                if (DataRolesPanel.this.selectedDataRole != null) {
                    DataRole newDR = new DataRole(String.valueOf(DataRolesPanel.this.selectedDataRole.getName()) + DataRolesPanel.i18n("cloneDataRoleAction.copySuffix"), DataRolesPanel.this.selectedDataRole.getDescription(), DataRolesPanel.this.selectedDataRole.isAnyAuthenticated(), DataRolesPanel.this.selectedDataRole.allowCreateTempTables(), DataRolesPanel.this.selectedDataRole.doGrantAll(), (Collection)DataRolesPanel.this.selectedDataRole.getMappedRoleNames(), (Collection)DataRolesPanel.this.selectedDataRole.getPermissions());
                    DataRolesPanel.this.vdbEditor.getVdb().addDataPolicy(newDR, (IProgressMonitor)new NullProgressMonitor());
                    DataRolesPanel.this.dataRolesGroup.getTable().getViewer().refresh();
                }
            }
        };
        this.cloneDataRoleAction.setEnabled(true);
        final TableViewer dataRolesViewer = this.dataRolesGroup.getTable().getViewer();
        final MenuManager dataRolesMenuManager = new MenuManager();
        dataRolesViewer.getControl().setMenu(dataRolesMenuManager.createContextMenu((Control)parent));
        dataRolesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                dataRolesMenuManager.removeAll();
                IStructuredSelection sel = (IStructuredSelection)dataRolesViewer.getSelection();
                if (sel.size() == 1) {
                    DataRolesPanel.this.selectedDataRole = (VdbDataRole)sel.getFirstElement();
                    dataRolesMenuManager.add((IAction)DataRolesPanel.this.cloneDataRoleAction);
                }
            }
        });
    }

    public void refresh() {
        this.dataRolesGroup.getTable().getViewer().refresh();
    }
}

