/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMarkerResolution;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.ui.Messages;

public class VdbMigrateXsdFilesMarkerResolution
implements IMarkerResolution {
    public String getLabel() {
        return Messages.migrateXsdFilesFromModelsToSchemasLabel;
    }

    private boolean isVdbFile(IResource resource) {
        return resource.getType() == 1 && "vdb".equals(resource.getFileExtension()) && resource.exists();
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        if (!this.isVdbFile(resource)) {
            return;
        }
        final IFile theVdbFile = (IFile)resource;
        final Exception[] theException = new Exception[1];
        UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    VdbMigrateXsdFilesMarkerResolution.this.fixVdb(theVdbFile);
                }
                catch (Exception ex) {
                    theException[0] = ex;
                }
            }
        });
        if (theException[0] != null) {
            ErrorHandler.toExceptionDialog((Throwable)theException[0]);
        }
    }

    void fixVdb(IFile theVdb) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        Vdb vdb = new Vdb(theVdb, false, (IProgressMonitor)monitor);
        vdb.save((IProgressMonitor)monitor);
        try {
            theVdb.refreshLocal(0, (IProgressMonitor)monitor);
        }
        catch (CoreException coreException) {}
    }
}

