/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.xpath10;

import org.eclipse.bpel.xpath10.Expr;
import org.eclipse.bpel.xpath10.LocationPath;

public class PathExpr
extends Expr {
    Expr fFilterExpr;
    LocationPath fLocationPath;

    public PathExpr(Expr filter, LocationPath locationPath) {
        super(null);
        this.fFilterExpr = filter;
        this.fLocationPath = locationPath;
    }

    public Expr getFilterExpr() {
        return this.fFilterExpr;
    }

    public LocationPath getLocationPath() {
        return this.fLocationPath;
    }

    @Override
    protected String asText() {
        StringBuilder buf = new StringBuilder();
        if (this.getFilterExpr() != null) {
            buf.append(this.getFilterExpr().getText());
        }
        if (this.getLocationPath() != null) {
            if (!this.getLocationPath().getSteps().isEmpty()) {
                buf.append("/");
            }
            buf.append(this.getLocationPath().getText());
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append(this.getClass().getSimpleName());
        buf.append(",");
        if (this.getFilterExpr() != null) {
            buf.append(this.getFilterExpr());
        }
        if (this.getLocationPath() != null) {
            if (!this.getLocationPath().getSteps().isEmpty()) {
                buf.append("/");
            }
            buf.append(this.getLocationPath());
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public int getPosition() {
        return this.fFilterExpr.getPosition();
    }

    @Override
    public int getEndPosition() {
        if (this.fLocationPath != null) {
            return this.fLocationPath.getEndPosition();
        }
        return this.fFilterExpr.getEndPosition();
    }
}

