/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.impl;

import java.util.HashSet;
import java.util.Set;
import javax.naming.directory.Attribute;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;

public class LdapAttributeNode
implements ILdapAttributeNode {
    private String label;
    private final String id;
    private final ILdapEntryNode associatedEntry;
    private int nullValueCount;
    private Set<Object> values = new HashSet<Object>();
    private int maxValueLength = 0;

    public LdapAttributeNode(ILdapEntryNode associatedEntry, Attribute attribute) {
        this.associatedEntry = associatedEntry;
        this.label = this.id = attribute.getID();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ILdapEntryNode getAssociatedEntry() {
        return this.associatedEntry;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void incrementNullValueCount() {
        ++this.nullValueCount;
    }

    @Override
    public int getNullValueCount() {
        if (this.nullValueCount == 0) {
            return -1;
        }
        return this.nullValueCount;
    }

    @Override
    public void addValue(Object value) {
        if (value == null) {
            return;
        }
        boolean added = this.values.add(value);
        if (added) {
            this.maxValueLength = Math.max(this.maxValueLength, value.toString().length());
        }
    }

    @Override
    public int getDistinctValueCount() {
        return this.values.size();
    }

    @Override
    public int getMaximumValueLength() {
        if (this.maxValueLength == 0) {
            return 32768;
        }
        return this.maxValueLength;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.associatedEntry == null ? 0 : this.associatedEntry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdapAttributeNode other = (LdapAttributeNode)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.associatedEntry == null ? other.associatedEntry != null : !this.associatedEntry.equals(other.associatedEntry));
    }
}

