/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.modelgenerator.salesforce.SalesforceImportWizardManager;
import org.teiid.designer.modelgenerator.salesforce.model.DataModel;
import org.teiid.designer.modelgenerator.salesforce.model.SalesforceField;
import org.teiid.designer.modelgenerator.salesforce.model.SalesforceObject;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;
import org.teiid.designer.modelgenerator.salesforce.ui.wizards.SalesforceUIUtil;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class SelectSalesforceObjectsPage
extends AbstractWizardPage
implements Listener,
FileUtils.Constants,
CoreStringUtil.Constants,
ModelGeneratorSalesforceUiConstants,
ModelGeneratorSalesforceUiConstants.Images,
ModelGeneratorSalesforceUiConstants.HelpContexts,
ISelectionChangedListener,
ICheckStateListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SelectSalesforceObjectsPage.class);
    SalesforceImportWizardManager importManager;
    private CheckboxTableViewer ctv;
    private Table table;
    private TableViewer tableViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private boolean initializing;
    protected DataModel salesforceMetadata;
    boolean updateUI;

    public SelectSalesforceObjectsPage(SalesforceImportWizardManager importManager) {
        super(SelectSalesforceObjectsPage.class.getSimpleName(), SelectSalesforceObjectsPage.getString("title"));
        this.importManager = importManager;
        this.setImageDescriptor(SalesforceUIUtil.getImageDescriptor("icons/salesforce_wiz.gif"));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            DataModel model = SelectSalesforceObjectsPage.this.importManager.createDataModel(monitor);
                            if (SelectSalesforceObjectsPage.this.salesforceMetadata != model) {
                                SelectSalesforceObjectsPage.this.salesforceMetadata = model;
                                SelectSalesforceObjectsPage.this.updateUI = true;
                            } else {
                                SelectSalesforceObjectsPage.this.updateUI = false;
                            }
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Shell shell = this.getShell();
                Status status = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", 0, cause.getLocalizedMessage(), cause);
                ErrorDialog.openError((Shell)shell, (String)SelectSalesforceObjectsPage.getString("dialog.dataModelCreationError.title"), (String)cause.getLocalizedMessage(), (IStatus)status);
                super.setVisible(false);
                return;
            }
            catch (InterruptedException interruptedException) {
                super.setVisible(false);
                return;
            }
            try {
                if (this.updateUI) {
                    this.ctv.setInput((Object)this.salesforceMetadata);
                    StructuredSelection selection = new StructuredSelection(this.ctv.getElementAt(0));
                    this.ctv.setSelection((ISelection)selection);
                    this.setAllNodesSelected(true);
                    this.getControl().setVisible(visible);
                    this.setPageStatus();
                }
            }
            catch (Exception e) {
                Shell shell = this.getShell();
                Status status = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", 0, e.getLocalizedMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)shell, (String)SelectSalesforceObjectsPage.getString("dialog.dataModelCreationError.title"), (String)e.getLocalizedMessage(), (IStatus)status);
                super.setVisible(false);
                this.getWizard().getContainer().showPage(this.getPreviousPage());
                return;
            }
        }
        super.setVisible(visible);
    }

    public void createControl(Composite theParent) {
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)theParent, "org.teiid.designer.modelgenerator.salesforce.ui.sfObjectsPage");
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)1040);
        this.setControl((Control)pnl);
        SashForm outerSplitter = new SashForm(pnl, 512);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        outerSplitter.setLayoutData((Object)gid);
        Composite metadata = WidgetFactory.createPanel((Composite)outerSplitter, (int)4, (int)768);
        SashForm splitter = new SashForm(metadata, 256);
        GridData innerGid = new GridData();
        innerGid.grabExcessVerticalSpace = true;
        innerGid.grabExcessHorizontalSpace = true;
        innerGid.verticalAlignment = 4;
        innerGid.horizontalAlignment = 4;
        splitter.setLayoutData((Object)innerGid);
        this.createCheckboxComposite((Composite)splitter, SelectSalesforceObjectsPage.getString("salesforce.objects"));
        this.createTable((Composite)splitter);
        splitter.setWeights(new int[]{25, 75});
        Composite buttons = WidgetFactory.createPanel((Composite)outerSplitter, (int)4, (int)768);
        this.createButtons(buttons);
        outerSplitter.setWeights(new int[]{80, 20});
    }

    private void createCheckboxComposite(Composite parent, String title) {
        Composite checkBoxTreeComposite = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        checkBoxTreeComposite.setLayout((Layout)layout);
        Group group = WidgetFactory.createGroup((Composite)checkBoxTreeComposite, (String)title, (int)1808, (int)1, (int)2);
        this.ctv = CheckboxTableViewer.newCheckList((Composite)group, (int)2048);
        this.ctv.getTable().setLayoutData((Object)new GridData(1808));
        this.ctv.setContentProvider((IContentProvider)new ListContentProvider());
        this.ctv.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.ctv.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctv.addCheckStateListener((ICheckStateListener)this);
        this.ctv.setSorter(new ViewerSorter());
        this.ctv.setInput(null);
    }

    private void createTable(Composite parent) {
        Composite tableComposite = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        tableComposite.setLayout((Layout)layout);
        Group group = WidgetFactory.createGroup((Composite)tableComposite, (String)SelectSalesforceObjectsPage.getString("column.details"), (int)1808, (int)1, (int)2);
        int style = 101124;
        this.table = new Table((Composite)group, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(SelectSalesforceObjectsPage.getString("visible.name"));
        column.setWidth(100);
        column = new TableColumn(this.table, 16384, 1);
        column.setText(SelectSalesforceObjectsPage.getString("name.in.src"));
        column.setWidth(100);
        column = new TableColumn(this.table, 16384, 2);
        column.setText(SelectSalesforceObjectsPage.getString("type"));
        column.setWidth(100);
        column = new TableColumn(this.table, 16384, 3);
        column.setText(SelectSalesforceObjectsPage.getString("searchable"));
        column.setWidth(100);
        column = new TableColumn(this.table, 16384, 4);
        column.setText(SelectSalesforceObjectsPage.getString("updatable"));
        column.setWidth(100);
        column = new TableColumn(this.table, 16384, 5);
        column.setText(SelectSalesforceObjectsPage.getString("audit.field"));
        column.setWidth(100);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setColumnProperties(new String[]{SelectSalesforceObjectsPage.getString("visible.name"), SelectSalesforceObjectsPage.getString("name.in.src"), SelectSalesforceObjectsPage.getString("type"), SelectSalesforceObjectsPage.getString("searchable"), SelectSalesforceObjectsPage.getString("updatable"), SelectSalesforceObjectsPage.getString("audit.field")});
    }

    private void createButtons(Composite parent) {
        Composite buttonComposite = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1040);
        GridLayout layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        this.selectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SelectSalesforceObjectsPage.getString("selectAllButton.text"), (int)768);
        this.selectAllButton.setToolTipText(SelectSalesforceObjectsPage.getString("selectAllButton.tipText"));
        this.deselectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SelectSalesforceObjectsPage.getString("deselectAllButton.text"), (int)768);
        this.deselectAllButton.setToolTipText(SelectSalesforceObjectsPage.getString("deselectAllButton.tipText"));
        this.selectAllButton.addListener(13, (Listener)this);
        this.deselectAllButton.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            if (event.detail == 32 && ((TableItem)event.data).getGrayed()) {
                TableItem item = (TableItem)event.data;
                ((SalesforceObject)item.getData()).setSelected(item.getChecked());
            }
            if (event.widget == this.selectAllButton) {
                this.setAllNodesSelected(true);
            }
            if (event.widget == this.deselectAllButton) {
                this.setAllNodesSelected(false);
            }
            this.setPageStatus();
        }
    }

    private void setPageStatus() {
        if (!this.importManager.getDataModel().hasSelectedObjects()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)SelectSalesforceObjectsPage.getString("noSelections.msg"), (int)3);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        this.getContainer().updateButtons();
    }

    private void setAllNodesSelected(boolean bSelected) {
        Object[] sfObjects = this.importManager.getDataModel().getSalesforceObjects();
        int i = 0;
        while (i < sfObjects.length) {
            SalesforceObject obj = (SalesforceObject)sfObjects[i];
            obj.setSelected(bSelected);
            this.ctv.setChecked((Object)obj, bSelected);
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                Object obj = selection.iterator().next();
                this.tableViewer.setInput(obj);
            }
        } else {
            throw new RuntimeException(SelectSalesforceObjectsPage.getString("unsupported.type"));
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        SalesforceObject obj = (SalesforceObject)event.getElement();
        boolean checked = event.getChecked();
        obj.setSelected(checked);
        this.setPageStatus();
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    static class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object node) {
            if (node instanceof DataModel) {
                return ((DataModel)node).getSalesforceObjects();
            }
            return EMPTY_STRING_ARRAY;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class ListLabelProvider
    extends LabelProvider {
        final WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();

        ListLabelProvider() {
        }

        public Image getImage(Object node) {
            return null;
        }

        public String getText(Object node) {
            if (node instanceof DataModel) {
                return "theModel";
            }
            if (node instanceof SalesforceObject) {
                return ((SalesforceObject)node).getLabel();
            }
            return "unknownElement";
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = null;
            if (inputElement instanceof SalesforceObject) {
                SalesforceObject object = (SalesforceObject)inputElement;
                if (!SelectSalesforceObjectsPage.this.importManager.isModelAuditFields()) {
                    ArrayList<SalesforceField> nonAuditFields = new ArrayList<SalesforceField>();
                    SalesforceField[] fields = object.getFields();
                    int i = 0;
                    while (i < fields.length) {
                        SalesforceField field = fields[i];
                        if (!field.isAuditField()) {
                            nonAuditFields.add(field);
                        }
                        ++i;
                    }
                    result = nonAuditFields.toArray();
                } else {
                    result = object.getFields();
                }
            }
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class TableLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SalesforceField field = (SalesforceField)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = field.getLabel();
                    break;
                }
                case 1: {
                    result = field.getName();
                    break;
                }
                case 2: {
                    result = field.getType();
                    break;
                }
                case 3: {
                    result = field.isSearchable() ? "True" : "False";
                    break;
                }
                case 4: {
                    result = field.isUpdateable() ? "True" : "False";
                    break;
                }
                case 5: {
                    result = field.isAuditField() ? "True" : "False";
                    break;
                }
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

