/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.teiid.datatools.connectivity.sql.TeiidDocument;
import org.teiid.datatools.models.teiidsqlmodel.Document;

public class TeiidDocumentLoader
extends JDBCBaseLoader {
    private static final String DOCUMENT_NAME = "TABLE_NAME";

    public TeiidDocumentLoader(ICatalogObject catalogObject) {
        super(catalogObject, null);
    }

    public TeiidDocumentLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadDocuments(List container, List existingDocuments) throws SQLException {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            rs = this.createResultSet();
            String docName = null;
            while (rs.next()) {
                docName = rs.getString(DOCUMENT_NAME).trim();
                Document doc = (Document)this.getAndRemoveSQLObject(existingDocuments, docName);
                if (doc == null) {
                    doc = this.processRow(rs);
                    if (doc == null) continue;
                    container.add(doc);
                    continue;
                }
                container.add(doc);
                if (!(doc instanceof ICatalogObject)) continue;
                ((ICatalogObject)doc).refresh();
            }
        }
        finally {
            TeiidDocumentLoader.close(rs);
            TeiidDocumentLoader.close(stmt);
        }
    }

    public void clearDocuments(List documents) {
        documents.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Schema schema = this.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getTables(schema.getCatalog().getName(), schema.getName(), this.getJDBCFilterPattern(), null);
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format(Messages.Error_Unsupported_DatabaseMetaData_Method, "java.sql.DatabaseMetaData.getTables()"));
            error.initCause(e);
            throw error;
        }
    }

    protected Document processRow(ResultSet rs) throws SQLException {
        Document document = this.createDocument();
        this.initialize(document, rs);
        return document;
    }

    protected void initialize(Document document, ResultSet rs) throws SQLException {
        String triggerName = rs.getString(DOCUMENT_NAME).trim();
        document.setName(triggerName);
    }

    protected Document createDocument() {
        return new TeiidDocument();
    }

    public static void close(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    protected Schema getSchema() {
        return (Schema)this.getCatalogObject();
    }
}

