/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.registry;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.Messages;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.registry.AbstractExtensionRegistry;
import org.teiid.designer.runtime.spi.IExecutionAdmin;
import org.teiid.designer.runtime.spi.IExecutionAdminFactory;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.type.IDataTypeManagerService;

public class TeiidRuntimeRegistry
extends AbstractExtensionRegistry<IExecutionAdminFactory, IExecutionAdminFactory> {
    private static final String EXT_POINT_ID = "org.teiid.designer.spi.teiidRuntimeClient";
    private static final String FACTORY_ID = "runtimeFactory";
    private static TeiidRuntimeRegistry registry;

    public static TeiidRuntimeRegistry getInstance() throws Exception {
        if (registry == null) {
            registry = new TeiidRuntimeRegistry();
        }
        return registry;
    }

    private TeiidRuntimeRegistry() throws Exception {
        super(EXT_POINT_ID, FACTORY_ID);
    }

    @Override
    protected void register(IConfigurationElement configurationElement, IExecutionAdminFactory adminFactory) {
        this.register(adminFactory, adminFactory);
    }

    public IExecutionAdminFactory getExecutionAdminFactory(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory;
    }

    public IExecutionAdmin getExecutionAdmin(ITeiidServer teiidServer) throws Exception {
        IExecutionAdminFactory factory = this.getExecutionAdminFactory(teiidServer.getServerVersion());
        return factory.createExecutionAdmin(teiidServer);
    }

    public IDataTypeManagerService getDataTypeManagerService(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory.getDataTypeManagerService(teiidServerVersion);
    }

    public Driver getTeiidDriver(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory.getTeiidDriver(teiidServerVersion);
    }

    public IQueryService getQueryService(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory.getQueryService(teiidServerVersion);
    }

    private IExecutionAdminFactory search(ITeiidServerVersion serverVersion) {
        IExecutionAdminFactory factory;
        for (Map.Entry entry : this.getRegisteredEntries()) {
            factory = (IExecutionAdminFactory)entry.getValue();
            if (!IExecutionAdminFactory.SupportLevel.FULL_SUPPORT.equals((Object)factory.supports(serverVersion))) continue;
            return factory;
        }
        for (Map.Entry entry : this.getRegisteredEntries()) {
            factory = (IExecutionAdminFactory)entry.getValue();
            if (!IExecutionAdminFactory.SupportLevel.WORKS.equals((Object)factory.supports(serverVersion))) continue;
            return factory;
        }
        return null;
    }

    public Collection<ITeiidServerVersion> getSupportedVersions() {
        ArrayList<ITeiidServerVersion> versions = new ArrayList<ITeiidServerVersion>();
        TeiidServerVersion.Version[] versionArray = TeiidServerVersion.Version.values();
        int n = versionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TeiidServerVersion.Version teiidDefault = TeiidServerVersion.Version.TEIID_DEFAULT;
            TeiidServerVersion.Version version = versionArray[n2];
            if (!teiidDefault.equals((Object)version) && !version.get().isGreaterThan(teiidDefault.get())) {
                versions.add(version.get());
            }
            ++n2;
        }
        return versions;
    }
}

