/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.stats.model.IProcessorStatistics;
import org.fusesource.ide.jmx.commons.messages.INodeStatistics;
import org.fusesource.ide.jmx.commons.messages.NodeStatisticsContainer;

public class ProcessorBeanView {
    private final CamelContextNode camelContextNode;
    private String routeId;
    private String processorId;
    private String state;

    public ProcessorBeanView(CamelContextNode camelContextNode, String routeId, String processorId) {
        this.camelContextNode = camelContextNode;
        this.routeId = routeId;
        this.processorId = processorId;
    }

    public String getCamelId() {
        return this.camelContextNode.getContextId();
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    protected INodeStatistics nodeStatistics() {
        NodeStatisticsContainer container = this.camelContextNode.getNodeStatisticsContainer(this.routeId);
        if (container != null) {
            return container.getNodeStats(this.processorId);
        }
        return null;
    }

    protected IProcessorStatistics stats() {
        INodeStatistics answer = this.nodeStatistics();
        if (answer instanceof IProcessorStatistics) {
            return (IProcessorStatistics)answer;
        }
        return null;
    }

    public Long getExchangesCompleted() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getExchangesCompleted());
    }

    public Long getExchangesFailed() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getExchangesFailed());
    }

    public Long getFailuresHandled() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getFailuresHandled());
    }

    public Long getRedeliveries() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getRedeliveries());
    }

    public Long getExternalRedeliveries() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getExternalRedeliveries());
    }

    public Long getMinProcessingTime() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getMinProcessingTime());
    }

    public Long getMaxProcessingTime() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getMaxProcessingTime());
    }

    public Long getTotalProcessingTime() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getTotalProcessingTime());
    }

    public Long getLastProcessingTime() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getLastProcessingTime());
    }

    public Long getMeanProcessingTime() {
        IProcessorStatistics stats = this.stats();
        return stats == null ? null : Long.valueOf(stats.getMeanProcessingTime());
    }
}

