/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.hamcrest.Matcher;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.matchers.And;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.matchers.Not;
import org.mockito.internal.matchers.Or;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.HandyReturnValues;

public class ArgumentMatcherStorageImpl
implements ArgumentMatcherStorage {
    public static final int TWO_SUB_MATCHERS = 2;
    public static final int ONE_SUB_MATCHER = 1;
    private Stack<LocalizedMatcher> matcherStack = new Stack();

    @Override
    public HandyReturnValues reportMatcher(Matcher matcher) {
        this.matcherStack.push(new LocalizedMatcher(matcher));
        return new HandyReturnValues();
    }

    @Override
    public List<LocalizedMatcher> pullLocalizedMatchers() {
        if (this.matcherStack.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocalizedMatcher> matchers = new ArrayList<LocalizedMatcher>(this.matcherStack);
        this.matcherStack.clear();
        return matchers;
    }

    @Override
    public HandyReturnValues reportAnd() {
        this.assertStateFor("And(?)", 2);
        And and = new And(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher(and));
        return new HandyReturnValues();
    }

    @Override
    public HandyReturnValues reportOr() {
        this.assertStateFor("Or(?)", 2);
        Or or = new Or(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher(or));
        return new HandyReturnValues();
    }

    @Override
    public HandyReturnValues reportNot() {
        this.assertStateFor("Not(?)", 1);
        Not not = new Not(this.popLastArgumentMatchers(1).get(0));
        this.matcherStack.push(new LocalizedMatcher(not));
        return new HandyReturnValues();
    }

    private void assertStateFor(String additionalMatcherName, int subMatchersCount) {
        this.assertMatchersFoundFor(additionalMatcherName);
        this.assertIncorrectUseOfAdditionalMatchers(additionalMatcherName, subMatchersCount);
    }

    private List<Matcher> popLastArgumentMatchers(int count) {
        LinkedList<Matcher> result = new LinkedList<Matcher>();
        result.addAll(this.matcherStack.subList(this.matcherStack.size() - count, this.matcherStack.size()));
        int i = 0;
        while (i < count) {
            this.matcherStack.pop();
            ++i;
        }
        return result;
    }

    private void assertMatchersFoundFor(String additionalMatcherName) {
        if (this.matcherStack.isEmpty()) {
            this.matcherStack.clear();
            new Reporter().reportNoSubMatchersFound(additionalMatcherName);
        }
    }

    private void assertIncorrectUseOfAdditionalMatchers(String additionalMatcherName, int count) {
        if (this.matcherStack.size() < count) {
            ArrayList<LocalizedMatcher> lastMatchers = new ArrayList<LocalizedMatcher>(this.matcherStack);
            this.matcherStack.clear();
            new Reporter().incorrectUseOfAdditionalMatchers(additionalMatcherName, count, lastMatchers);
        }
    }

    @Override
    public void validateState() {
        if (!this.matcherStack.isEmpty()) {
            ArrayList<LocalizedMatcher> lastMatchers = new ArrayList<LocalizedMatcher>(this.matcherStack);
            this.matcherStack.clear();
            new Reporter().misplacedArgumentMatcher(lastMatchers);
        }
    }

    @Override
    public void reset() {
        this.matcherStack.clear();
    }
}

