/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.io.Serializable;
import org.mockito.ReturnValues;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.configuration.DefaultMockitoConfiguration;
import org.mockito.configuration.IMockitoConfiguration;
import org.mockito.internal.configuration.ClassPathLoader;
import org.mockito.stubbing.Answer;

public class GlobalConfiguration
implements IMockitoConfiguration,
Serializable {
    static final long serialVersionUID = -2860353062105505938L;
    private static ThreadLocal<IMockitoConfiguration> globalConfiguration = new ThreadLocal();

    IMockitoConfiguration getIt() {
        return globalConfiguration.get();
    }

    public GlobalConfiguration() {
        if (globalConfiguration.get() == null) {
            globalConfiguration.set(this.createConfig());
        }
    }

    private IMockitoConfiguration createConfig() {
        DefaultMockitoConfiguration defaultConfiguration = new DefaultMockitoConfiguration();
        IMockitoConfiguration config = new ClassPathLoader().loadConfiguration();
        if (config != null) {
            return config;
        }
        return defaultConfiguration;
    }

    public static void validate() {
        new GlobalConfiguration();
    }

    @Override
    public ReturnValues getReturnValues() {
        return globalConfiguration.get().getReturnValues();
    }

    @Override
    public AnnotationEngine getAnnotationEngine() {
        return globalConfiguration.get().getAnnotationEngine();
    }

    @Override
    public boolean cleansStackTrace() {
        return globalConfiguration.get().cleansStackTrace();
    }

    @Override
    public boolean enableClassCache() {
        return globalConfiguration.get().enableClassCache();
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return globalConfiguration.get().getDefaultAnswer();
    }
}

