/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.datatools.profiles.ws.WSSoapConnectionProfileWizard;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.modelgenerator.wsdl.WSDLReader;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.model.Port;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.common.widget.Label;

public class WSSoapProfileEndPointWizardPage
extends ConnectionProfileDetailsPage
implements DatatoolsUiConstants {
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private Text descriptionText;
    private Text defaultBindingText;
    private Combo endPointCombo;
    private WSSoapConnectionProfileWizard wizard;
    private Properties profileProperties;
    private Model wsdlModel;

    public WSSoapProfileEndPointWizardPage(String pageName) {
        super(pageName, UTIL.getString("WSSoapProfileEndPointWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/full/obj16/web-service-cp.png"));
        this.setShowPing(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    public void createCustomControl(Composite parent) {
        this.wizard = (WSSoapConnectionProfileWizard)this.getWizard();
        this.profileProperties = this.wizard.getProfileProperties();
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, null);
        this.scrolled = new Composite((Composite)group, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(this.scrolled);
        Label title = new Label(this.scrolled, 0);
        title.setText(UTIL.getString("Common.Properties.Label", new Object[0]));
        title.setFont(JFaceResources.getBannerFont());
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 0x1000000).applyTo((Control)title);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        GridDataFactory.swtDefaults().applyTo((Control)this.profileLabel);
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (String)this.wizard.getProfileName(), (int)4);
        GridDataFactory.swtDefaults().applyTo((Control)this.profileText);
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        GridDataFactory.swtDefaults().applyTo((Control)this.descriptionLabel);
        this.descriptionText = WidgetFactory.createTextBox((Composite)this.scrolled, (int)2060, (int)4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.descriptionText);
        this.descriptionText.setText(this.wizard.getProfileDescription());
        this.descriptionText.setBackground(Display.getCurrent().getSystemColor(19));
        Label label = WidgetFactory.createLabel((Composite)this.scrolled, (String)UTIL.getString("WSSoapProfileEndPointWizardPage.EndPointLabel", new Object[0]));
        GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)label);
        this.endPointCombo = WidgetFactory.createCombo((Composite)this.scrolled, (int)8, (int)768, (Object[])new String[0], (Object)true);
        this.endPointCombo.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.endPointCombo);
        this.endPointCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSSoapProfileEndPointWizardPage.this.handlePortNameSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.endPointCombo.setVisibleItemCount(10);
        label = WidgetFactory.createLabel((Composite)this.scrolled, (String)UTIL.getString("WSSoapProfileEndPointWizardPage.EndPointBindingLabel", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gd);
        label.setToolTipText(UTIL.getString("WSSoapProfileEndPointWizardPage.EndPointBindingTooltip", new Object[0]));
        this.defaultBindingText = new Text(this.scrolled, 2052);
        this.defaultBindingText.setBackground(Display.getCurrent().getSystemColor(19));
        this.defaultBindingText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.defaultBindingText);
        this.defaultBindingText.setToolTipText(UTIL.getString("WSSoapProfileEndPointWizardPage.EndPointBindingTooltip", new Object[0]));
    }

    public void setVisible(boolean visible) {
        if (visible && this.endPointCombo != null) {
            UiBusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        WSDLReader wsdlReader = WSSoapProfileEndPointWizardPage.this.wizard.getWsdlReader();
                        WSSoapProfileEndPointWizardPage.this.wsdlModel = wsdlReader.getModel();
                        if (WSSoapProfileEndPointWizardPage.this.wsdlModel != null) {
                            WSSoapProfileEndPointWizardPage.this.endPointCombo.setItems(WSSoapProfileEndPointWizardPage.this.wsdlModel.getModelablePortNames());
                        } else {
                            WSSoapProfileEndPointWizardPage.this.endPointCombo.removeAll();
                        }
                    }
                    catch (ModelGenerationException ex) {
                        WSSoapProfileEndPointWizardPage.this.setErrorMessage(ex.getLocalizedMessage());
                    }
                    String endPointName = WSSoapProfileEndPointWizardPage.this.profileProperties.getProperty("EndPointName");
                    if (endPointName != null && !endPointName.isEmpty()) {
                        if (WSSoapProfileEndPointWizardPage.this.endPointCombo.getItemCount() == 1) {
                            WSSoapProfileEndPointWizardPage.this.endPointCombo.select(0);
                        } else if (WSSoapProfileEndPointWizardPage.this.endPointCombo.getItemCount() > 0) {
                            String[] endPoints = WSSoapProfileEndPointWizardPage.this.endPointCombo.getItems();
                            int i = 0;
                            String[] stringArray = endPoints;
                            int n = endPoints.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String next = stringArray[n2];
                                if (next.equals(endPointName)) {
                                    WSSoapProfileEndPointWizardPage.this.endPointCombo.select(i);
                                    break;
                                }
                                ++i;
                                ++n2;
                            }
                        }
                    }
                }
            });
        }
        this.profileText.setText(this.wizard.getProfileName());
        this.descriptionText.setText(this.wizard.getProfileDescription());
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        String endPointName = this.profileProperties.getProperty("EndPointName");
        if (endPointName == null || endPointName.isEmpty()) {
            return false;
        }
        String portURI = this.profileProperties.getProperty("EndPoint");
        if (portURI == null || portURI.isEmpty()) {
            return false;
        }
        String soapBinding = this.profileProperties.getProperty("DefaultBinding");
        return soapBinding != null && !soapBinding.isEmpty();
    }

    private void updateState() {
        String endPointName = this.profileProperties.getProperty("EndPointName");
        if (endPointName == null || endPointName.isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.EndPoint.Error.Message", new Object[0]));
            return;
        }
        this.setErrorMessage(null);
        try {
            Port port = this.wsdlModel.getPort(endPointName);
            new URL(port.getLocationURI());
            String bindingType = port.getBindingType();
            this.profileProperties.setProperty("EndPoint", port.getLocationURI());
            if (bindingType != null) {
                this.profileProperties.setProperty("DefaultBinding", bindingType);
                this.defaultBindingText.setText(bindingType);
            }
        }
        catch (Exception exception) {
            this.setErrorMessage(UTIL.getString("Common.EndPoint.Invalid.Message", new Object[0]));
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
    }

    private void handlePortNameSelected() {
        String endPoint = this.endPointCombo.getText();
        if (endPoint != null) {
            endPoint = endPoint.trim();
            this.profileProperties.setProperty("EndPointName", endPoint);
        }
        this.updateState();
    }

    public List<String[]> getSummaryData() {
        List result = super.getSummaryData();
        String endPointName = this.profileProperties.getProperty("EndPointName");
        result.add(new String[]{UTIL.getString("WSSoapProfileEndPointWizardPage.EndPointLabel", new Object[0]), endPointName});
        String endPointURI = this.profileProperties.getProperty("EndPoint");
        result.add(new String[]{UTIL.getString("WSSoapProfileEndPointWizardPage.EndPointURILabel", new Object[0]), endPointURI});
        String binding = this.profileProperties.getProperty("DefaultBinding");
        result.add(new String[]{UTIL.getString("WSSoapProfileEndPointWizardPage.EndPointBindingLabel", new Object[0]), binding});
        return result;
    }
}

