/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.datatools.connectivity.model.Parameter;
import org.teiid.designer.core.translators.SimpleProperty;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.profiles.ws.HeaderPropertiesPanel;
import org.teiid.designer.datatools.profiles.ws.ParameterPanel;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class PropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider,
DatatoolsUiConstants {
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DatatoolsUiPlugin.getDefault().getBundle().getSymbolicName());
    private Composite scrolled;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label urlLabel;
    private Text urlText;
    private Label urlPreviewLabel;
    Text urlPreviewText;
    private Text securityText;
    private Label securityLabel;
    private Map<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
    private Label responseTypeLabel;
    private Combo responseTypeCombo;
    private TabItem parametersTab;
    private TabItem headerPropertiesTab;
    ParameterPanel parameterPanel;
    private TableViewerBuilder propertiesViewer;
    private Properties extraProperties = new Properties();

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setPingButtonEnabled(false);
        this.setPingButtonVisible(false);
        return result;
    }

    protected void createCustomContents(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 2;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.urlText.setLayoutData((Object)gd);
        this.securityLabel = new Label(this.scrolled, 0);
        this.securityLabel.setText(UTIL.getString("Common.Security.Type.Label", new Object[0]));
        this.securityLabel.setToolTipText(UTIL.getString("Common.Security.Type.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 2;
        this.securityLabel.setLayoutData((Object)gd);
        this.securityText = new Text(this.scrolled, 2052);
        this.securityText.setToolTipText(UTIL.getString("Common.Security.Type.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.securityText.setLayoutData((Object)gd);
        this.usernameLabel = new Label(this.scrolled, 0);
        this.usernameLabel.setText(UTIL.getString("Common.Username.Label", new Object[0]));
        this.usernameLabel.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 2;
        this.usernameLabel.setLayoutData((Object)gd);
        this.usernameText = new Text(this.scrolled, 2052);
        this.usernameText.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.usernameText.setLayoutData((Object)gd);
        this.passwordLabel = new Label(this.scrolled, 0);
        this.passwordLabel.setText(UTIL.getString("Common.Password.Label", new Object[0]));
        this.passwordLabel.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 2;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(this.scrolled, 0x400804);
        this.passwordText.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.passwordText.setLayoutData((Object)gd);
        this.responseTypeLabel = new Label(this.scrolled, 0);
        this.responseTypeLabel.setText(UTIL.getString("Common.ResponseType.Label", new Object[0]));
        this.responseTypeLabel.setToolTipText(UTIL.getString("Common.ResponseType.ToolTip", new Object[0]));
        gd = new GridData();
        this.responseTypeLabel.setLayoutData((Object)gd);
        this.responseTypeCombo = WidgetFactory.createCombo((Composite)this.scrolled, (int)2060);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.responseTypeCombo.setLayoutData((Object)gd);
        this.responseTypeCombo.setItems(new String[]{"XML", "JSON"});
        this.responseTypeCombo.select(0);
        this.responseTypeCombo.setText("XML");
        this.responseTypeCombo.setToolTipText(UTIL.getString("Common.ResponseType.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)this.responseTypeCombo);
        this.responseTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyPage.this.handleResponseTypeChanged(((Combo)e.widget).getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.responseTypeCombo.setVisibleItemCount(2);
        this.urlPreviewLabel = new Label(this.scrolled, 0);
        this.urlPreviewLabel.setText(UTIL.getString("WSProfileDetailsWizardPage.urlPreviewLabel", new Object[0]));
        gd = new GridData();
        this.urlPreviewLabel.setLayoutData((Object)gd);
        this.urlPreviewText = new Text(this.scrolled, 2634);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 40;
        gd.horizontalSpan = 3;
        this.urlPreviewText.setLayoutData((Object)gd);
        this.urlPreviewText.setBackground(Display.getCurrent().getSystemColor(19));
        this.initControls();
        TabFolder tabFolder = new TabFolder(this.scrolled, 2176);
        tabFolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Composite parameterPanel = WidgetFactory.createPanel((Composite)tabFolder);
        this.parametersTab = new TabItem(tabFolder, 4);
        this.parametersTab.setControl((Control)parameterPanel);
        this.parametersTab.setText(UTIL.getString("ParametersPanel_groupTitle", new Object[0]));
        this.parameterPanel = new ParameterPanel(this, parameterPanel, this.parameterMap, 8);
        this.urlPreviewText.setText(this.updateUrlPreview().toString());
        Composite headerPropertiesPanel = WidgetFactory.createPanel((Composite)tabFolder);
        this.headerPropertiesTab = new TabItem(tabFolder, 4);
        this.headerPropertiesTab.setControl((Control)headerPropertiesPanel);
        this.headerPropertiesTab.setText(UTIL.getString("HeaderPropertiesPanel_groupTitle", new Object[0]));
        new HeaderPropertiesPanel(headerPropertiesPanel, this.extraProperties, 6);
        this.addlisteners();
    }

    public Properties getExtraProperties() {
        this.extraProperties = new Properties();
        for (String key : this.getParameterMap().keySet()) {
            Parameter para = this.getParameterMap().get(key);
            this.extraProperties.put(para.getPropertyKey(), para.getPropertyValue());
        }
        return this.extraProperties;
    }

    public void setExtraProperties(Properties extraProperties) {
        for (String key : this.getParameterMap().keySet()) {
            Parameter para = this.getParameterMap().get(key);
            extraProperties.put(para.getPropertyKey(), para.getPropertyValue());
        }
        this.extraProperties = extraProperties;
    }

    void handleResponseTypeChanged(String type) {
        this.extraProperties.put("responseType", type);
    }

    public Map<String, Parameter> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, Parameter> parameterMap) {
        this.parameterMap = parameterMap;
    }

    StringBuilder updateUrlPreview() {
        StringBuilder previewUrl = new StringBuilder();
        String urlText = this.urlText.getText();
        if (urlText == null || urlText.trim().equals("")) {
            urlText = "{base URL}";
        }
        StringBuilder parameters = this.buildParameterString();
        previewUrl.append(urlText).append((CharSequence)parameters);
        return previewUrl;
    }

    private StringBuilder buildParameterString() {
        StringBuilder parameterString = new StringBuilder();
        if (this.parameterMap == null) {
            return parameterString;
        }
        Map<String, Parameter> parameterMap = this.parameterMap;
        for (String key : parameterMap.keySet()) {
            Parameter value = parameterMap.get(key);
            if (value.getType().equals((Object)Parameter.Type.URI)) {
                parameterString.append("/").append(value.getDefaultValue());
            }
            if (!value.getType().equals((Object)Parameter.Type.Query)) continue;
            if (parameterString.length() == 0 || !parameterString.toString().contains("?")) {
                parameterString.append("?");
            } else {
                parameterString.append("&");
            }
            parameterString.append(key).append("=").append(value.getDefaultValue());
        }
        return parameterString;
    }

    public boolean performOk() {
        this.getConnectionProfile().setProperties(this.getPropertiesID(), this.collectProperties());
        return super.performOk();
    }

    private void addlisteners() {
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyPage.this.validate();
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyPage.this.validate();
            }
        });
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyPage.this.validate();
            }
        });
        this.securityText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyPage.this.validate();
            }
        });
    }

    protected void validate() {
        String errorMessage = null;
        boolean valid = true;
        if (this.urlText.getText() == null || this.urlText.getText().isEmpty()) {
            errorMessage = UTIL.getString("Common.URL.Error.Message", new Object[0]);
            valid = false;
            this.setErrorMessage(errorMessage);
            this.setValid(valid);
            return;
        }
        String securityType = this.securityText.getText();
        if (!(securityType == null || securityType.trim().equals("") || ICredentialsCommon.SecurityType.None.name().equals(securityType) || ICredentialsCommon.SecurityType.HTTPBasic.name().equals(this.securityText.getText()))) {
            errorMessage = UTIL.getString("Common.Security.Error.Message", new Object[0]);
            valid = false;
            this.setErrorMessage(errorMessage);
            this.setValid(valid);
            return;
        }
        if (securityType != null && !securityType.trim().equals("") && !ICredentialsCommon.SecurityType.None.name().equals(securityType)) {
            if (this.passwordText.getText() == null || this.passwordText.getText().isEmpty()) {
                errorMessage = UTIL.getString("Common.Password.Error.Message", new Object[0]);
                valid = false;
                this.setErrorMessage(errorMessage);
                this.setValid(valid);
                return;
            }
            if (this.usernameText.getText() == null || this.usernameText.getText().isEmpty()) {
                errorMessage = UTIL.getString("Common.Username.Error.Message", new Object[0]);
                valid = false;
                this.setErrorMessage(errorMessage);
                this.setValid(valid);
                return;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setValid(valid);
    }

    private void initControls() {
        String url;
        IConnectionProfile profile = this.getConnectionProfile();
        Properties props = profile.getBaseProperties();
        this.loadParameters(props);
        if (props.get("AuthUserName") != null) {
            this.usernameText.setText((String)props.get("AuthUserName"));
        }
        if (props.get("AuthPassword") != null) {
            this.passwordText.setText((String)props.get("AuthPassword"));
        }
        if ((url = ConnectionInfoHelper.readEndPointProperty((Properties)props)) != null) {
            this.urlText.setText(url);
        }
        if (props.get("SecurityType") != null) {
            this.securityText.setText((String)props.get("SecurityType"));
        }
        if (props.get("responseType") != null) {
            this.responseTypeCombo.setText((String)props.get("responseType"));
        } else {
            props.put("responseType", "XML");
        }
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            if ("AuthPassword".equalsIgnoreCase(keyStr) || "SecurityType".equalsIgnoreCase(keyStr) || "AuthUserName".equalsIgnoreCase(keyStr) || "EndPoint".equalsIgnoreCase(keyStr)) continue;
            this.extraProperties.put(key, props.get(key));
        }
    }

    private void loadParameters(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            if (!keyStr.startsWith("rest_param:")) continue;
            Parameter newParam = new Parameter(keyStr, props.getProperty((String)key));
            this.parameterMap.put(newParam.getName(), newParam);
        }
    }

    protected Properties collectProperties() {
        Properties result = super.collectProperties();
        if (result == null) {
            result = new Properties();
        }
        result.setProperty("EndPoint", this.urlText.getText());
        result.setProperty("SecurityType", this.securityText.getText().trim());
        result.setProperty("AuthUserName", this.usernameText.getText());
        result.setProperty("AuthPassword", this.passwordText.getText());
        result.setProperty("responseType", this.responseTypeCombo.getText());
        for (Object key : this.extraProperties.keySet()) {
            result.put(key, this.extraProperties.get(key));
        }
        return result;
    }

    class AddHeaderPropertyDialog
    extends MessageDialog {
        private Button btnOk;
        private final Set<String> existingNames;
        private String name;
        private String value;

        public AddHeaderPropertyDialog(Shell parentShell, Set<String> existingPropertyNames) {
            super(parentShell, UTIL.getString("AddHeaderPropertyDialog_title", new Object[0]), null, UTIL.getString("AddHeaderPropertyDialog_message", new Object[0]), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.existingNames = existingPropertyNames == null ? new HashSet<String>(0) : existingPropertyNames;
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            Button btn = super.createButton(parent, id, label, defaultButton);
            if (id == 0) {
                this.btnOk = btn;
                btn.setEnabled(false);
            }
            return btn;
        }

        protected Control createCustomArea(Composite parent) {
            Composite pnl = new Composite(parent, 0);
            pnl.setLayout((Layout)new GridLayout(2, false));
            pnl.setLayoutData((Object)new GridData(4, 4, true, true));
            Label lblName = new Label(pnl, 0);
            lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblName.setText(UTIL.getString("AddHeaderPropertyDialog_lblName_text", new Object[0]));
            Text txtName = new Text(pnl, 2048);
            txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txtName.setToolTipText(UTIL.getString("AddHeaderPropertyDialog_txtName_toolTip", new Object[0]));
            txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddHeaderPropertyDialog.this.handleNameChanged(((Text)e.widget).getText());
                }
            });
            Label lblValue = new Label(pnl, 0);
            lblValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblValue.setText(UTIL.getString("AddHeaderPropertyDialog_lblValue_text", new Object[0]));
            Text txtValue = new Text(pnl, 2048);
            txtValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txtValue.setToolTipText(UTIL.getString("AddHeaderPropertyDialog_txtValue_toolTip", new Object[0]));
            txtValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddHeaderPropertyDialog.this.handleValueChanged(((Text)e.widget).getText());
                }
            });
            return pnl;
        }

        public String getName() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.name;
        }

        public String getValue() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.value;
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }

        void handleNameChanged(String newName) {
            this.name = newName;
            this.updateState();
        }

        void handleValueChanged(String newValue) {
            this.value = newValue.trim();
            this.updateState();
        }

        private void updateState() {
            String msg = this.validateName();
            if (StringUtilities.isEmpty((String)msg)) {
                msg = this.validateValue();
            }
            if (StringUtilities.isEmpty((String)msg)) {
                if (!this.btnOk.isEnabled()) {
                    this.btnOk.setEnabled(true);
                }
                if (this.imageLabel.getImage() != null) {
                    this.imageLabel.setImage(null);
                }
                this.imageLabel.setImage(this.getInfoImage());
                msg = UTIL.getString("AddHeaderPropertyDialog_message", new Object[0]);
            } else {
                if (this.btnOk.isEnabled()) {
                    this.btnOk.setEnabled(false);
                }
                this.imageLabel.setImage(this.getErrorImage());
            }
            this.messageLabel.setText(msg);
            this.messageLabel.pack();
        }

        private String validateName() {
            String errorMsg = this.validateName(this.name);
            if (errorMsg == null) {
                for (String existingName : this.existingNames) {
                    if (!existingName.equals(this.name)) continue;
                    errorMsg = UTIL.getString("AddHeaderPropertyDialog_customPropertyAlreadyExists", (Object)this.name);
                    break;
                }
            }
            return errorMsg;
        }

        private String validateValue() {
            return this.validateValue(this.value);
        }

        public String validateName(String proposedName) {
            if (StringUtilities.isEmpty((String)proposedName)) {
                return UTIL.getString("AddHeaderPropertyDialog_emptyPropertyName", new Object[0]);
            }
            char[] cArray = proposedName.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!this.isValidChar(c)) {
                    return UTIL.getString("AddHeaderPropertyDialog_invalidPropertyName", new Object[0]);
                }
                ++n2;
            }
            return null;
        }

        private boolean isValidChar(char c) {
            return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
        }

        public String validateValue(String proposedValue) {
            if (StringUtilities.isEmpty((String)proposedValue)) {
                return UTIL.getString("AddHeaderPropertyDialog_emptyPropertyValue", new Object[0]);
            }
            return null;
        }
    }

    class ExtraPropertiesPanel
    implements DatatoolsUiConstants {
        Button addPropertyButton;
        Button removePropertyButton;

        public ExtraPropertiesPanel(Composite parent) {
            this.createPanel(parent);
        }

        private void createPanel(Composite parent) {
            Group panel = WidgetFactory.createGroup((Composite)parent, (String)UTIL.getString("ExtraPropertiesPanel_groupTitle", new Object[0]), (int)4, (int)2, (int)1);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            panel.setLayoutData((Object)gd);
            PropertyPage.this.propertiesViewer = new TableViewerBuilder((Composite)panel, 68352);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)PropertyPage.this.propertiesViewer.getTableViewer());
            PropertyPage.this.propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    Properties props = PropertyPage.this.extraProperties;
                    if (props.isEmpty()) {
                        return new Object[0];
                    }
                    ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                    for (Object key : props.keySet()) {
                        String keyStr = (String)key;
                        properties.add(new SimpleProperty(keyStr, (String)props.get(keyStr)));
                    }
                    return properties.toArray(new SimpleProperty[0]);
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            PropertyPage.this.propertiesViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    SimpleProperty prop1 = (SimpleProperty)e1;
                    SimpleProperty prop2 = (SimpleProperty)e2;
                    return super.compare(viewer, (Object)prop1.getName(), (Object)prop2.getName());
                }
            });
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)PropertyPage.this.propertiesViewer.getTableComposite());
            ((GridData)((PropertyPage)PropertyPage.this).propertiesViewer.getTable().getLayoutData()).heightHint = PropertyPage.this.propertiesViewer.getTable().getItemHeight() * 6;
            TableViewerColumn column = PropertyPage.this.propertiesViewer.createColumn(16384, 50, 40, true);
            column.getColumn().setText(String.valueOf(UTIL.getString("ExtraPropertiesPanel_name", new Object[0])) + "                   ");
            column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(0));
            column = PropertyPage.this.propertiesViewer.createColumn(16384, 50, 40, true);
            column.getColumn().setText(UTIL.getString("ExtraPropertiesPanel_value", new Object[0]));
            column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(1));
            column.setEditingSupport((EditingSupport)new PropertyNameEditingSupport((ColumnViewer)PropertyPage.this.propertiesViewer.getTableViewer(), 1));
            PropertyPage.this.propertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ExtraPropertiesPanel.this.handlePropertySelected();
                }
            });
            Composite toolbarPanel = WidgetFactory.createPanel((Composite)panel, (int)0, (int)2, (int)1, (int)2);
            this.addPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
            this.addPropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/add_property.png"));
            this.addPropertyButton.setToolTipText(UTIL.getString("HeaderPropertiesPanel_addNewPropertyButton_tooltip", new Object[0]));
            this.addPropertyButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ExtraPropertiesPanel.this.handleAddProperty();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.removePropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
            this.removePropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/remove_property.png"));
            this.removePropertyButton.setToolTipText(UTIL.getString("HeaderPropertiesPanel_removePropertyButton_tooltip", new Object[0]));
            this.removePropertyButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ExtraPropertiesPanel.this.handleRemoveProperty();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.removePropertyButton.setEnabled(false);
            PropertyPage.this.propertiesViewer.setInput((Object)this);
        }

        void handlePropertySelected() {
            boolean hasSelection = !PropertyPage.this.propertiesViewer.getSelection().isEmpty();
            this.removePropertyButton.setEnabled(hasSelection);
        }

        private SimpleProperty getSelectedProperty() {
            IStructuredSelection selection = (IStructuredSelection)PropertyPage.this.propertiesViewer.getSelection();
            if (selection.isEmpty()) {
                return null;
            }
            return (SimpleProperty)selection.getFirstElement();
        }

        void handleAddProperty() {
            assert (!PropertyPage.this.propertiesViewer.getSelection().isEmpty());
            HashSet<String> keys = new HashSet<String>();
            for (Object key : PropertyPage.this.extraProperties.keySet()) {
                keys.add((String)key);
            }
            AddHeaderPropertyDialog dialog = new AddHeaderPropertyDialog(PropertyPage.this.propertiesViewer.getControl().getShell(), keys);
            if (dialog.open() == 0) {
                String name = dialog.getName();
                String value = dialog.getValue();
                PropertyPage.this.extraProperties.put(name, value);
                PropertyPage.this.propertiesViewer.refresh();
                SimpleProperty prop = null;
                TableItem[] tableItemArray = PropertyPage.this.propertiesViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getData() instanceof SimpleProperty && ((SimpleProperty)item.getData()).getName().equals(name)) {
                        prop = (SimpleProperty)item.getData();
                        break;
                    }
                    ++n2;
                }
                if (prop != null) {
                    PropertyPage.this.propertiesViewer.setSelection((ISelection)new StructuredSelection(prop), true);
                }
            }
        }

        void handleRemoveProperty() {
            SimpleProperty selectedProperty = this.getSelectedProperty();
            assert (selectedProperty != null);
            PropertyPage.this.extraProperties.remove(selectedProperty.getName());
            PropertyPage.this.propertiesViewer.refresh();
        }

        class PropertyLabelProvider
        extends ColumnLabelProvider {
            private final int columnID;

            public PropertyLabelProvider(int columnID) {
                this.columnID = columnID;
            }

            public String getText(Object element) {
                if (element instanceof SimpleProperty) {
                    if (this.columnID == 0) {
                        return ((SimpleProperty)element).getName();
                    }
                    if (this.columnID == 1) {
                        return ((SimpleProperty)element).getValue();
                    }
                }
                return super.getText(element);
            }
        }
    }

    class PropertyNameEditingSupport
    extends EditingSupport {
        int columnID;
        private TextCellEditor editor;

        public PropertyNameEditingSupport(ColumnViewer viewer, int columnID) {
            super(viewer);
            this.columnID = columnID;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    return ((SimpleProperty)element).getName();
                }
                if (this.columnID == 1) {
                    return ((SimpleProperty)element).getValue();
                }
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    String oldKey = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newKey = (String)value;
                    if (newKey != null && newKey.length() > 0 && !newKey.equalsIgnoreCase(oldKey)) {
                        PropertyPage.this.extraProperties.remove(oldKey);
                        PropertyPage.this.extraProperties.put(newKey, oldValue);
                        PropertyPage.this.propertiesViewer.refresh();
                    }
                } else if (this.columnID == 1) {
                    String key = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newValue = (String)value;
                    if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                        PropertyPage.this.extraProperties.put(key, newValue);
                        PropertyPage.this.propertiesViewer.refresh();
                    }
                }
            }
        }
    }
}

