/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ODataPropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider,
DatatoolsUiConstants {
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DatatoolsUiPlugin.getDefault().getBundle().getSymbolicName());
    private Composite scrolled;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label urlLabel;
    private Text urlText;
    private Text securityText;
    private Label securityLabel;

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setPingButtonEnabled(false);
        this.setPingButtonVisible(false);
        return result;
    }

    protected void createCustomContents(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.urlText.setLayoutData((Object)gd);
        this.securityLabel = new Label(this.scrolled, 0);
        this.securityLabel.setText(UTIL.getString("Common.Security.Type.Label", new Object[0]));
        this.securityLabel.setToolTipText(UTIL.getString("Common.Security.Type.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.securityLabel.setLayoutData((Object)gd);
        this.securityText = new Text(this.scrolled, 2052);
        this.securityText.setToolTipText(UTIL.getString("Common.Security.Type.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.securityText.setLayoutData((Object)gd);
        this.usernameLabel = new Label(this.scrolled, 0);
        this.usernameLabel.setText(UTIL.getString("Common.Username.Label", new Object[0]));
        this.usernameLabel.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.usernameLabel.setLayoutData((Object)gd);
        this.usernameText = new Text(this.scrolled, 2052);
        this.usernameText.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.usernameText.setLayoutData((Object)gd);
        this.passwordLabel = new Label(this.scrolled, 0);
        this.passwordLabel.setText(UTIL.getString("Common.Password.Label", new Object[0]));
        this.passwordLabel.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(this.scrolled, 0x400804);
        this.passwordText.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.passwordText.setLayoutData((Object)gd);
        this.initControls();
        this.addlisteners();
    }

    private void addlisteners() {
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ODataPropertyPage.this.validate();
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ODataPropertyPage.this.validate();
            }
        });
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ODataPropertyPage.this.validate();
            }
        });
        this.securityText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ODataPropertyPage.this.validate();
            }
        });
    }

    protected void validate() {
        String errorMessage = null;
        boolean valid = true;
        if (this.urlText.getText() == null || this.urlText.getText().isEmpty()) {
            errorMessage = UTIL.getString("Common.URL.Error.Message", new Object[0]);
            valid = false;
        }
        if (!ICredentialsCommon.SecurityType.None.name().equals(this.securityText.getText()) && !ICredentialsCommon.SecurityType.HTTPBasic.name().equals(this.securityText.getText())) {
            errorMessage = UTIL.getString("Common.Security.Error.Message", new Object[0]);
            valid = false;
        }
        if (!ICredentialsCommon.SecurityType.None.name().equals(this.securityText.getText())) {
            if (this.passwordText.getText() == null || this.passwordText.getText().isEmpty()) {
                errorMessage = UTIL.getString("Common.Password.Error.Message", new Object[0]);
                valid = false;
            }
            if (this.usernameText.getText() == null || this.usernameText.getText().isEmpty()) {
                errorMessage = UTIL.getString("Common.Username.Error.Message", new Object[0]);
                valid = false;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setValid(valid);
    }

    private void initControls() {
        String url;
        IConnectionProfile profile = this.getConnectionProfile();
        Properties props = profile.getBaseProperties();
        if (props.get("AuthUserName") != null) {
            this.usernameText.setText((String)props.get("AuthUserName"));
        }
        if (props.get("AuthPassword") != null) {
            this.passwordText.setText((String)props.get("AuthPassword"));
        }
        if ((url = ConnectionInfoHelper.readEndPointProperty((Properties)props)) != null) {
            this.urlText.setText(url);
        }
        if (props.get("SecurityType") != null) {
            this.securityText.setText((String)props.get("SecurityType"));
        }
    }

    protected Properties collectProperties() {
        Properties result = super.collectProperties();
        if (result == null) {
            result = new Properties();
        }
        result.setProperty("EndPoint", this.urlText.getText());
        result.setProperty("SecurityType", this.securityText.getText());
        result.setProperty("AuthUserName", this.usernameText.getText());
        result.setProperty("AuthPassword", this.passwordText.getText());
        return result;
    }
}

