/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.modeshape;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.datatools.profiles.modeshape.ModeShapeJdbcUrl;
import org.teiid.designer.datatools.profiles.modeshape.RestUtils;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ModeShapeDriverUIContributor
implements IDriverUIContributor,
Listener {
    private static final String HOST_LBL_UI_ = DatatoolsUiConstants.UTIL.getString("Common.HOST_LBL_UI_", new Object[0]);
    private static final String PORT_LBL_UI_ = DatatoolsUiConstants.UTIL.getString("Common.PORT_LBL_UI_", new Object[0]);
    private static final String CONNECTIONURL_LBL_UI_ = DatatoolsUiConstants.UTIL.getString("Common.CONNECTIONURL_LBL_UI_", new Object[0]);
    private static final String USERNAME_LBL_UI_ = DatatoolsUiConstants.UTIL.getString("Common.USERNAME_LBL_UI_", new Object[0]);
    private static final String PASSWORD_LBL_UI_ = DatatoolsUiConstants.UTIL.getString("Common.PASSWORD_LBL_UI_", new Object[0]);
    private static final String SSL_BTN_UI_ = DatatoolsUiConstants.UTIL.getString("Common.SSL_BTN_UI_", new Object[0]);
    private static final String TEIID_BTN_UI_ = DatatoolsUiConstants.UTIL.getString("Common.TEIID_BTN_UI_", new Object[0]);
    private static final String SAVE_PASSWORD_LBL_UI_ = DatatoolsUiConstants.UTIL.getString("Common.SAVE_PASSWORD_LBL_UI_", new Object[0]);
    private static final String PATH_LBL_UI_ = DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.REPOS.TXT", new Object[0]);
    private static final String HOST_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.host", new Object[0]);
    private static final String PORT_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.port", new Object[0]);
    private static final String USERNAME_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.username", new Object[0]);
    private static final String URL_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.url", new Object[0]);
    private static final String SSL_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.protocol", new Object[0]);
    private static final String TEIID_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.teiid", new Object[0]);
    private static final String SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.persistpassword.label", new Object[0]);
    private static final String TRUE_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.true", new Object[0]);
    private static final String FALSE_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.false", new Object[0]);
    private static final String PATH_SUMMARY_DATA_TEXT_ = DatatoolsUiConstants.UTIL.getString("Common.summary.path", new Object[0]);
    private boolean isReadOnly = false;
    private Composite parentComposite;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button protocolCheck;
    private Button teiidCheck;
    private Button savePasswordButton;
    private Label urlLabel;
    private Text urlText;
    private Label reposLabel;
    private Combo reposCombo;
    private Properties properties;
    private DialogPage parentPage;
    private IDriverUIContributorInformation contributorInformation;
    private Button reposBrowseButton;
    private LabelProvider reposLabelProvider;

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new Composite(parent, 0);
            this.parentComposite.setLayout((Layout)new GridLayout());
            this.parentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            TabFolder tabComposite = new TabFolder(this.parentComposite, 128);
            tabComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            TabItem generalTab = new TabItem(tabComposite, 0);
            generalTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.generaltab"));
            Composite baseComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            baseComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)baseComposite);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(HOST_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(baseComposite, 0);
            this.portLabel.setText(PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.reposLabel = new Label(baseComposite, 0);
            this.reposLabel.setText(PATH_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.reposLabel.setLayoutData((Object)gd);
            this.reposLabelProvider = new LabelProvider(){

                public String getText(Object source) {
                    return (String)source;
                }
            };
            this.reposCombo = WidgetFactory.createCombo((Composite)baseComposite, (int)64, (int)768, new ArrayList(), (ILabelProvider)this.reposLabelProvider, (boolean)true);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            this.reposCombo.setLayoutData((Object)gd);
            this.reposBrowseButton = new Button(baseComposite, 524288);
            this.reposBrowseButton.setText(DatatoolsUiConstants.UTIL.getString("Common.REFRESH_BUTTON_LBL_UI_", new Object[0]));
            gd = new GridData();
            gd.horizontalAlignment = 2;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = false;
            this.reposBrowseButton.setLayoutData((Object)gd);
            this.reposBrowseButton.setEnabled(false);
            this.protocolCheck = new Button(baseComposite, 32);
            this.protocolCheck.setText(SSL_BTN_UI_);
            this.protocolCheck.setSelection(false);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.protocolCheck.setLayoutData((Object)gd);
            this.teiidCheck = new Button(baseComposite, 32);
            this.teiidCheck.setText(TEIID_BTN_UI_);
            this.teiidCheck.setSelection(true);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.teiidCheck.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(baseComposite, 2122);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            this.urlText.setLayoutData((Object)gd);
            this.initialize();
        }
        return this.parentComposite;
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    public void updateURL() {
        String url = "jdbc:jcr:";
        url = this.protocolCheck.getSelection() ? String.valueOf(url) + "https://" : String.valueOf(url) + "http://";
        if (this.hostText.getText().trim().length() > 0) {
            url = String.valueOf(url) + this.hostText.getText().trim();
        }
        if (this.portText.getText().trim().length() > 0) {
            url = String.valueOf(url) + ":" + this.portText.getText().trim() + "/modeshape-rest";
        }
        if (this.reposCombo.getText().trim().length() > 0) {
            String repos = this.reposCombo.getText().trim();
            url = repos.indexOf(47) == 0 ? String.valueOf(url) + repos : String.valueOf(url) + "/" + repos;
        }
        if (this.teiidCheck.getSelection()) {
            url = String.valueOf(url) + "?teiidsupport=true";
        }
        this.urlText.setText(url);
    }

    private String getRestUrl() {
        StringBuffer url = new StringBuffer();
        if (this.protocolCheck.getSelection()) {
            url.append("https://");
        } else {
            url.append("http://");
        }
        if (this.hostText.getText().trim().length() > 0) {
            url.append(this.hostText.getText().trim());
        }
        if (this.portText.getText().trim().length() > 0) {
            url.append(":").append(this.portText.getText().trim());
        }
        url.append("/modeshape-rest/");
        return url.toString();
    }

    private void removeListeners() {
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.reposCombo.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.reposBrowseButton.removeListener(13, (Listener)this);
        this.protocolCheck.removeListener(13, (Listener)this);
        this.teiidCheck.removeListener(13, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
    }

    private void addListeners() {
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.reposCombo.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.reposBrowseButton.addListener(13, (Listener)this);
        this.protocolCheck.addListener(13, (Listener)this);
        this.teiidCheck.addListener(13, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.savePasswordButton) {
            this.savePasswordButton.setSelection(this.savePasswordButton.getSelection());
        } else if (event.widget == this.protocolCheck) {
            this.protocolCheck.setSelection(this.protocolCheck.getSelection());
        } else if (event.widget == this.teiidCheck) {
            this.teiidCheck.setSelection(this.teiidCheck.getSelection());
        } else if (event.widget == this.reposBrowseButton) {
            this.browseForRepos();
        }
        this.updateURL();
        this.updateBrowseButtonEnablement();
        this.setConnectionInformation();
    }

    private void updateBrowseButtonEnablement() {
        if (!(this.hostText.getText().trim().isEmpty() || this.portText.getText().trim().isEmpty() || this.usernameText.getText().trim().isEmpty() || this.passwordText.getText().trim().isEmpty())) {
            this.reposBrowseButton.setEnabled(true);
        } else {
            this.reposBrowseButton.setEnabled(false);
        }
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.contributorInformation.setProperties(this.properties);
    }

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.VALIDATE_HOST_REQ_UI_", new Object[0]));
            isComplete = false;
        } else if (this.portText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.VALIDATE_PORT_REQ_MSG_UI_", new Object[0]));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.VALIDATE_USERID_REQ_MSG_UI_", new Object[0]));
            isComplete = false;
        } else if (this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.VALIDATE_PASSWORD_REQ_MSG_UI_", new Object[0]));
            isComplete = false;
        } else if (this.reposCombo.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.VALIDATE_PATH_REQ_UI_", new Object[0]));
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
    }

    public void loadProperties() {
        String password;
        this.removeListeners();
        ModeShapeJdbcUrl url = new ModeShapeJdbcUrl(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getHost());
        this.portText.setText(url.getPort());
        this.reposCombo.setText(url.getRepos());
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if (!url.getProtocol().equals("https")) {
            this.protocolCheck.setSelection(false);
        } else {
            this.protocolCheck.setSelection(true);
        }
        if (!url.getTeiidMetadata()) {
            this.teiidCheck.setSelection(false);
        } else {
            this.teiidCheck.setSelection(true);
        }
        String savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD");
        if (savePassword != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        this.updateURL();
        this.addListeners();
        this.updateBrowseButtonEnablement();
        this.setConnectionInformation();
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{PATH_SUMMARY_DATA_TEXT_, this.reposCombo.getText().trim()});
        summaryData.add(new String[]{USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{SSL_SUMMARY_DATA_TEXT_, this.protocolCheck.getSelection() ? TRUE_SUMMARY_DATA_TEXT_ : FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{TEIID_SUMMARY_DATA_TEXT_, this.teiidCheck.getSelection() ? TRUE_SUMMARY_DATA_TEXT_ : FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? TRUE_SUMMARY_DATA_TEXT_ : FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    private void browseForRepos() {
        try {
            URL url = new URL(this.getRestUrl());
            RestUtils restUtils = new RestUtils();
            List repositories = restUtils.getRepositoryList(url, this.usernameText.getText(), this.passwordText.getText());
            this.reposCombo.setItems(repositories.toArray(new String[0]));
            if (!repositories.isEmpty()) {
                this.reposCombo.setText((String)repositories.get(0));
            }
        }
        catch (Exception e) {
            Shell shell = Display.getCurrent().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.repos.browse.exception", new Object[0]), (String)e.getMessage());
            Status status = new Status(4, "org.teiid.designer.datatools.ui", DatatoolsUiConstants.UTIL.getString("ModeShapeDriverUIContributor.repos.browse.exception", new Object[0]), (Throwable)e);
            DatatoolsUiConstants.UTIL.log((IStatus)status);
        }
    }
}

