/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.datatools.profiles.ldap.ConnectionProfileWizard;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class LdapProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements Listener,
DatatoolsUiConstants {
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private CLabel descriptionText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label urlLabel;
    private Text urlText;
    private Label rootDNSuffixLabel;
    private Text rootDNSuffixText;
    private Label contextFactoryLabel;
    private Text contextFactoryText;

    public LdapProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("LdapProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/ldap.gif"));
    }

    public void createCustomControl(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.profileLabel.setLayoutData((Object)gd);
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.profileText.setLayoutData((Object)gd);
        this.profileText.setText(((ConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.descriptionText.setLayoutData((Object)gd);
        this.descriptionText.setText(((ConnectionProfileWizard)this.getWizard()).getProfileDescription());
        this.usernameLabel = new Label(this.scrolled, 0);
        this.usernameLabel.setText(UTIL.getString("Common.Username.Label", new Object[0]));
        this.usernameLabel.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.usernameLabel.setLayoutData((Object)gd);
        this.usernameText = new Text(this.scrolled, 2052);
        this.usernameText.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.usernameText.setLayoutData((Object)gd);
        this.passwordLabel = new Label(this.scrolled, 0);
        this.passwordLabel.setText(UTIL.getString("Common.Password.Label", new Object[0]));
        this.passwordLabel.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(this.scrolled, 0x400804);
        this.passwordText.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.passwordText.setLayoutData((Object)gd);
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.urlText.setLayoutData((Object)gd);
        this.rootDNSuffixLabel = new Label(this.scrolled, 0);
        this.rootDNSuffixLabel.setText(UTIL.getString("LDAP.RootDNSufix.Label", new Object[0]));
        this.rootDNSuffixLabel.setToolTipText(UTIL.getString("LDAP.RootDNSufix.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.rootDNSuffixLabel.setLayoutData((Object)gd);
        this.rootDNSuffixText = new Text(this.scrolled, 2052);
        this.rootDNSuffixText.setToolTipText(UTIL.getString("LDAP.RootDNSufix.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.rootDNSuffixText.setLayoutData((Object)gd);
        this.contextFactoryLabel = new Label(this.scrolled, 0);
        this.contextFactoryLabel.setText(UTIL.getString("Common.Context.Factory.Label", new Object[0]));
        this.contextFactoryLabel.setToolTipText(UTIL.getString("Common.Context.Factory.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.contextFactoryLabel.setLayoutData((Object)gd);
        this.contextFactoryText = new Text(this.scrolled, 2052);
        this.contextFactoryText.setToolTipText(UTIL.getString("Common.Context.Factory.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.contextFactoryText.setLayoutData((Object)gd);
        this.setPingButtonVisible(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setPingButtonEnabled(false);
        this.setPageComplete(false);
        this.addListeners();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    private void addListeners() {
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.urlText.addListener(24, (Listener)this);
        this.rootDNSuffixText.addListener(24, (Listener)this);
        this.contextFactoryText.addListener(24, (Listener)this);
    }

    public void handleEvent(Event event) {
        Properties properties;
        if (event.widget == this.usernameText) {
            properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("LdapAdminUserDN", this.usernameText.getText());
        }
        if (event.widget == this.passwordText) {
            properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("LdapAdminUserPassword", this.passwordText.getText());
        }
        if (event.widget == this.urlText) {
            properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("LdapUrl", this.urlText.getText());
        }
        if (event.widget == this.rootDNSuffixText) {
            properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("LdapRootDNSuffix", this.rootDNSuffixText.getText());
        }
        if (event.widget == this.contextFactoryText) {
            properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("LdapContextFactory", this.contextFactoryText.getText());
        }
        this.updateState();
    }

    void updateState() {
        this.profileText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileDescription());
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (properties.get("LdapAdminUserDN") == null || properties.get("LdapAdminUserDN").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.Username.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        if (properties.get("LdapAdminUserPassword") == null || properties.get("LdapAdminUserPassword").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.Password.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        if (properties.get("LdapUrl") == null || properties.get("LdapUrl").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.URL.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        if (properties.get("LdapRootDNSuffix") == null || properties.get("LdapRootDNSuffix").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("LDAP.RootDNSufix.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        if (properties.get("LdapContextFactory") == null || properties.get("LdapContextFactory").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.Context.Factory.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        this.setPageComplete(true);
        this.setPingButtonEnabled(true);
        this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (complete && (properties.get("LdapAdminUserDN") == null || properties.get("LdapAdminUserDN").toString().isEmpty())) {
            complete = false;
        }
        if (complete && (properties.get("LdapAdminUserPassword") == null || properties.get("LdapAdminUserPassword").toString().isEmpty())) {
            complete = false;
        }
        if (complete && (properties.get("LdapUrl") == null || properties.get("LdapUrl").toString().isEmpty())) {
            complete = false;
        }
        if (complete && (properties.get("LdapContextFactory") == null || properties.get("LdapContextFactory").toString().isEmpty())) {
            complete = false;
        }
        return complete;
    }

    public void testConnection() {
        super.testConnection();
    }

    public List getSummaryData() {
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("Common.Username.Label", new Object[0]), this.usernameText.getText()});
        result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), this.urlText.getText()});
        result.add(new String[]{UTIL.getString("LDAP.RootDNSufix.Label", new Object[0]), this.rootDNSuffixText.getText()});
        result.add(new String[]{UTIL.getString("Common.Context.Factory.Label", new Object[0]), this.contextFactoryText.getText()});
        return result;
    }
}

