/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile.panels;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.teiid.designer.query.proc.ITeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportXmlConfigurationPage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlAttribute;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlElement;
import org.teiid.designer.transformation.ui.wizards.xmlfile.panels.ColumnsInfoPanel;
import org.teiid.designer.ui.common.tree.AbstractTreeContentProvider;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class XmlFileContentsGroup {
    TreeViewer xmlTreeViewer;
    Action createColumnAction;
    Action setRootPathAction;
    ColumnsInfoPanel columnsInfoPanel;
    final TeiidXmlImportXmlConfigurationPage configPage;

    public XmlFileContentsGroup(Composite parent, TeiidXmlImportXmlConfigurationPage configPage) {
        this.configPage = configPage;
        this.createPanel(parent);
    }

    private TeiidXmlFileInfo getFileInfo() {
        return this.configPage.getFileInfo();
    }

    public void setColumnsInfoPanel(ColumnsInfoPanel columnsInfoPanel) {
        this.columnsInfoPanel = columnsInfoPanel;
    }

    public void loadFileContentsViewer() {
        this.xmlTreeViewer.setInput((Object)this.configPage.getFileInfo());
        this.columnsInfoPanel.refresh();
    }

    private void createPanel(Composite parent) {
        Group fileContentsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.XmlFileContents, (int)0, (int)1, (int)4);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        fileContentsGroup.setLayoutData((Object)gd);
        this.xmlTreeViewer = new TreeViewer((Composite)fileContentsGroup, 2820);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.xmlTreeViewer.getControl().setLayoutData((Object)data);
        this.xmlTreeViewer.setContentProvider((IContentProvider)new AbstractTreeContentProvider(){

            public Object[] getChildren(Object element) {
                return XmlFileContentsGroup.this.getNodeChildren(element);
            }

            public Object getParent(Object element) {
                return XmlFileContentsGroup.this.getNodeParent(element);
            }

            public boolean hasChildren(Object element) {
                return XmlFileContentsGroup.this.getNodeHasChildren(element);
            }
        });
        this.xmlTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return XmlFileContentsGroup.this.getNodeImage(element);
            }

            public String getText(Object element) {
                return XmlFileContentsGroup.this.getNodeName(element);
            }
        });
        final MenuManager columnMenuManager = new MenuManager();
        this.xmlTreeViewer.getControl().setMenu(columnMenuManager.createContextMenu((Control)parent));
        this.xmlTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                columnMenuManager.removeAll();
                IStructuredSelection sel = (IStructuredSelection)XmlFileContentsGroup.this.xmlTreeViewer.getSelection();
                if (sel.size() == 1) {
                    columnMenuManager.add((IAction)XmlFileContentsGroup.this.createColumnAction);
                    columnMenuManager.add((IAction)XmlFileContentsGroup.this.setRootPathAction);
                    XmlFileContentsGroup.this.columnsInfoPanel.notifySelection(true);
                } else {
                    XmlFileContentsGroup.this.columnsInfoPanel.notifySelection(false);
                }
            }
        });
        this.xmlTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    XmlFileContentsGroup.this.createColumn();
                }
            }
        });
        this.createColumnAction = new Action(Messages.CreateColumn){

            public void run() {
                XmlFileContentsGroup.this.createColumn();
            }
        };
        this.setRootPathAction = new Action(Messages.SetAsRootPath){

            public void run() {
                XmlFileContentsGroup.this.setRootPath();
            }
        };
    }

    private void setRootPath() {
        IStructuredSelection sel = (IStructuredSelection)this.xmlTreeViewer.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof XmlElement) {
            String pathValue = ((XmlElement)obj).getFullPath();
            this.getFileInfo().setRootPath(pathValue);
            this.configPage.handleInfoChanged(false);
        }
    }

    public void createColumn() {
        IStructuredSelection sel = (IStructuredSelection)this.xmlTreeViewer.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof XmlElement || obj instanceof XmlAttribute) {
            this.getFileInfo().addNewColumn(obj);
            this.configPage.handleInfoChanged(false);
        }
    }

    Object[] getNodeChildren(Object element) {
        if (element instanceof ITeiidXmlFileInfo) {
            return new Object[]{this.getFileInfo().getRootNode()};
        }
        ArrayList<Object> children = new ArrayList<Object>();
        Object[] objectArray = ((XmlElement)element).getAttributes();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object attr = objectArray[n2];
            children.add(attr);
            ++n2;
        }
        objectArray = ((XmlElement)element).getChildrenDTDElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            children.add(elem);
            ++n2;
        }
        return children.toArray(new Object[0]);
    }

    boolean getNodeHasChildren(Object element) {
        if (element instanceof XmlElement) {
            Object[] attributes;
            XmlElement node = (XmlElement)element;
            Object[] children = node.getChildrenDTDElements();
            return children.length + (attributes = node.getAttributes()).length > 0;
        }
        return false;
    }

    Image getNodeImage(Object element) {
        if (element instanceof XmlAttribute) {
            return UiPlugin.getDefault().getImage("icons/full/obj16/XSDAttributeDeclaration.gif");
        }
        if (element instanceof XmlElement) {
            return UiPlugin.getDefault().getImage("icons/full/obj16/XSDElementDeclaration.gif");
        }
        return null;
    }

    String getNodeName(Object element) {
        if (element instanceof XmlElement) {
            XmlElement node = (XmlElement)element;
            return node.getName();
        }
        if (element instanceof XmlAttribute) {
            XmlAttribute node = (XmlAttribute)element;
            return node.getName();
        }
        return "";
    }

    Object getNodeParent(Object element) {
        return ((XmlElement)element).getParent();
    }
}

