/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlColumnInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class XmlFileViewModelFactory
extends FlatFileRelationalModelFactory {
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory relationalFactory = RelationalFactory.eINSTANCE;
    public static final TransformationFactory transformationFactory = TransformationFactory.eINSTANCE;
    public static final DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();
    public static final char DOT = '.';
    public static final char COMMA = ',';
    public static final char SPACE = ' ';
    public static final char S_QUOTE = '\'';
    public static final String HEADER = "HEADER";
    public static final String SKIP = "SKIP";
    public static final String WIDTH = "width";

    public ModelResource createViewRelationalModel(IPath location, String modelName) throws ModelWorkspaceException {
        ModelResource resrc = ModelerCore.createModelResource((IPath)location, (String)modelName);
        resrc.getModelAnnotation().setPrimaryMetamodelUri(RELATIONAL_PACKAGE_URI);
        resrc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
        ModelUtilities.initializeModelContainers((ModelResource)resrc, (String)"Create Model Containers", (Object)this);
        return resrc;
    }

    public void createViewTable(ModelResource modelResource, TeiidXmlFileInfo info, String relationalModelName) throws ModelerCoreException {
        BaseTable table = factory.createBaseTable();
        table.setName(info.getViewTableName());
        this.createColumns(info, table);
        this.addValue(modelResource, table, this.getModelResourceContents(modelResource));
        NewModelObjectHelperManager.helpCreate((Object)table, null);
        String sqlString = info.getSqlString(relationalModelName);
        SqlTransformationMappingRoot tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)table);
        TransformationHelper.setSelectSqlString((Object)tRoot, (String)sqlString, (boolean)false, (Object)this);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)tRoot, (Object)this);
        TransformationValidator validator = new TransformationValidator(tRoot);
        validator.validateSql(sqlString, 0, true);
    }

    public void createViewProcedure(ModelResource modelResource, TeiidXmlFileInfo info, String relationalModelName) throws ModelerCoreException {
        Procedure procedure = factory.createProcedure();
        procedure.setName(info.getViewProcedureName());
        for (String parameterKey : info.getParameterMap().keySet()) {
            ProcedureParameter parameter = factory.createProcedureParameter();
            parameter.setName(parameterKey);
            EObject stringType = datatypeManager.findDatatype("string");
            parameter.setType(stringType);
            parameter.setProcedure(procedure);
        }
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(procedure);
        for (TeiidXmlColumnInfo columnInfo : info.getColumnInfoList()) {
            Column column = factory.createColumn();
            column.setName(columnInfo.getName());
            EObject type = datatypeManager.findDatatype(columnInfo.getDatatype());
            if (type != null) {
                column.setType(type);
                if (columnInfo.getDatatype().equalsIgnoreCase("string")) {
                    column.setLength(4000);
                }
            }
            this.addValue(result, column, result.getColumns());
        }
        this.addValue(modelResource, procedure, modelResource.getEmfResource().getContents());
        NewModelObjectHelperManager.helpCreate((Object)procedure, null);
        String sqlString = info.getSqlString(relationalModelName, info.getModelNameWithoutExtension(modelResource.getItemName()), info.getViewProcedureName());
        SqlTransformationMappingRoot tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)procedure);
        TransformationHelper.setSelectSqlString((Object)tRoot, (String)sqlString, (boolean)false, (Object)this);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)tRoot, (Object)this);
        TransformationValidator validator = new TransformationValidator(tRoot);
        validator.validateSql(sqlString, 0, true);
    }

    private void createColumns(TeiidXmlFileInfo info, BaseTable baseTable) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : info.getColumnInfoList()) {
            EObject datatype;
            Column column = factory.createColumn();
            column.setName(iTeiidXmlColumnInfo.getName());
            column.setNameInSource(iTeiidXmlColumnInfo.getSymbolName());
            column.setLength(iTeiidXmlColumnInfo.getWidth());
            column.setDefaultValue(iTeiidXmlColumnInfo.getDefaultValue());
            String finalDType = iTeiidXmlColumnInfo.getDatatype();
            if ("integer".equalsIgnoreCase(finalDType)) {
                finalDType = "int";
            }
            if ((datatype = datatypeManager.findDatatype(finalDType)) != null) {
                column.setType(datatype);
                if (stringType != null && stringType == datatype) {
                    column.setLength(4000);
                } else if (DatatypeUtilities.isNumeric((String)finalDType)) {
                    column.setPrecision(10);
                }
            }
            baseTable.getColumns().add((Object)column);
        }
    }
}

