/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.rest;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportSourcePage;
import org.teiid.designer.transformation.ui.wizards.rest.TeiidRestImporterModelDefinitionPage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public final class ModelsDefinitionSection
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportSourcePage.class);
    private static final String GET_TEXT_FILES = "getTextFiles()";
    private static final String INVOKE_HTTP = "invokeHttp()";
    private static final String EMPTY_STRING = "";
    TeiidRestImporterModelDefinitionPage page;
    private TeiidMetadataImportInfo info;
    private Text sourceModelContainerText;
    private Text sourceModelFileText;
    private Text sourceHelpText;
    private IPath sourceModelFilePath;
    private Text viewModelContainerText;
    private Text viewModelFileText;
    private Text viewHelpText;
    private IPath viewModelFilePath;
    private Text viewProcedureNameText;
    RelationalStringNameValidator validator = new RelationalStringNameValidator(true);
    IConnectionInfoHelper connectionInfoHelper = new ConnectionInfoHelper();
    boolean synchronizing = false;
    boolean controlComplete = false;
    final ViewerFilter sourceModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            UiConstants.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalSourceModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };
    final ViewerFilter viewModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            UiConstants.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalViewModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ModelsDefinitionSection(TeiidRestImporterModelDefinitionPage page, TeiidMetadataImportInfo info, Composite parent) {
        this.page = page;
        this.info = info;
        this.buildUi(parent);
    }

    private void buildUi(Composite parent) {
        Group sourceGroup = WidgetFactory.createGroup((Composite)parent, (String)ModelsDefinitionSection.getString("sourceModelDefinitionGroup"), (int)0, (int)1, (int)3);
        sourceGroup.setLayoutData((Object)new GridData(768));
        ((GridData)sourceGroup.getLayoutData()).widthHint = 400;
        Label locationLabel = new Label((Composite)sourceGroup, 0);
        locationLabel.setText(ModelsDefinitionSection.getString("location"));
        this.sourceModelContainerText = new Text((Composite)sourceGroup, 2052);
        GridData gridData = new GridData(768);
        this.sourceModelContainerText.setLayoutData((Object)gridData);
        this.sourceModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
        this.sourceModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(ModelsDefinitionSection.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelsDefinitionSection.this.handleSourceModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)sourceGroup, 0);
        fileLabel.setText(ModelsDefinitionSection.getString("name"));
        this.sourceModelFileText = new Text((Composite)sourceGroup, 2052);
        gridData = new GridData(768);
        this.sourceModelFileText.setLayoutData((Object)gridData);
        this.sourceModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelsDefinitionSection.this.handleSourceModelTextChanged();
            }
        });
        browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(ModelsDefinitionSection.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelsDefinitionSection.this.handleSourceModelBrowse();
            }
        });
        Group helpGroup = WidgetFactory.createGroup((Composite)parent, (String)ModelsDefinitionSection.getString("modelStatus"), (int)2, (int)1);
        helpGroup.setLayoutData((Object)new GridData(768));
        this.sourceHelpText = new Text((Composite)helpGroup, 72);
        this.sourceHelpText.setBackground(WidgetUtil.getReadOnlyBackgroundColor());
        this.sourceHelpText.setForeground(WidgetUtil.getDarkBlueColor());
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        gd.horizontalSpan = 3;
        this.sourceHelpText.setLayoutData((Object)gd);
        Group viewGroup = WidgetFactory.createGroup((Composite)parent, (String)ModelsDefinitionSection.getString("viewModelDefinitionGroup"), (int)0, (int)1, (int)3);
        viewGroup.setLayoutData((Object)new GridData(768));
        Label viewLocationLabel = new Label((Composite)viewGroup, 0);
        viewLocationLabel.setText(ModelsDefinitionSection.getString("location"));
        this.viewModelContainerText = new Text((Composite)viewGroup, 2052);
        GridData viewGridData = new GridData(768);
        this.viewModelContainerText.setLayoutData((Object)viewGridData);
        this.viewModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
        this.viewModelContainerText.setEditable(false);
        Button viewBrowseButton = new Button((Composite)viewGroup, 8);
        gridData = new GridData();
        viewBrowseButton.setLayoutData((Object)gridData);
        viewBrowseButton.setText(ModelsDefinitionSection.getString("browse"));
        viewBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelsDefinitionSection.this.handleViewModelLocationBrowse();
            }
        });
        Label viewFileLabel = new Label((Composite)viewGroup, 0);
        viewFileLabel.setText(ModelsDefinitionSection.getString("name"));
        this.viewModelFileText = new Text((Composite)viewGroup, 2052);
        viewGridData = new GridData(768);
        this.viewModelFileText.setLayoutData((Object)viewGridData);
        this.viewModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelsDefinitionSection.this.handleViewModelTextChanged();
            }
        });
        browseButton = new Button((Composite)viewGroup, 8);
        viewGridData = new GridData();
        browseButton.setLayoutData((Object)viewGridData);
        browseButton.setText(ModelsDefinitionSection.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelsDefinitionSection.this.handleViewModelBrowse();
            }
        });
        Label viewProcedureLabel = new Label((Composite)viewGroup, 0);
        viewProcedureLabel.setText(ModelsDefinitionSection.getString("newViewProcedureName"));
        this.viewProcedureNameText = new Text((Composite)viewGroup, 2052);
        gridData = new GridData(768);
        this.viewProcedureNameText.setLayoutData((Object)gridData);
        this.viewProcedureNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelsDefinitionSection.this.handleViewProcedureTextChanged();
            }
        });
        new Label((Composite)viewGroup, 0);
        Group viewHelpGroup = WidgetFactory.createGroup((Composite)parent, (String)ModelsDefinitionSection.getString("modelStatus"), (int)2, (int)1);
        viewHelpGroup.setLayoutData((Object)new GridData(768));
        this.viewHelpText = new Text((Composite)viewHelpGroup, 72);
        this.viewHelpText.setBackground(WidgetUtil.getReadOnlyBackgroundColor());
        this.viewHelpText.setForeground(WidgetUtil.getDarkBlueColor());
        GridData gd2 = new GridData(768);
        gd2.heightHint = 40;
        gd2.horizontalSpan = 3;
        this.viewHelpText.setLayoutData((Object)gd2);
        this.controlComplete = true;
    }

    protected TeiidXmlFileInfo getXmlFileInfo() {
        return this.info.getSourceXmlFileInfo();
    }

    public void setThisPageComplete(String message, int severity) {
        this.page.setThisPageComplete(message, severity);
    }

    protected boolean validatePage() {
        String invalidMessage;
        String sourceFilename;
        this.setSourceHelpMessage();
        this.setViewHelpMessage();
        boolean validProj = false;
        IProject[] iProjectArray = ModelerCore.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            try {
                boolean result;
                boolean bl = result = proj.isOpen() && !proj.hasNature("org.teiid.designer.core.hiddenProjectNature") && proj.hasNature("org.teiid.designer.core.modelNature");
                if (result) {
                    validProj = true;
                    break;
                }
            }
            catch (CoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
            ++n2;
        }
        if (!validProj) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("noOpenProjectsMessage"), 3);
            return false;
        }
        String container = this.sourceModelContainerText.getText();
        if (CoreStringUtil.isEmpty((String)container)) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("sourceFileLocationMustBeSpecified"), 3);
            return false;
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("sourceFileLocationMustBeSpecified"), 3);
            return false;
        }
        String fileText = this.sourceModelFileText.getText().trim();
        if (fileText.length() == 0) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("sourceFileNameMustBeSpecified"), 3);
            return false;
        }
        IStatus status = ModelNameUtil.validate((String)fileText, (String)".xmi", null, (int)5);
        if (status.getSeverity() == 4) {
            this.setThisPageComplete(String.valueOf(ModelNameUtil.MESSAGES.INVALID_SOURCE_MODEL_NAME) + status.getMessage(), 3);
            return false;
        }
        if (this.info.sourceModelExists() && !this.sourceModelHasSameConnectionProfile()) {
            this.setThisPageComplete(Util.getString(String.valueOf(I18N_PREFIX) + "connectionProfileForModelIsDifferent", (Object)fileText), 3);
            return false;
        }
        String viewContainer = this.viewModelContainerText.getText();
        if (CoreStringUtil.isEmpty((String)viewContainer)) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("viewFileLocationMustBeSpecified"), 3);
            return false;
        }
        project = this.getViewTargetProject();
        if (project == null) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("viewFileLocationMustBeSpecified"), 3);
            return false;
        }
        String viewFileText = this.viewModelFileText.getText().trim();
        if (viewFileText.length() == 0) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("viewFileNameMustBeSpecified"), 3);
            return false;
        }
        status = ModelNameUtil.validate((String)viewFileText, (String)".xmi", null, (int)5);
        if (status.getSeverity() == 4) {
            this.setThisPageComplete(String.valueOf(ModelNameUtil.MESSAGES.INVALID_VIEW_MODEL_NAME) + status.getMessage(), 3);
            return false;
        }
        String viewFileName = this.getViewFileName();
        if (viewFileName.equalsIgnoreCase(sourceFilename = this.getSourceFileName())) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("sourceAndViewFilesCannotHaveSameName"), 3);
            return false;
        }
        String string = invalidMessage = this.getXmlFileInfo() == null ? null : this.validator.checkValidName(this.getXmlFileInfo().getViewTableName());
        if (invalidMessage != null) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("viewProcedureNameInvalid"), 3);
            return false;
        }
        if (this.viewAlreadyExists()) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("viewProcedureAlreadyExists"), 3);
            return false;
        }
        if (this.getXmlFileInfo() == null || this.getXmlFileInfo().getViewProcedureName() == null || this.getXmlFileInfo().getViewProcedureName().length() == 0) {
            this.setThisPageComplete(ModelsDefinitionSection.getString("viewProcedureNameNullOrEmpty"), 3);
            return false;
        }
        this.setThisPageComplete(EMPTY_STRING, 0);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean viewAlreadyExists() {
        IFile viewModel;
        ModelResource smr;
        if (!this.info.viewModelExists()) {
            return false;
        }
        IPath modelPath = new Path(this.viewModelFilePath.toOSString()).append(this.viewModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension(".xmi");
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(viewModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) == null) return false;
        try {
            Object obj;
            EObject eObj;
            if (this.getXmlFileInfo().getViewProcedureName() == null) {
                return false;
            }
            String existingName = this.getXmlFileInfo().getViewProcedureName();
            Iterator iterator = smr.getAllRootEObjects().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((eObj = (EObject)(obj = iterator.next())) instanceof Procedure) || !existingName.equalsIgnoreCase(ModelObjectUtilities.getName((EObject)eObj)));
            return true;
        }
        catch (ModelWorkspaceException err) {
            Util.log((Throwable)err);
        }
        return false;
    }

    void handleSourceModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.sourceModelContainerText != null) {
            this.info.setSourceModelLocation(folder.getFullPath().makeRelative());
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
        } else {
            this.info.setSourceModelLocation((IPath)new Path(EMPTY_STRING));
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        if (this.sourceModelFileText.getText() != null && this.sourceModelFileText.getText().length() > -1) {
            this.info.setSourceModelExists(this.sourceModelExists());
        }
        this.validatePage();
    }

    void handleSourceModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)ModelsDefinitionSection.getString("selectSourceModelTitle"), (String)ModelsDefinitionSection.getString("selectSourceModelMessage"), (boolean)false, null, (ViewerFilter)this.sourceModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.sourceModelFileText != null && selections[0] instanceof IFile) {
            IFile modelFile = (IFile)selections[0];
            IPath folderPath = modelFile.getFullPath().removeLastSegments(1);
            String modelName = modelFile.getFullPath().lastSegment();
            this.info.setSourceModelExists(true);
            this.info.setSourceModelLocation(folderPath);
            this.info.setSourceModelName(modelName);
        }
        if (this.info.getSourceModelName() != null) {
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
            this.sourceModelFileText.setText(this.info.getSourceModelName());
        } else {
            this.sourceModelFileText.setText(EMPTY_STRING);
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        this.info.setSourceModelExists(this.sourceModelExists());
        this.validatePage();
    }

    void handleSourceModelTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = EMPTY_STRING;
        if (this.sourceModelFileText.getText() != null && this.sourceModelFileText.getText().length() > -1) {
            newName = this.sourceModelFileText.getText();
            if (newName.trim().isEmpty()) {
                this.info.setSourceModelName(null);
                this.info.setSourceModelExists(false);
            } else {
                this.info.setSourceModelName(newName);
                this.info.setSourceModelExists(this.sourceModelExists());
            }
        }
        this.validatePage();
    }

    void handleViewModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.viewModelContainerText != null) {
            this.info.setViewModelLocation(folder.getFullPath().makeRelative());
            this.viewModelFilePath = this.info.getViewModelLocation();
            this.viewModelContainerText.setText(this.info.getViewModelLocation().makeRelative().toString());
        } else {
            this.info.setViewModelLocation((IPath)new Path(EMPTY_STRING));
            this.viewModelContainerText.setText(EMPTY_STRING);
        }
        if (this.viewModelFileText.getText() != null && this.viewModelFileText.getText().length() > -1) {
            this.info.setViewModelExists(this.sourceModelExists());
        }
        this.validatePage();
    }

    void handleViewModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)ModelsDefinitionSection.getString("viewSourceModelTitle"), (String)ModelsDefinitionSection.getString("viewSourceModelMessage"), (boolean)false, null, (ViewerFilter)this.viewModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.viewModelFileText != null && selections[0] instanceof IFile) {
            IFile modelFile = (IFile)selections[0];
            IPath folderPath = modelFile.getFullPath().removeLastSegments(1);
            String modelName = modelFile.getFullPath().lastSegment();
            this.info.setViewModelExists(true);
            this.info.setViewModelLocation(folderPath);
            this.info.setViewModelName(modelName);
        }
        if (this.info.getViewModelName() != null) {
            this.viewModelFilePath = this.info.getViewModelLocation();
            this.viewModelContainerText.setText(this.info.getViewModelLocation().makeRelative().toString());
            this.viewModelFileText.setText(this.info.getViewModelName());
        } else {
            this.viewModelFileText.setText(EMPTY_STRING);
            this.viewModelContainerText.setText(EMPTY_STRING);
        }
        this.info.setViewModelExists(this.viewModelExists());
        this.validatePage();
    }

    void handleViewModelTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = EMPTY_STRING;
        if (this.viewModelFileText.getText() != null && this.viewModelFileText.getText().length() > -1) {
            newName = this.viewModelFileText.getText();
            if (newName == null || newName.trim().isEmpty()) {
                this.info.setViewModelName(null);
                this.info.setViewModelExists(false);
            } else {
                this.info.setViewModelName(newName);
                this.info.setViewModelExists(this.viewModelExists());
            }
        }
        this.validatePage();
    }

    void handleViewProcedureTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = EMPTY_STRING;
        if (this.viewProcedureNameText.getText() != null && this.viewProcedureNameText.getText().length() > -1) {
            newName = this.viewProcedureNameText.getText();
            this.info.getSourceXmlFileInfo().setViewProcedureName(newName);
        } else {
            this.info.getSourceXmlFileInfo().setViewProcedureName(EMPTY_STRING);
        }
        int caret = this.viewProcedureNameText.getCaretPosition();
        this.viewProcedureNameText.setSelection(caret);
        this.validatePage();
    }

    protected void synchronizeUi() {
        this.synchronizing = true;
        if (this.info.getSourceModelLocation() != null) {
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
        } else {
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        if (this.info.getSourceModelName() != null) {
            this.sourceModelFileText.setText(this.info.getSourceModelName());
        } else {
            this.sourceModelFileText.setText(EMPTY_STRING);
        }
        String sourceFileName = EMPTY_STRING;
        if (this.info.getSourceModelName() != null) {
            sourceFileName = this.info.getSourceModelName();
        }
        for (TeiidXmlFileInfo fileInfo : this.info.getXmlFileInfos()) {
            if (!fileInfo.doProcess()) continue;
            this.info.setSourceXmlFileInfo(fileInfo);
            if (this.info.getSourceModelName() != null) {
                sourceFileName = this.info.getSourceModelName();
                break;
            }
            sourceFileName = "SourceProcedures";
            this.info.setSourceModelName(sourceFileName);
            break;
        }
        this.sourceModelFileText.setText(sourceFileName);
        if (this.info.getViewModelLocation() != null) {
            this.viewModelFilePath = this.info.getViewModelLocation();
            this.viewModelContainerText.setText(this.info.getViewModelLocation().makeRelative().toString());
        } else {
            this.viewModelContainerText.setText(EMPTY_STRING);
        }
        if (this.info.getViewModelName() != null) {
            this.viewModelFileText.setText(this.info.getViewModelName());
        } else {
            this.viewModelFileText.setText(EMPTY_STRING);
        }
        String viewProcedureName = this.viewProcedureNameText.getText();
        if (this.getXmlFileInfo() != null) {
            if (this.getXmlFileInfo().getViewProcedureName() != null) {
                this.viewProcedureNameText.setText(this.getXmlFileInfo().getViewProcedureName());
            }
        } else {
            this.viewProcedureNameText.setText(viewProcedureName);
        }
        String viewFileName = EMPTY_STRING;
        if (this.info.getViewModelName() != null) {
            viewFileName = this.info.getViewModelName();
        }
        this.info.setSourceXmlFileInfo(null);
        for (TeiidXmlFileInfo fileInfo : this.info.getXmlFileInfos()) {
            if (!fileInfo.doProcess()) continue;
            this.info.setSourceXmlFileInfo(fileInfo);
            if (this.info.getViewModelName() != null) {
                viewFileName = this.info.getViewModelName();
                break;
            }
            viewFileName = "ViewProcedures";
            this.info.setViewModelName(viewFileName);
            break;
        }
        this.viewModelFileText.setText(viewFileName);
        this.synchronizing = false;
    }

    private boolean sourceModelExists() {
        ModelWorkspaceItem item;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null;
    }

    private boolean viewModelExists() {
        ModelWorkspaceItem item;
        if (this.viewModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.viewModelFilePath.toOSString()).append(this.viewModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null;
    }

    private String getViewFileName() {
        return this.viewModelFileText.getText().trim();
    }

    private String getSourceFileName() {
        return this.sourceModelFileText.getText().trim();
    }

    public IProject getTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getSourceContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    public IProject getViewTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getViewContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    public String getSourceContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.sourceModelContainerText.getText().trim();
        return result;
    }

    public String getViewContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.viewModelContainerText.getText().trim();
        return result;
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    private void setViewHelpMessage() {
        if (!this.controlComplete) {
            return;
        }
        if (this.getXmlFileInfo() == null || !this.getXmlFileInfo().doProcess() || this.info.getViewModelName() == null || this.info.getViewModelName().length() == 0) {
            this.viewHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "viewModelUndefined", new Object[0]));
        } else {
            this.viewHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "viewModelWillBeCreated", new Object[]{this.info.getViewModelName(), this.info.getViewModelName()}));
        }
    }

    private void setSourceHelpMessage() {
        if (!this.controlComplete) {
            return;
        }
        String procedureName = GET_TEXT_FILES;
        if (this.info.isRestUrlFileMode()) {
            procedureName = INVOKE_HTTP;
        }
        if (this.info.sourceModelExists()) {
            if (this.sourceHasProcedure()) {
                this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "existingSourceModelHasProcedure", new Object[]{this.info.getSourceModelName(), procedureName}));
            } else {
                this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "existingSourceModelHasNoProcedure", new Object[]{this.info.getSourceModelName(), procedureName}));
            }
        } else if (this.getXmlFileInfo() == null || !this.getXmlFileInfo().doProcess() || this.info.getSourceModelName() == null || this.info.getSourceModelName().length() == 0) {
            this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "sourceModelUndefined", new Object[0]));
        } else {
            this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "sourceModelWillBeCreated", new Object[]{this.info.getSourceModelName(), procedureName}));
        }
    }

    private boolean sourceHasProcedure() {
        IFile sourceModel;
        ModelResource smr;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(sourceModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) != null && this.info.isRestUrlFileMode()) {
            return FlatFileRelationalModelFactory.procedureExists(smr, "invokeHttp");
        }
        return false;
    }

    private boolean sourceModelHasSameConnectionProfile() {
        IFile sourceModel;
        ModelResource smr;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(sourceModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) != null) {
            IConnectionProfile profile = this.connectionInfoHelper.getConnectionProfile(smr);
            if (profile == null || this.info.getConnectionProfile() == null) {
                return false;
            }
            if (profile.getName().equalsIgnoreCase(this.info.getConnectionProfile().getName())) {
                return true;
            }
        }
        return false;
    }
}

