/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceNotification;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationListener;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.IQueryCommand;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.ImportTransformationSqlFromTextAction;
import org.teiid.designer.transformation.ui.actions.ReconcileTransformationAction;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.ui.util.FunctionModelNotificationHandler;
import org.teiid.designer.transformation.ui.util.IModelNotificationHandler;
import org.teiid.designer.transformation.util.AttributeMappingHelper;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.common.dialog.RadioMessageDialog;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.refactor.rename.RenameRefactorAction;
import org.teiid.designer.ui.undo.ModelerUndoManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TransformationNotificationListener
implements INotifyChangedListener,
EventObjectListener,
UiConstants {
    static final String ADD_SQL_ELEM_GRP_REFS_TITLE = UiConstants.Util.getString("TransformationNotificationListener.addSQLElemGrpAttrsTitle", new Object[0]);
    static final String REMOVE_SQL_ELEM_GRP_REFS_TITLE = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemGrpRefsTitle", new Object[0]);
    static final String REMOVE_SQL_ELEMS_TITLE = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemsTitle", new Object[0]);
    static final String REMOVE_SQL_ELEMS_MSG = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemsMsg", new Object[0]);
    private static final String DEFAULT_REMOVED_SOURCE = UiConstants.Util.getString("TransformationNotificationListener.defaultRemovedSource", new Object[0]);
    private static final String DEFAULT_ADDED_SOURCE = UiConstants.Util.getString("TransformationNotificationListener.defaultAddedSource", new Object[0]);
    static final String SAVE_BEFORE_CHANGE_TITLE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesTitle", new Object[0]);
    static final String SBC_GROUP_TITLE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioTitle", new Object[0]);
    private static final String SBC_RADIO_SAVE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioButtonSave", new Object[0]);
    private static final String SBC_RADIO_IGNORE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioButtonIgnore", new Object[0]);
    private static final String SBC_RADIO_HALT = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioButtonHalt", new Object[0]);
    private static final String SBC_NOTE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesNote", new Object[0]);
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;
    private static final boolean NOT_UNDOABLE = false;
    static int uiIntegerResult = 0;
    static boolean uiBooleanResult = false;
    private boolean ignoreNotifications = false;
    private boolean ignoreTableSupportsUpdateChangedFalse = false;
    private boolean ignoreTableSupportsUpdateChangedTrue = false;
    boolean setColumnsUpdateableOnTableUpdateable = false;
    private IModelNotificationHandler functionHandler;

    public TransformationNotificationListener() {
        WorkspaceNotificationListener listener = new WorkspaceNotificationListener();
        ModelWorkspaceManager.getModelWorkspaceManager().addNotificationListener((ModelWorkspaceNotificationListener)listener);
        try {
            org.teiid.designer.ui.UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, (EventObjectListener)this);
        }
        catch (EventSourceException e) {
            Util.log(4, (Throwable)e, e.getMessage());
        }
        this.functionHandler = new FunctionModelNotificationHandler();
    }

    public void setIgnoreNotifications(boolean shouldIgnore) {
        this.ignoreNotifications = shouldIgnore;
    }

    public void notifyChanged(Notification notification) {
        if (this.ignoreNotifications) {
            return;
        }
        if (notification instanceof SourcedNotification) {
            if (this.sourceIsNotThis((SourcedNotification)notification) && this.sourceIsNotTransformationMappingHelper((SourcedNotification)notification)) {
                Object source = ((SourcedNotification)notification).getSource();
                if (source == null) {
                    source = notification.getNotifier();
                }
                if (source instanceof ModelerUndoManager) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    this.handleUndo(notifications, source);
                } else {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    this.handleNotifications(notifications, source);
                }
            }
        } else {
            ArrayList<Notification> notifications = new ArrayList<Notification>(1);
            notifications.add(notification);
            this.handleNotifications(notifications, null);
        }
    }

    private boolean sourceIsNotTransformationMappingHelper(SourcedNotification sn) {
        Object source = sn.getSource();
        return !(source instanceof TransformationMappingHelper);
    }

    private boolean sourceIsNotThis(SourcedNotification sn) {
        Object source = sn.getSource();
        if (source == null) {
            return true;
        }
        return !sn.getSource().equals(this);
    }

    private void handleNotifications(Collection notifications, Object source) {
        Collection validNotifications = this.filterNotifications(notifications);
        ArrayList originalNotifications = new ArrayList(validNotifications);
        if (!validNotifications.isEmpty()) {
            Collection modelRenames;
            Collection columnAdds;
            Collection columnChanges;
            Collection virtualTableChanges;
            Collection tableOrColumnRemoves;
            Collection tableOrColumnRenames;
            Collection sqlUIDStatementChanges;
            Collection resultSetRemoves;
            Collection procedParamChanges;
            Collection resultSetAdds;
            Collection resultSetColRemoves;
            Collection resultSetColAdds;
            Collection virtualTableColRemoves;
            Collection virtualTableColAdds;
            Collection sqlAliasChanges;
            Collection sqlAliasRemoves;
            Collection sqlAliasAdds = this.getSqlAliasAddNotifications(validNotifications);
            if (!sqlAliasAdds.isEmpty()) {
                this.handleSqlAliasAddNotifications(sqlAliasAdds, source);
            }
            if (!(sqlAliasRemoves = this.getSqlAliasRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleSqlAliasRemoveNotifications(sqlAliasRemoves, source);
            }
            if (!(sqlAliasChanges = this.getSqlAliasChangeNotifications(validNotifications)).isEmpty()) {
                this.handleSqlAliasChangeNotifications(sqlAliasChanges, source);
            }
            if (!(virtualTableColAdds = this.getTargetVirtualTableColumnAddNotifications(validNotifications)).isEmpty()) {
                this.handleTargetVirtualTableColumnAddNotifications(virtualTableColAdds, source);
            }
            if (!(virtualTableColRemoves = this.getTargetVirtualTableColumnRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleTargetVirtualTableColumnRemoveNotifications(virtualTableColRemoves, source);
            }
            if (!(resultSetColAdds = this.getTargetProcedureResultSetColumnAddNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetColumnAddNotifications(resultSetColAdds, source);
            }
            if (!(resultSetColRemoves = this.getTargetProcedureResultSetColumnRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetColumnRemoveNotifications(resultSetColRemoves, source);
            }
            if (!(resultSetAdds = this.getTargetProcedureResultSetOrParamAddNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetOrParamAddNotifications(resultSetAdds, source);
            }
            if (!(procedParamChanges = this.getTargetProcedureParamChangeNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureParamChangeNotifications(procedParamChanges, source);
            }
            if (!(resultSetRemoves = this.getTargetProcedureResultSetOrParamRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetOrParamRemoveNotifications(resultSetRemoves, source);
            }
            if (!(sqlUIDStatementChanges = this.getSqlSelectUIDStatementChangeNotifications(validNotifications)).isEmpty()) {
                this.handleSqlUIDStatementChangeNotifications(sqlUIDStatementChanges, source);
            }
            if (!(tableOrColumnRenames = this.getSqlTableAndColumnRenameNotifications(validNotifications)).isEmpty()) {
                this.handleSqlTableAndColumnRenameNotifications(tableOrColumnRenames, source);
            }
            if (!(tableOrColumnRemoves = this.getSqlTableAndColumnRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleSqlTableAndColumnRemoveNotifications(tableOrColumnRemoves, source);
            }
            if (!(virtualTableChanges = this.getTargetVirtualTableChangeNotifications(validNotifications)).isEmpty()) {
                this.handleTargetVirtualTableChangeNotifications(virtualTableChanges, source);
            }
            if (!(columnChanges = this.getSqlColumnChangeNotifications(validNotifications)).isEmpty()) {
                this.handleSqlColumnChangeNotifications(columnChanges, source);
            }
            if (!(columnAdds = this.getSqlColumnAddNotifications(validNotifications)).isEmpty()) {
                this.handleSqlTableColumnAddNotifications(columnAdds, source);
            }
            if (!(modelRenames = this.getModelRenameNotifications(validNotifications, source)).isEmpty()) {
                this.handleModelRenameNotifications(modelRenames, source);
            }
            this.functionHandler.handleNotifications(originalNotifications, source);
        }
    }

    private Collection filterNotifications(Collection notifications) {
        ArrayList<Notification> goodNotifications = new ArrayList<Notification>(notifications.size());
        for (Notification notification : notifications) {
            ModelResource mr;
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
            if (changedObj != null && changedObj instanceof EObject && !DiagramUiUtilities.isDiagramObject((EObject)((EObject)changedObj))) {
                Object removedObj;
                if (changedObj instanceof SqlTransformation || changedObj instanceof SqlTransformationMappingRoot || TransformationHelper.isSqlTable((Object)changedObj) || TransformationHelper.isSqlColumn((Object)changedObj) || TransformationHelper.isSqlProcedure((Object)changedObj) || TransformationHelper.isSqlProcedureParameter((Object)changedObj) || TransformationHelper.isSqlColumnSet((Object)changedObj) || this.functionHandler.shouldHandleChangedObject(changedObj)) {
                    goodNotifications.add(notification);
                    continue;
                }
                if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isSqlTable((Object)(removedObj = notification.getOldValue())) && !(changedObj instanceof ModelAnnotation)) continue;
                goodNotifications.add(notification);
                continue;
            }
            if (changedObj == null || !(changedObj instanceof EmfResource) || !ModelIdentifier.isFunctionModel((ModelResource)(mr = ModelUtilities.getModelResource((Resource)((Resource)changedObj), (boolean)false)))) continue;
            goodNotifications.add(notification);
        }
        return goodNotifications;
    }

    private Collection getSqlAliasAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject[] newChildren;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !this.containsSqlAlias(newChildren = NotificationUtilities.getAddedChildren((Notification)notification))) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlAliasRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject[] removedChildren;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !this.containsSqlAlias(removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification))) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlAliasChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !this.sqlAliasesChanged(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlSelectUIDStatementChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !this.sqlSelectUIDStatementChanged(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlSelectUserStatementChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !this.sqlSelectUserStatementChanged(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlTableAndColumnRenameNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isSqlColumn((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) && !TransformationHelper.isSqlTable((Object)changedObj) && !TransformationHelper.isSqlProcedure((Object)changedObj) && !TransformationHelper.isSqlProcedureParameter((Object)changedObj)) continue;
            EStructuralFeature nameFeature = ModelerCore.getModelEditor().getNameFeature((EObject)changedObj);
            Object feature = notification.getFeature();
            if (feature == null || !feature.equals(nameFeature)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlTableAndColumnRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object removedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isSqlTable((Object)(removedObj = notification.getOldValue())) && !TransformationHelper.isSqlColumn((Object)removedObj) && !TransformationHelper.isSqlProcedure((Object)removedObj) && !TransformationHelper.isSqlProcedureParameter((Object)removedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlColumnChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isSqlColumn((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification)))) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlColumnAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        block0: while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification)) continue;
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            int i = 0;
            while (i < newChildren.length) {
                EObject child = newChildren[i];
                if (TransformationHelper.isSqlColumn((Object)child)) {
                    if (result == null) {
                        result = new ArrayList<Notification>(notifications.size());
                    }
                    result.add(notification);
                    iter.remove();
                    continue block0;
                }
                ++i;
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetVirtualTableChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isVirtualSqlTable((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj) || !this.isCriticalFeatureChange(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private boolean isCriticalFeatureChange(Notification notification) {
        EStructuralFeature esf;
        return !(notification.getFeature() instanceof EStructuralFeature) || (esf = (EStructuralFeature)notification.getFeature()).getFeatureID() != 4;
    }

    private Notification getTableSupportsUpdateFeatureChange(Collection notifications) {
        for (Notification notification : notifications) {
            if (!TransformationHelper.isSupportsUpdateTableChangeNotification((Notification)notification)) continue;
            return notification;
        }
        return null;
    }

    private Notification getTableMaterializedViewChange(Collection notifications) {
        for (Notification notification : notifications) {
            if (!TransformationHelper.isSetMaterializedTableChangeNotification((Notification)notification)) continue;
            return notification;
        }
        return null;
    }

    private Collection getTargetVirtualTableColumnAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !TransformationHelper.isVirtualSqlTable((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetVirtualTableColumnRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isVirtualSqlTable((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetColumnAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject procedure;
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !TransformationHelper.isSqlColumnSet((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isSqlVirtualProcedure((Object)(procedure = ((EObject)changedObj).eContainer())) || !TransformationHelper.isValidSqlTransformationTarget((Object)procedure)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetColumnRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject procedure;
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isSqlColumnSet((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isSqlVirtualProcedure((Object)(procedure = ((EObject)changedObj).eContainer())) || !TransformationHelper.isValidSqlTransformationTarget((Object)procedure)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetOrParamAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !TransformationHelper.isSqlVirtualProcedure((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureParamChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Procedure procedure;
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !((changedObj = ModelerCore.getModelEditor().getChangedObject(notification)) instanceof ProcedureParameter) || !TransformationHelper.isSqlVirtualProcedure((Object)(procedure = ((ProcedureParameter)changedObj).getProcedure())) || !TransformationHelper.isValidSqlTransformationTarget((Object)procedure)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetOrParamRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isSqlVirtualProcedure((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getModelRenameNotifications(Collection notifications, Object source) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !((changedObj = ModelerCore.getModelEditor().getChangedObject(notification)) instanceof ModelAnnotation) || !(source instanceof RenameRefactorAction)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private void handleSqlAliasAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List addedAliases = this.getSqlAliasesAdded(notifications);
            EObject mappingRoot = this.getMappingRootFromSqlAliasNotifications(notifications);
            if (!addedAliases.isEmpty()) {
                boolean undoableAdd = false;
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)undoableAdd, (String)"Update for SqlAlias Add", (Object)this);
                boolean succeeded = false;
                try {
                    if (!(txnSource instanceof TransformationObjectEditorPage) && !(txnSource instanceof SqlEditorPanel)) {
                        boolean addElemsToSelect = false;
                        if (!(txnSource instanceof ImportTransformationSqlFromTextAction)) {
                            addElemsToSelect = this.shouldAddElemsToSelect(mappingRoot);
                        }
                        TransformationSqlHelper.updateAllSqlOnSqlAliasGroupsAdded((EObject)mappingRoot, (List)addedAliases, (boolean)addElemsToSelect, (Object)txnSource);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                requiredStart = ModelerCore.startTxn((boolean)false, (boolean)undoableAdd, (String)"SqlAlias Add - reconcile target", (Object)txnSource);
                succeeded = false;
                try {
                    TransformationMappingHelper.reconcileTargetAttributes((EObject)mappingRoot, (boolean)true, (Object)txnSource);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
            }
        }
    }

    private void handleSqlAliasRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedAliases = this.getSqlAliasesRemoved(notifications);
            EObject mappingRoot = this.getMappingRootFromSqlAliasNotifications(notifications);
            if (!removedAliases.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update for SqlAlias Remove", (Object)this);
                boolean succeeded = false;
                try {
                    if (!(txnSource instanceof TransformationObjectEditorPage) && !(txnSource instanceof SqlEditorPanel)) {
                        boolean removeElemsFromSelect = this.shouldRemoveGroupElemsFromSelect(mappingRoot, removedAliases);
                        TransformationSqlHelper.updateAllSqlOnSqlAliasGroupsRemoved((EObject)mappingRoot, (List)removedAliases, (boolean)removeElemsFromSelect, (Object)txnSource);
                    }
                    SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    TransformationMappingHelper.reconcileTargetAttributes((EObject)mappingRoot, (Object)txnSource);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private void handleSqlAliasChangeNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedAliases = this.getSqlAliasesChanged(notifications);
            EObject mappingRoot = this.getMappingRootFromSqlAliasNotifications(notifications);
            if (!removedAliases.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update for SqlAlias Change", (Object)this);
                boolean succeeded = false;
                try {
                    if (!(txnSource instanceof TransformationObjectEditorPage) && !(txnSource instanceof SqlEditorPanel)) {
                        boolean removeElemsFromSelect = this.shouldRemoveGroupElemsFromSelect(mappingRoot, removedAliases);
                        TransformationSqlHelper.updateAllSqlOnSqlAliasGroupsRemoved((EObject)mappingRoot, (List)removedAliases, (boolean)removeElemsFromSelect, (Object)txnSource);
                    }
                    TransformationMappingHelper.reconcileTargetAttributes((EObject)mappingRoot, (Object)txnSource);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private void handleSqlUIDStatementChangeNotifications(Collection notifications, Object txnSource) {
        boolean sourceIsSqlHelper;
        if (!(notifications.isEmpty() || (sourceIsSqlHelper = this.isSqlHelperSource(txnSource)) || txnSource instanceof TransformationObjectEditorPage)) {
            EObject mappingRoot = this.getMappingRootFromSqlUIDStatementNotifications(notifications);
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update for Sql Statment Change", (Object)this);
            boolean succeeded = false;
            try {
                TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)mappingRoot, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void handleSqlTableAndColumnRenameNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            HashSet<Object> groups = new HashSet<Object>();
            for (Notification notification : notifications) {
                Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
                if (TransformationHelper.isSqlTable((Object)changedObj)) {
                    groups.add(changedObj);
                    continue;
                }
                if (TransformationHelper.isSqlColumn((Object)changedObj)) {
                    EObject sourceGrp = ((EObject)changedObj).eContainer();
                    groups.add(sourceGrp);
                    continue;
                }
                if (TransformationHelper.isSqlProcedure((Object)changedObj)) {
                    groups.add(changedObj);
                    continue;
                }
                if (!TransformationHelper.isSqlProcedureParameter((Object)changedObj)) continue;
                EObject sourceProc = ((EObject)changedObj).eContainer();
                groups.add(sourceProc);
            }
            if (!groups.isEmpty()) {
                TransformationHelper.invalidateCachedRootsWithSourceGroups(groups);
                TransformationHelper.invalidateCachedRootsWithTargetGroups(groups);
            }
        }
    }

    private void handleSqlTableAndColumnRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            HashSet<Object> groups = new HashSet<Object>();
            for (Notification notification : notifications) {
                Object removedObj = notification.getOldValue();
                if (TransformationHelper.isSqlTable((Object)removedObj)) {
                    groups.add(removedObj);
                    continue;
                }
                if (TransformationHelper.isSqlColumn((Object)removedObj)) {
                    Object sourceGrp = ModelerCore.getModelEditor().getChangedObject(notification);
                    groups.add(sourceGrp);
                    continue;
                }
                if (TransformationHelper.isSqlProcedure((Object)removedObj)) {
                    groups.add(removedObj);
                    continue;
                }
                if (!TransformationHelper.isSqlProcedureParameter((Object)removedObj)) continue;
                Object sourceProc = ModelerCore.getModelEditor().getChangedObject(notification);
                groups.add(sourceProc);
            }
            if (!groups.isEmpty()) {
                TransformationHelper.invalidateCachedRootsWithSourceGroups(groups);
            }
        }
    }

    private void handleSqlColumnChangeNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            HashSet<EObject> groups = new HashSet<EObject>();
            for (Notification notification : notifications) {
                Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
                if (!TransformationHelper.isSqlColumn((Object)changedObj)) continue;
                EObject grp = ((EObject)changedObj).eContainer();
                groups.add(grp);
            }
            if (!groups.isEmpty()) {
                TransformationHelper.invalidateCachedRootsWithSourceGroups(groups);
                TransformationHelper.invalidateCachedRootsWithTargetGroups(groups);
            }
        }
    }

    private void handleSqlTableColumnAddNotifications(Collection notifications, Object txnSource) {
        Set tables;
        if (!notifications.isEmpty() && !(tables = this.getSqlTablesAddedTo(notifications)).isEmpty()) {
            SqlMappingRootCache.invalidateRootsWithSourceGroups((Set)tables);
        }
    }

    private void handleTargetVirtualTableChangeNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            boolean isMaterialized;
            Object table;
            EObject mappingRoot = this.getMappingRootFromVTableNotifications(notifications);
            Notification notif = this.getTableSupportsUpdateFeatureChange(notifications);
            if (notif != null) {
                String dialogTitle;
                boolean isSupportsUpdate = notif.getNewBooleanValue();
                if (isSupportsUpdate) {
                    if (!this.ignoreTableSupportsUpdateChangedTrue) {
                        dialogTitle = UiConstants.Util.getString("TransformationNotificationListener.tableSupportsUpdateChanged.title", new Object[0]);
                        final String disableFutureMessage = UiConstants.Util.getString("TransformationNotificationListener.tableSupportsUpdateChangedTrue.disableFutureDialogMessage", new Object[0]);
                        final String message = UiConstants.Util.getString("TransformationNotificationListener.tableSupportsUpdateChangedTrue.message", new Object[0]);
                        UiUtil.runInSwtThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UiPlugin.getDefault().getPreferenceStore().setValue("transformation.ui.preference.ignoreTableSupportsUpdateChangedTrue", "");
                                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)UiUtil.getWorkbenchWindow().getShell(), (String)dialogTitle, (String)message, (String)disableFutureMessage, (boolean)false, (IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"transformation.ui.preference.ignoreTableSupportsUpdateChangedTrue");
                                int retCode = dialog.getReturnCode();
                                TransformationNotificationListener.this.setColumnsUpdateableOnTableUpdateable = retCode == 2;
                            }
                        }, (boolean)true);
                        String ignoreChangesStr = UiPlugin.getDefault().getPreferenceStore().getString("transformation.ui.preference.ignoreTableSupportsUpdateChangedTrue");
                        if ("always".equals(ignoreChangesStr)) {
                            this.ignoreTableSupportsUpdateChangedTrue = true;
                        }
                    }
                    if (this.setColumnsUpdateableOnTableUpdateable) {
                        table = notif.getNotifier();
                        TransformationHelper.setTableColumnsSupportsUpdate((Object)table, (boolean)true);
                    }
                } else if (!this.ignoreTableSupportsUpdateChangedFalse) {
                    dialogTitle = UiConstants.Util.getString("TransformationNotificationListener.tableSupportsUpdateChanged.title", new Object[0]);
                    final String disableFutureMessage = UiConstants.Util.getString("TransformationNotificationListener.tableSupportsUpdateChangedFalse.disableFutureDialogMessage", new Object[0]);
                    final String message = UiConstants.Util.getString("TransformationNotificationListener.tableSupportsUpdateChangedFalse.message", new Object[0]);
                    UiUtil.runInSwtThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UiPlugin.getDefault().getPreferenceStore().setValue("transformation.ui.preference.ignoreTableSupportsUpdateChangedFalse", "");
                            MessageDialogWithToggle.openInformation((Shell)UiUtil.getWorkbenchWindow().getShell(), (String)dialogTitle, (String)message, (String)disableFutureMessage, (boolean)false, (IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"transformation.ui.preference.ignoreTableSupportsUpdateChangedFalse");
                        }
                    }, (boolean)true);
                    String ignoreChangesStr = UiPlugin.getDefault().getPreferenceStore().getString("transformation.ui.preference.ignoreTableSupportsUpdateChangedFalse");
                    if ("always".equals(ignoreChangesStr)) {
                        this.ignoreTableSupportsUpdateChangedFalse = true;
                    }
                }
            }
            if ((notif = this.getTableMaterializedViewChange(notifications)) != null && !(isMaterialized = notif.getNewBooleanValue()) && TransformationHelper.isVirtualSqlTable((Object)(table = notif.getNotifier()))) {
                ((Table)table).setMaterializedTable(null);
            }
            SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
        }
    }

    private void handleTargetVirtualTableColumnAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List addedColumns = this.getSqlColumnsAdded(notifications);
            EObject mappingRoot = this.getMappingRootFromVTableNotifications(notifications);
            if (!addedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    Iterator iter = addedColumns.iterator();
                    boolean colsAdded = false;
                    while (iter.hasNext()) {
                        Object column = iter.next();
                        if (!TransformationHelper.isSqlColumn(column)) continue;
                        AttributeMappingHelper.createAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                        colsAdded = true;
                    }
                    if (colsAdded) {
                        SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private void handleTargetVirtualTableColumnRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedColumns = this.getSqlColumnsRemoved(notifications);
            EObject mappingRoot = this.getMappingRootFromVTableNotifications(notifications);
            if (!removedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Remove atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    boolean overwriteDirty = false;
                    if (!(txnSource instanceof TransformationObjectEditorPage)) {
                        ModelObjectEditorPage moep;
                        TransformationObjectEditorPage transOEP = null;
                        boolean isDirty = false;
                        ModelResource mdlRsrc = ModelUtilities.getModelResourceForModelObject((EObject)mappingRoot);
                        IResource resource = mdlRsrc.getResource();
                        ModelEditor medit = ModelEditorManager.getModelEditorForFile((IFile)((IFile)resource), (boolean)false);
                        if (medit != null && (moep = medit.getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage && (transOEP = (TransformationObjectEditorPage)moep).hasPendingChanges()) {
                            isDirty = true;
                        }
                        if (isDirty) {
                            String dirtysql;
                            TransformationValidator qv;
                            QueryValidationResult qvr;
                            boolean dirtyValid;
                            final String message = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesMsg", (Object)resource.getName());
                            final String[] radioButtons = new String[]{SBC_RADIO_SAVE, SBC_RADIO_IGNORE, SBC_RADIO_HALT};
                            final IStatus[] radioErrors = new IStatus[3];
                            boolean savedValid = TransformationHelper.isValid((Object)mappingRoot, (int)0);
                            if (!savedValid) {
                                radioErrors[1] = new Status(2, "org.teiid.designer.transformation", -1, SBC_NOTE, null);
                            }
                            if (!(dirtyValid = (qvr = (qv = new TransformationValidator((SqlTransformationMappingRoot)mappingRoot, false)).validateSql(dirtysql = transOEP.getCurrentSqlEditor().getText(), 0, false)).isParsable())) {
                                radioErrors[0] = new Status(2, "org.teiid.designer.transformation", -1, SBC_NOTE, null);
                            }
                            UiUtil.runInSwtThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    uiIntegerResult = RadioMessageDialog.openMulti((Shell)UiUtil.getWorkbenchWindow().getShell(), (int)4, (String)SAVE_BEFORE_CHANGE_TITLE, (String)message, (String)SBC_GROUP_TITLE, (String[])radioButtons, (IStatus[])radioErrors, (int)0);
                                }
                            }, (boolean)true);
                            int result = uiIntegerResult;
                            switch (result) {
                                case 0: {
                                    TransformationHelper.setSelectSqlString((Object)mappingRoot, (String)dirtysql, (boolean)false, (Object)txnSource);
                                    TransformationSqlHelper.updateAllSqlOnElementsRemoved((EObject)mappingRoot, (List)removedColumns, (Object)txnSource);
                                    overwriteDirty = true;
                                    break;
                                }
                                case 1: {
                                    TransformationSqlHelper.updateAllSqlOnElementsRemoved((EObject)mappingRoot, (List)removedColumns, (Object)txnSource);
                                    overwriteDirty = true;
                                    break;
                                }
                                case 2: {
                                    overwriteDirty = false;
                                    break;
                                }
                            }
                        } else if (!(txnSource instanceof ReconcileTransformationAction) && this.shouldRemoveElemsFromSelect(mappingRoot, removedColumns)) {
                            TransformationSqlHelper.updateAllSqlOnElementsRemoved((EObject)mappingRoot, (List)removedColumns, (Object)txnSource);
                            overwriteDirty = true;
                        }
                    }
                    Iterator iter = removedColumns.iterator();
                    boolean mappingRemoved = false;
                    while (iter.hasNext()) {
                        Object column = iter.next();
                        if (!TransformationHelper.isSqlColumn(column)) continue;
                        AttributeMappingHelper.removeAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                        mappingRemoved = true;
                    }
                    if (mappingRemoved) {
                        SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource, (boolean)overwriteDirty);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private void handleTargetProcedureResultSetColumnAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List addedColumns = this.getSqlColumnsAdded(notifications);
            EObject mappingRoot = this.getMappingRootFromProcResultSetColumnNotifications(notifications);
            if (!addedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Add atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    for (Object column : addedColumns) {
                        if (!TransformationHelper.isSqlColumn(column)) continue;
                        AttributeMappingHelper.createAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private void handleTargetProcedureResultSetColumnRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedColumns = this.getSqlColumnsRemoved(notifications);
            EObject mappingRoot = this.getMappingRootFromProcResultSetColumnNotifications(notifications);
            if (!removedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Remove atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    for (Object column : removedColumns) {
                        if (!TransformationHelper.isSqlColumn(column)) continue;
                        AttributeMappingHelper.removeAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private void handleTargetProcedureResultSetOrParamAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            EObject mappingRoot = this.getMappingRootFromProcResultSetOrParamNotifications(notifications);
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update attr mappings", (Object)this);
            boolean succeeded = false;
            try {
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                AttributeMappingHelper.updateAttributeMappings((Object)mappingRoot, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void handleTargetProcedureParamChangeNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            EObject mappingRoot = this.getMappingRootFromProcParamNotifications(notifications);
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update attr mappings", (Object)this);
            boolean succeeded = false;
            try {
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                AttributeMappingHelper.updateAttributeMappings((Object)mappingRoot, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void handleTargetProcedureResultSetOrParamRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            EObject mappingRoot = this.getMappingRootFromProcResultSetOrParamNotifications(notifications);
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update attr mappings", (Object)this);
            boolean succeeded = false;
            try {
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                List targetAttrs = TransformationHelper.getTransformationTargetAttributes((EObject)mappingRoot);
                if (targetAttrs != null && !targetAttrs.isEmpty()) {
                    SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    AttributeMappingHelper.updateAttributeMappings((Object)mappingRoot, (Object)txnSource);
                    succeeded = true;
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void handleModelRenameNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            for (Notification notification : notifications) {
                Object changedObj;
                ModelResource modelResource;
                if (!NotificationUtilities.isChanged((Notification)notification) || (modelResource = ModelUtilities.getModelResource((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification)))) == null) continue;
                try {
                    EmfResource emfRes = (EmfResource)modelResource.getEmfResource();
                    List transformations = emfRes.getModelContents().getTransformations();
                    for (EObject eObj : transformations) {
                        if (!(eObj instanceof SqlTransformationMappingRoot)) continue;
                        SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)eObj;
                        SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                        SqlMappingRootCache.invalidateInsertStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                        SqlMappingRootCache.invalidateUpdateStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                        SqlMappingRootCache.invalidateDeleteStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    }
                }
                catch (ModelWorkspaceException e) {
                    Util.log(4, (Throwable)e, e.getMessage());
                }
            }
        }
    }

    private void handleUndo(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            Collection selectUserNotifications = this.getSqlSelectUserStatementChangeNotifications(notifications);
            Collection selectUIDNotifications = this.getSqlSelectUIDStatementChangeNotifications(notifications);
            if (!selectUIDNotifications.isEmpty()) {
                EObject mappingRoot = this.getMappingRootFromSqlUIDStatementNotifications(selectUIDNotifications);
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
            } else if (!selectUserNotifications.isEmpty()) {
                EObject mappingRoot = this.getMappingRootFromSqlUserStatementNotifications(selectUserNotifications);
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
            }
        }
        this.functionHandler.handleNotifications(notifications, txnSource);
    }

    private EObject getMappingRootFromSqlAliasNotifications(Collection sqlAliasNotifications) {
        Mapping mappingRoot = null;
        Iterator iter = sqlAliasNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            mappingRoot = TransformationHelper.getMappingRoot((MappingHelper)((MappingHelper)changedObj));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromVTableNotifications(Collection vTableNotifications) {
        EObject mappingRoot = null;
        Iterator iter = vTableNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)((EObject)changedObj));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromProcResultSetColumnNotifications(Collection resultSetNotifications) {
        Object resultSet;
        EObject mappingRoot = null;
        Iterator iter = resultSetNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null && TransformationHelper.isSqlColumnSet((Object)(resultSet = ModelerCore.getModelEditor().getChangedObject(firstNotification)))) {
            EObject procedure = ((EObject)resultSet).eContainer();
            mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)procedure);
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromProcResultSetOrParamNotifications(Collection resultSetNotifications) {
        Object procedure;
        EObject mappingRoot = null;
        Iterator iter = resultSetNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null && TransformationHelper.isSqlProcedure((Object)(procedure = ModelerCore.getModelEditor().getChangedObject(firstNotification)))) {
            mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)((EObject)procedure));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromProcParamNotifications(Collection parameterNotifications) {
        Object parameter;
        EObject mappingRoot = null;
        Iterator iter = parameterNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null && TransformationHelper.isSqlProcedureParameter((Object)(parameter = ModelerCore.getModelEditor().getChangedObject(firstNotification)))) {
            mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)((ProcedureParameter)parameter).getProcedure());
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromSqlUIDStatementNotifications(Collection sqlNotifications) {
        Mapping mappingRoot = null;
        Iterator iter = sqlNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            mappingRoot = TransformationHelper.getMappingRoot((MappingHelper)((MappingHelper)changedObj));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromSqlUserStatementNotifications(Collection sqlNotifications) {
        Mapping mappingRoot = null;
        Iterator iter = sqlNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            EObject parentEObj = ((EObject)changedObj).eContainer();
            mappingRoot = TransformationHelper.getMappingRoot((MappingHelper)((MappingHelper)parentEObj));
        }
        return mappingRoot;
    }

    private List getSqlAliasesAdded(Collection addNotifications) {
        ArrayList<EObject> sqlAliasList = new ArrayList<EObject>();
        for (Notification notification : addNotifications) {
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            int i = 0;
            while (i < newChildren.length) {
                if (newChildren[i] instanceof SqlAlias && !sqlAliasList.contains(newChildren[i])) {
                    sqlAliasList.add(newChildren[i]);
                }
                ++i;
            }
        }
        return sqlAliasList;
    }

    private List getSqlAliasesRemoved(Collection removeNotifications) {
        ArrayList<EObject> sqlAliasList = new ArrayList<EObject>();
        for (Notification notification : removeNotifications) {
            EObject[] newChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            int i = 0;
            while (i < newChildren.length) {
                if (newChildren[i] instanceof SqlAlias && !sqlAliasList.contains(newChildren[i])) {
                    sqlAliasList.add(newChildren[i]);
                }
                ++i;
            }
        }
        return sqlAliasList;
    }

    private List getSqlAliasesChanged(Collection changeNotifications) {
        ArrayList<Object> sqlAliasList = new ArrayList<Object>();
        for (Notification notification : changeNotifications) {
            Object removedAlias = notification.getOldValue();
            if (removedAlias instanceof SqlAlias && !sqlAliasList.contains(removedAlias)) {
                sqlAliasList.add(removedAlias);
                continue;
            }
            if (!(removedAlias instanceof List)) continue;
            for (Object nextObj : (List)removedAlias) {
                if (!(nextObj instanceof SqlAlias) || sqlAliasList.contains(nextObj)) continue;
                sqlAliasList.add(nextObj);
            }
        }
        return sqlAliasList;
    }

    private List getSqlColumnsAdded(Collection addNotifications) {
        ArrayList<EObject> tableColumnList = new ArrayList<EObject>();
        for (Notification notification : addNotifications) {
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            int i = 0;
            while (i < newChildren.length) {
                if (TransformationHelper.isSqlColumn((Object)newChildren[i]) && !tableColumnList.contains(newChildren[i])) {
                    tableColumnList.add(newChildren[i]);
                }
                ++i;
            }
        }
        return tableColumnList;
    }

    private List getSqlColumnsRemoved(Collection removeNotifications) {
        ArrayList<EObject> tableColumnList = new ArrayList<EObject>();
        for (Notification notification : removeNotifications) {
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            int i = 0;
            while (i < removedChildren.length) {
                if (TransformationHelper.isSqlColumn((Object)removedChildren[i]) && !tableColumnList.contains(removedChildren[i])) {
                    tableColumnList.add(removedChildren[i]);
                }
                ++i;
            }
        }
        return tableColumnList;
    }

    private Set getSqlTablesAddedTo(Collection addNotifications) {
        HashSet<Object> tableSet = new HashSet<Object>();
        for (Notification notification : addNotifications) {
            Object table = ModelerCore.getModelEditor().getChangedObject(notification);
            tableSet.add(table);
        }
        return tableSet;
    }

    private boolean containsSqlAlias(EObject[] eObjects) {
        boolean hasSqlAlias = false;
        int i = 0;
        while (i < eObjects.length) {
            if (eObjects[i] instanceof SqlAlias && !this.functionHandler.shouldHandleChangedObject(((SqlAlias)eObjects[i]).getAliasedObject())) {
                hasSqlAlias = true;
                break;
            }
            ++i;
        }
        return hasSqlAlias;
    }

    private boolean isSqlHelperSource(Object source) {
        boolean isSqlHelper = false;
        if (source != null && source.equals(TransformationSqlHelper.getInstance())) {
            isSqlHelper = true;
        }
        return isSqlHelper;
    }

    private boolean sqlAliasesChanged(Notification notification) {
        boolean aliasesChanged = false;
        Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
        if (changedObj instanceof SqlTransformation) {
            SqlAlias alias;
            int changedFeature = notification.getFeatureID(SqlTransformation.class);
            boolean isFunction = false;
            if (notification.getOldValue() instanceof SqlAlias && (alias = (SqlAlias)notification.getOldValue()).getAliasedObject() instanceof ScalarFunction) {
                isFunction = true;
            }
            if (!isFunction && changedFeature == 15) {
                aliasesChanged = true;
            }
        }
        return aliasesChanged;
    }

    private boolean sqlSelectUIDStatementChanged(Notification notification) {
        EObject parent;
        Object changedObj;
        boolean selectUIDStatementChanged = false;
        int changedFeature = notification.getFeatureID(SqlTransformation.class);
        if (changedFeature == 4 && (changedObj = ModelerCore.getModelEditor().getChangedObject(notification)) != null && changedObj instanceof SqlTransformation && !TransformationHelper.isSqlTransformation((Object)(parent = ((EObject)changedObj).eContainer()))) {
            selectUIDStatementChanged = true;
        }
        return selectUIDStatementChanged;
    }

    private boolean sqlSelectUserStatementChanged(Notification notification) {
        EObject parent;
        Object changedObj;
        boolean selectUserStatementChanged = false;
        int changedFeature = notification.getFeatureID(SqlTransformation.class);
        if (changedFeature == 4 && (changedObj = ModelerCore.getModelEditor().getChangedObject(notification)) != null && changedObj instanceof SqlTransformation && TransformationHelper.isSqlTransformation((Object)(parent = ((EObject)changedObj).eContainer()))) {
            selectUserStatementChanged = true;
        }
        return selectUserStatementChanged;
    }

    private boolean shouldAddElemsToSelect(Object mappingRoot) {
        ICommand selectCommand;
        boolean addElemsToSelect = false;
        if (TransformationHelper.isValid((Object)mappingRoot, (int)0) && (selectCommand = SqlMappingRootCache.getSelectCommand((Object)mappingRoot)) instanceof IQuery) {
            IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
            boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
            ISelect querySelect = ((IQuery)selectCommand).getSelect();
            if (!TransformationSqlHelper.isSelectStar((ISelect)querySelect) && !disableCallbacks) {
                final String message = UiConstants.Util.getString("TransformationNotificationListener.addSQLElemGrpAttrsMsg", (Object)DEFAULT_ADDED_SOURCE);
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        uiBooleanResult = MessageDialog.openQuestion((Shell)UiUtil.getWorkbenchWindow().getShell(), (String)ADD_SQL_ELEM_GRP_REFS_TITLE, (String)message);
                    }
                }, (boolean)true);
                addElemsToSelect = uiBooleanResult;
            } else {
                addElemsToSelect = true;
            }
        }
        return addElemsToSelect;
    }

    private boolean shouldRemoveGroupElemsFromSelect(Object mappingRoot, List sqlAliasGroups) {
        ICommand selectCommand;
        boolean removeElemsFromSelect = false;
        if (TransformationHelper.isValid((Object)mappingRoot, (int)0) && (selectCommand = SqlMappingRootCache.getSelectCommand((Object)mappingRoot)) instanceof IQuery) {
            IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
            boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
            ISelect querySelect = ((IQuery)selectCommand).getSelect();
            if (!TransformationSqlHelper.isSelectStar((ISelect)querySelect) && TransformationSqlHelper.hasSqlAliasGroupAttributes((IQuery)((IQuery)selectCommand), (List)sqlAliasGroups) && !disableCallbacks) {
                final String message = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemGrpRefsMsg", (Object)DEFAULT_REMOVED_SOURCE);
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        uiBooleanResult = MessageDialog.openQuestion((Shell)UiUtil.getWorkbenchWindow().getShell(), (String)REMOVE_SQL_ELEM_GRP_REFS_TITLE, (String)message);
                    }
                }, (boolean)true);
                removeElemsFromSelect = uiBooleanResult;
            } else {
                removeElemsFromSelect = true;
            }
        }
        return removeElemsFromSelect;
    }

    private boolean shouldRemoveElemsFromSelect(Object mappingRoot, List sqlColumns) {
        boolean removeElemsFromSelect = false;
        if (TransformationHelper.isValid((Object)mappingRoot, (int)0)) {
            ICommand selectCommand = SqlMappingRootCache.getSelectCommand((Object)mappingRoot);
            IQuery selectQuery = null;
            if (selectCommand instanceof IQueryCommand) {
                selectQuery = ((IQueryCommand)selectCommand).getProjectedQuery();
            }
            if (selectQuery != null) {
                IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
                boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
                if (TransformationSqlHelper.hasSqlElemSymbols((IQuery)selectQuery, (List)sqlColumns) && !disableCallbacks) {
                    UiUtil.runInSwtThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            uiBooleanResult = MessageDialog.openQuestion((Shell)UiUtil.getWorkbenchWindow().getShell(), (String)REMOVE_SQL_ELEMS_TITLE, (String)REMOVE_SQL_ELEMS_MSG);
                        }
                    }, (boolean)true);
                    removeElemsFromSelect = uiBooleanResult;
                } else {
                    removeElemsFromSelect = true;
                }
            }
        }
        return removeElemsFromSelect;
    }

    public void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        if (event.getType() == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SqlMappingRootCache.invalidateRootsOnProjectOrModelRemove();
                }
            });
        }
        this.functionHandler.processModelResourceEvent(event);
    }

    private class WorkspaceNotificationListener
    implements ModelWorkspaceNotificationListener {
        public void notifyAdd(ModelWorkspaceNotification notification) {
        }

        public void notifyRemove(ModelWorkspaceNotification notification) {
            if (notification.isPostChange()) {
                IResource resource;
                if (notification.isProject()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SqlMappingRootCache.invalidateRootsOnProjectOrModelRemove();
                        }
                    });
                } else if (notification.isFile() && ModelUtil.isModelFile((IResource)(resource = (IResource)notification.getNotifier()))) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SqlMappingRootCache.invalidateRootsOnProjectOrModelRemove();
                        }
                    });
                }
            }
        }

        public void notifyMove(ModelWorkspaceNotification notification) {
        }

        public void notifyRename(ModelWorkspaceNotification notification) {
        }

        public void notifyOpen(ModelWorkspaceNotification notification) {
        }

        public void notifyClosing(ModelWorkspaceNotification notification) {
        }

        public void notifyChanged(Notification theNotification) {
        }

        public void notifyReloaded(ModelWorkspaceNotification notification) {
        }

        public void notifyClean(final IProject proj) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SqlMappingRootCache.invalidateCacheForProject((IProject)proj);
                }
            });
        }
    }
}

