/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.SetQueryUtil;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IQueryCommand;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.transformation.ui.reconciler.ReconcilerObject;
import org.teiid.designer.transformation.util.AttributeMappingHelper;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;

public class QueryReconcilerHelper {
    private static final String REORDER_DETECTED_TITLE = UiConstants.Util.getString("QueryReconcilerHelper.reorderDetectedTitle", new Object[0]);
    private static final String REORDER_DETECTED_MESSAGE = UiConstants.Util.getString("QueryReconcilerHelper.reorderDetectedMessage", new Object[0]);
    private SqlTransformationMappingRoot transMappingRoot;
    private ReconcilerObject reconcilerObject = null;
    private boolean isPrimarySelectClause = true;

    public QueryReconcilerHelper(SqlTransformationMappingRoot transformationObj, int unionQuerySegment) {
        this.transMappingRoot = transformationObj;
        this.init(this.transMappingRoot, unionQuerySegment);
    }

    private void init(SqlTransformationMappingRoot mappingRoot, int unionQuerySegment) {
        if (mappingRoot != null) {
            TransformationValidator validator;
            QueryValidationResult result;
            List queries;
            ICommand originalCommand = SqlMappingRootCache.getSelectCommand((Object)mappingRoot);
            if (originalCommand instanceof ISetQuery && unionQuerySegment != -1 && !(originalCommand = (ICommand)(queries = SetQueryUtil.getQueryList((ISetQuery)((ISetQuery)originalCommand))).get(unionQuerySegment)).isResolved() && (result = (validator = new TransformationValidator(mappingRoot)).validateSql(originalCommand.toString(), 0, false)).isResolvable()) {
                originalCommand = result.getCommand();
            }
            EObject virtualTarget = TransformationHelper.getTransformationTarget((Object)mappingRoot);
            boolean isLocked = mappingRoot.isOutputReadOnly();
            this.reconcilerObject = new ReconcilerObject(virtualTarget, originalCommand, isLocked);
            if (unionQuerySegment > 0) {
                this.isPrimarySelectClause = false;
            }
        }
    }

    public void applyAllModifications(int uIndex, Object txnSource) {
        if (this.reconcilerObject.hasValidModifications()) {
            if (uIndex > 0) {
                this.applyUnionSegmentModifications(uIndex, txnSource);
                return;
            }
            if (this.reconcilerObject.hasTargetAttributesToDelete()) {
                List attributes = this.reconcilerObject.getTargetAttributesToDelete();
                TransformationMappingHelper.removeTargetAttributes((Object)this.transMappingRoot, (List)attributes, (boolean)true, (Object)txnSource);
            }
            if (TransformationMappingHelper.shouldCreateTargetAttributes() && !this.reconcilerObject.isTargetLocked() && this.reconcilerObject.hasTargetAttributesToCreate()) {
                List attributeNames = this.reconcilerObject.getTargetAttributeNamesToCreate();
                EObject targetGroup = TransformationHelper.getTransformationTarget((Object)this.transMappingRoot);
                TransformationMappingHelper.addTargetAttributes((EObject)targetGroup, (List)attributeNames, (Object)txnSource);
                if (!(targetGroup instanceof MappingClass)) {
                    Map attrLengthMap = this.reconcilerObject.getCreatedAttrLengthMap();
                    TransformationMappingHelper.setGroupAttributeLengths((EObject)targetGroup, (Map)attrLengthMap);
                }
                List allAttributes = TransformationHelper.getTransformationTargetAttributes((EObject)this.transMappingRoot);
                int numAttributes = allAttributes.size();
                int i = 0;
                while (i < numAttributes) {
                    SqlColumnAspect columnAspect;
                    String name;
                    EObject attr = (EObject)allAttributes.get(i);
                    if (SqlAspectHelper.isColumn((EObject)attr) && this.hasNameMatch(attributeNames, name = (columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)attr)).getName(attr))) {
                        List bindings = this.reconcilerObject.getBindingList().getAll();
                        int numBindings = bindings.size();
                        int j = 0;
                        while (j < numBindings) {
                            Binding binding = (Binding)bindings.get(j);
                            if (binding.getAttributeName().equalsIgnoreCase(name)) {
                                binding.setAttribute(attr);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (this.reconcilerObject.hasTargetAttributeTypeMods()) {
                this.reconcilerObject.applyTargetAttributeTypeMods(txnSource);
            }
            if (uIndex == 0) {
                this.applyUnionSegmentModifications(uIndex, txnSource);
            } else if (this.reconcilerObject.hasValidSqlModifications()) {
                String newSql = this.reconcilerObject.getModifiedSql();
                TransformationHelper.setSelectSqlString((Object)this.transMappingRoot, (String)newSql, (boolean)true, (Object)txnSource);
            }
            AttributeMappingHelper.updateAttributeMappings((Object)this.transMappingRoot, (Object)txnSource);
            TransformationMappingHelper.orderGroupAttributes((EObject)this.transMappingRoot, (boolean)false, null);
        }
    }

    public void applyPreModifications(Object txnSource) {
        if (this.reconcilerObject.hasTargetAttributesToRename()) {
            this.reconcilerObject.applyTargetAttributeRenames(txnSource);
        }
    }

    public boolean hasPreModifications() {
        return this.reconcilerObject.hasTargetAttributesToRename();
    }

    public ReconcilerObject getReconcilerObject() {
        return this.reconcilerObject;
    }

    public void setTargetLocked(boolean shouldLock) {
        if (this.transMappingRoot != null && this.transMappingRoot.isOutputReadOnly() != shouldLock) {
            this.transMappingRoot.setOutputReadOnly(shouldLock);
        }
        this.reconcilerObject.setTargetLocked(shouldLock);
    }

    private void applyUnionSegmentModifications(int uIndex, Object txnSource) {
        if (!this.reconcilerObject.isTargetLocked() && this.reconcilerObject.hasTargetAttributesToCreate()) {
            List attributeNames = this.reconcilerObject.getTargetAttributeNamesToCreate();
            EObject targetGroup = TransformationHelper.getTransformationTarget((Object)this.transMappingRoot);
            TransformationMappingHelper.addTargetAttributes((EObject)targetGroup, (List)attributeNames, (Object)txnSource);
            if (!(targetGroup instanceof MappingClass)) {
                Map attrLengthMap = this.reconcilerObject.getCreatedAttrLengthMap();
                TransformationMappingHelper.setGroupAttributeLengths((EObject)targetGroup, (Map)attrLengthMap);
            }
            List allAttributes = TransformationHelper.getTransformationTargetAttributes((EObject)this.transMappingRoot);
            int numAttributes = allAttributes.size();
            int i = 0;
            while (i < numAttributes) {
                SqlColumnAspect columnAspect;
                String name;
                EObject attr = (EObject)allAttributes.get(i);
                if (SqlAspectHelper.isColumn((EObject)attr) && this.hasNameMatch(attributeNames, name = (columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)attr)).getName(attr))) {
                    List bindings = this.reconcilerObject.getBindingList().getAll();
                    int numBindings = bindings.size();
                    int j = 0;
                    while (j < numBindings) {
                        Binding binding = (Binding)bindings.get(j);
                        if (binding.getAttributeName().equalsIgnoreCase(name)) {
                            binding.setAttribute(attr);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.reconcilerObject.hasValidSqlModifications()) {
            ICommand command;
            String newSegmentSql = this.reconcilerObject.getModifiedSql();
            TransformationValidator validator = new TransformationValidator(this.transMappingRoot);
            QueryValidationResult result = validator.validateSql(newSegmentSql, 0, false);
            IQueryCommand newSegmentCommand = null;
            if (result.isParsable()) {
                newSegmentCommand = (IQueryCommand)result.getCommand();
            }
            if ((command = SqlMappingRootCache.getSelectCommand((Object)this.transMappingRoot)) != null && command instanceof ISetQuery) {
                ISetQuery unionQuery = (ISetQuery)command.clone();
                SetQueryUtil.setQueryAtIndex((ISetQuery)unionQuery, (int)uIndex, (IQueryCommand)newSegmentCommand);
                String newUnionSql = unionQuery.toString();
                TransformationHelper.setSelectSqlString((Object)this.transMappingRoot, (String)newUnionSql, (boolean)true, (Object)txnSource);
            }
        }
        if (this.reconcilerObject.hasTargetAttributesToDelete()) {
            List attributes = this.reconcilerObject.getTargetAttributesToDelete();
            TransformationMappingHelper.removeTargetAttributes((Object)this.transMappingRoot, (List)attributes, (boolean)true, (Object)txnSource);
        }
        if (this.reconcilerObject.hasTargetAttributesToRename()) {
            this.reconcilerObject.applyTargetAttributeRenames(txnSource);
        }
        if (this.reconcilerObject.hasTargetAttributeTypeMods()) {
            this.reconcilerObject.applyTargetAttributeTypeMods(txnSource);
        }
        AttributeMappingHelper.updateAttributeMappings((Object)this.transMappingRoot, (Object)txnSource);
        boolean wasReordered = TransformationMappingHelper.orderGroupAttributes((EObject)this.transMappingRoot, (boolean)true, (ICommand)this.reconcilerObject.getModifiedCommand());
        if (wasReordered) {
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openWarning((Shell)shell, (String)REORDER_DETECTED_TITLE, (String)REORDER_DETECTED_MESSAGE);
        }
    }

    private boolean hasNameMatch(List list, String str) {
        boolean hasMatch = false;
        for (String listStr : list) {
            if (listStr == null || !listStr.equalsIgnoreCase(str)) continue;
            hasMatch = true;
            break;
        }
        return hasMatch;
    }

    public boolean isPrimarySelectClause() {
        return this.isPrimarySelectClause;
    }
}

