/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.expression;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectEditor;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.CalendarWidget;
import org.teiid.query.ui.builder.model.ConstantEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;
import org.teiid.query.ui.builder.util.BuilderUtils;

public final class ConstantEditor
extends AbstractLanguageObjectEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ConstantEditor.class);
    private Control currentControl;
    private ViewController controller = new ViewController();
    ConstantEditorModel model;
    private StackLayout stackLayout;
    String validChars;
    private Combo cbxType;
    private CalendarWidget dateWidget;
    private Label lblNull;
    private Label lblType;
    private Composite pnlBoolean;
    private Composite pnlContent;
    private Composite pnlDate;
    private Composite pnlNull;
    private Composite pnlText;
    private Group pnlValues;
    private Button rdbFalse;
    private Button rdbTrue;
    private Text txfValue;

    public ConstantEditor(Composite theParent, ConstantEditorModel theModel) {
        super(theParent, IConstant.class, (ILanguageObjectEditorModel)theModel);
        this.model = theModel;
        this.model.addModelListener((ILanguageObjectEditorModelListener)this.controller);
        this.controller.initialize();
    }

    @Override
    public void acceptFocus() {
        if (this.isConversionType()) {
            this.cbxType.setFocus();
        } else if (this.currentControl == this.pnlNull) {
            this.cbxType.setFocus();
        } else if (this.currentControl == this.pnlBoolean) {
            if (this.rdbTrue.getSelection()) {
                this.rdbTrue.setFocus();
            } else {
                this.rdbFalse.setFocus();
            }
        } else if (this.currentControl == this.pnlText) {
            this.txfValue.setFocus();
        } else if (this.currentControl == this.pnlDate) {
            this.dateWidget.setFocus();
        }
    }

    private void constructBooleanWidgets() {
        if (this.rdbTrue == null) {
            this.rdbTrue = new Button(this.pnlBoolean, 16);
            this.rdbTrue.setLayoutData((Object)new GridData(34));
            this.rdbTrue.setText(Util.getString(String.valueOf(PREFIX) + "rdbTrue", new Object[0]));
            this.rdbTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent theEvent) {
                    ConstantEditor.this.handleTrueSelected();
                }
            });
            this.rdbTrue.setSelection(true);
            this.rdbFalse = new Button(this.pnlBoolean, 16);
            this.rdbFalse.setLayoutData((Object)new GridData(34));
            this.rdbFalse.setText(Util.getString(String.valueOf(PREFIX) + "rdbFalse", new Object[0]));
            this.rdbFalse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent theEvent) {
                    ConstantEditor.this.handleFalseSelected();
                }
            });
            this.pnlBoolean.pack();
        }
    }

    private void constructDateWidgets() {
        if (this.dateWidget == null) {
            this.dateWidget = new CalendarWidget(this.pnlDate, 0, false);
            this.dateWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConstantEditor.this.handleDateChanged();
                }
            });
            this.dateWidget.setLayoutData((Object)new GridData());
            this.pnlDate.pack();
        }
    }

    private void constructNullWidgets() {
        if (this.lblNull == null) {
            this.lblNull = new Label(this.pnlNull, 2048);
            this.lblNull.setLayoutData((Object)new GridData(768));
            this.lblNull.setText(Util.getString(String.valueOf(PREFIX) + "txfNull", new Object[0]));
            this.pnlNull.pack();
        }
    }

    private void constructTextWidgets() {
        if (this.txfValue == null) {
            this.txfValue = new Text(this.pnlText, 2048);
            this.txfValue.setLayoutData((Object)new GridData(768));
            this.txfValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent theEvent) {
                    ConstantEditor.this.handleTextChange();
                }
            });
            this.txfValue.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent theEvent) {
                    String text = theEvent.text;
                    if (text != null && text.length() > 0) {
                        int size = text.length();
                        int i = 0;
                        while (i < size) {
                            if (ConstantEditor.this.validChars != null && ConstantEditor.this.validChars.indexOf(text.charAt(i)) == -1) {
                                theEvent.doit = false;
                                break;
                            }
                            if (!ConstantEditor.this.model.isValidValue(text)) {
                                theEvent.doit = false;
                                break;
                            }
                            ++i;
                        }
                    }
                }
            });
            this.txfValue.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent theEvent) {
                    if (theEvent.detail == 4) {
                        theEvent.detail = 0;
                        theEvent.doit = true;
                    }
                }
            });
            this.pnlText.pack();
        }
    }

    @Override
    protected void createUi(Composite theParent) {
        this.pnlContent = new Composite(theParent, 0);
        this.pnlContent.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pnlContent.setLayout((Layout)layout);
        this.lblType = new Label(this.pnlContent, 0);
        this.lblType.setLayoutData((Object)new GridData(128));
        this.lblType.setText(Util.getString(String.valueOf(PREFIX) + "lblType", new Object[0]));
        this.cbxType = new Combo(this.pnlContent, 2056);
        this.cbxType.setLayoutData((Object)new GridData(768));
        this.cbxType.setItems(BuilderUtils.getAllTypes().toArray(new String[0]));
        this.cbxType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ConstantEditor.this.handleTypeSelected();
            }
        });
        this.pnlValues = new Group(this.pnlContent, 0);
        this.pnlValues.setText(Util.getString(String.valueOf(PREFIX) + "pnlValues", new Object[0]));
        this.stackLayout = new StackLayout();
        this.pnlValues.setLayout((Layout)this.stackLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.pnlValues.setLayoutData((Object)gd);
        this.pnlText = new Composite((Composite)this.pnlValues, 0);
        this.pnlText.setLayout((Layout)new GridLayout());
        this.pnlText.setLayoutData((Object)new GridData(1808));
        this.pnlNull = new Composite((Composite)this.pnlValues, 0);
        this.pnlNull.setLayout((Layout)new GridLayout());
        this.pnlNull.setLayoutData((Object)new GridData(1808));
        this.pnlBoolean = new Composite((Composite)this.pnlValues, 0);
        this.pnlBoolean.setLayout((Layout)new GridLayout());
        this.pnlBoolean.setLayoutData((Object)new GridData(1808));
        this.pnlDate = new Composite((Composite)this.pnlValues, 0);
        this.pnlDate.setLayout((Layout)new GridLayout());
        this.pnlDate.setLayoutData((Object)new GridData(1808));
    }

    void displayBooleanTypeUi() {
        this.normalizeTypes();
        boolean value = this.model.getBoolean();
        this.constructBooleanWidgets();
        if (this.rdbTrue.getSelection() != value) {
            if (this.model.getBoolean()) {
                WidgetUtil.selectRadioButton((Button)this.rdbTrue);
            } else {
                WidgetUtil.selectRadioButton((Button)this.rdbFalse);
            }
        }
        this.showControl((Control)this.pnlBoolean);
    }

    void displayConversionTypeUi() {
        this.normalizeTypes();
        this.showValueLabel(false);
    }

    void displayDateTypeUi() {
        this.normalizeTypes();
        this.constructDateWidgets();
        this.dateWidget.setValue(this.model.getDate());
        this.dateWidget.showCalendar(true);
        this.dateWidget.showTime(false);
        this.pnlDate.pack();
        this.showControl((Control)this.pnlDate);
    }

    void displayNullTypeUi() {
        this.normalizeTypes();
        this.constructNullWidgets();
        this.showControl((Control)this.pnlNull);
    }

    void displayTextTypeUi() {
        this.normalizeTypes();
        String value = this.model.getText();
        if (value == null) {
            value = "";
        }
        this.constructTextWidgets();
        if (!this.txfValue.getText().equals(value)) {
            this.txfValue.setText(value);
            this.txfValue.setSelection(value.length());
        }
        this.showControl((Control)this.pnlText);
    }

    void displayTimeTypeUi() {
        this.normalizeTypes();
        this.constructDateWidgets();
        this.dateWidget.setValue(this.model.getTime());
        this.dateWidget.showCalendar(false);
        this.dateWidget.showTime(true);
        this.pnlDate.pack();
        this.showControl((Control)this.pnlDate);
    }

    void displayTimestampTypeUi() {
        this.normalizeTypes();
        this.constructDateWidgets();
        this.dateWidget.setValue(this.model.getTimestamp());
        this.dateWidget.showCalendar(true);
        this.dateWidget.showTime(true);
        this.pnlDate.pack();
        this.showControl((Control)this.pnlDate);
    }

    void displayTypeUi() {
        this.normalizeTypes();
        this.constructTextWidgets();
        String modelType = this.model.getType();
        this.txfValue.setTextLimit(BuilderUtils.getTextLimit((String)modelType));
        this.cbxType.setText(modelType);
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    @Override
    public String getToolTipText() {
        return Util.getString(String.valueOf(PREFIX) + "tip", new Object[0]);
    }

    void handleDateChanged() {
        if (this.dateWidget.isDateWidget()) {
            this.model.setDate(this.dateWidget.getDate());
        } else if (this.dateWidget.isTimeWidget()) {
            this.model.setTime(this.dateWidget.getTime());
        } else if (this.dateWidget.isTimestampWidget()) {
            this.model.setTimestamp(this.dateWidget.getTimestamp());
        }
    }

    void handleFalseSelected() {
        if (this.rdbFalse.getSelection()) {
            this.model.setBoolean(false);
        }
    }

    void handleTextChange() {
        this.model.setText(this.txfValue.getText());
    }

    void handleTrueSelected() {
        if (this.rdbTrue.getSelection()) {
            this.model.setBoolean(true);
        }
    }

    void handleTypeSelected() {
        int index = this.cbxType.getSelectionIndex();
        this.model.setType(this.cbxType.getItem(index));
    }

    public boolean isConversionType() {
        return this.model.isConversionType();
    }

    private void normalizeTypes() {
        String selection = this.cbxType.getText();
        boolean conversionType = this.isConversionType();
        for (String invalidType : BuilderUtils.getInvalidTypes()) {
            if (conversionType) {
                if (this.cbxType.indexOf(invalidType) == -1) break;
                this.cbxType.remove(invalidType);
                continue;
            }
            if (this.cbxType.indexOf(invalidType) != -1) break;
            this.cbxType.add(invalidType);
        }
        this.cbxType.setText(selection);
    }

    @Override
    public void setLanguageObject(ILanguageObject theLanguageObject) {
        if (theLanguageObject == null) {
            this.clear();
        } else {
            CoreArgCheck.isTrue((boolean)(theLanguageObject instanceof IConstant), (String)Util.getString(String.valueOf(PREFIX) + "invalidLanguageObject", new Object[]{theLanguageObject.getClass().getName()}));
            this.model.setLanguageObject(theLanguageObject);
        }
    }

    private void showControl(Control theControl) {
        this.showValueLabel(true);
        if (this.currentControl != theControl) {
            this.stackLayout.topControl = this.currentControl = theControl;
            this.pnlValues.layout();
        }
        this.acceptFocus();
    }

    private void showValueLabel(boolean theShowFlag) {
        this.pnlValues.setVisible(theShowFlag);
    }

    class ViewController
    implements ILanguageObjectEditorModelListener {
        ViewController() {
        }

        public void initialize() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewController.this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)((ViewController)ViewController.this).ConstantEditor.this.model, "TYPE"));
                }
            });
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("SAVED")) {
                this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)ConstantEditor.this.model, "TYPE"));
            } else if (type.equals("TYPE")) {
                ConstantEditor.this.displayTypeUi();
                if (ConstantEditor.this.model.isConversionType()) {
                    ConstantEditor.this.displayConversionTypeUi();
                } else if (ConstantEditor.this.model.isText()) {
                    this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)ConstantEditor.this.model, "TEXT"));
                } else if (ConstantEditor.this.model.isBoolean()) {
                    this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)ConstantEditor.this.model, "BOOLEAN"));
                } else if (ConstantEditor.this.model.isNull()) {
                    this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)ConstantEditor.this.model, "NULL"));
                } else if (ConstantEditor.this.model.isDate()) {
                    this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)ConstantEditor.this.model, "DATE"));
                } else if (ConstantEditor.this.model.isTime()) {
                    this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)ConstantEditor.this.model, "TIME"));
                } else if (ConstantEditor.this.model.isTimestamp()) {
                    this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)ConstantEditor.this.model, "TIMESTAMP"));
                }
            } else if (type.equals("TEXT")) {
                ConstantEditor.this.displayTextTypeUi();
            } else if (type.equals("BOOLEAN")) {
                ConstantEditor.this.displayBooleanTypeUi();
            } else if (type.equals("NULL")) {
                ConstantEditor.this.displayNullTypeUi();
            } else if (type.equals("DATE")) {
                ConstantEditor.this.displayDateTypeUi();
            } else if (type.equals("TIME")) {
                ConstantEditor.this.displayTimeTypeUi();
            } else if (type.equals("TIMESTAMP")) {
                ConstantEditor.this.displayTimestampTypeUi();
            }
        }
    }
}

