/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RevalidateModelTransformationsAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    private ModelResource modelResource;
    List brokenTables = Collections.EMPTY_LIST;
    private static final String REVALIDATE_TRANS = "Revalidate Transformations";

    public RevalidateModelTransformationsAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/validate.gif"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)selection);
        boolean enable = false;
        if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject))) {
            try {
                this.modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
                if (ModelUtilities.isVirtual((ModelResource)this.modelResource)) {
                    enable = true;
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.setEnabled(enable);
    }

    public void run() {
        ModelObjectEditorPage moep;
        IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
            ((MultiPageModelEditor)editor).closeObjectEditor();
        }
        IResource resource = this.modelResource.getResource();
        ModelEditorManager.getModelEditorForFile((IFile)((IFile)resource), (boolean)true);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                RevalidateModelTransformationsAction.this.brokenTables = RevalidateModelTransformationsAction.this.revalidate();
                theMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(e.getTargetException());
        }
        this.warnUserAboutInvalidTransformations(this.brokenTables);
        this.brokenTables = Collections.EMPTY_LIST;
    }

    List revalidate() {
        ArrayList<EObject> brokenSqlTables = new ArrayList<EObject>();
        if (this.modelResource != null) {
            UiPlugin.getDefault().setIgnoreTransformationNotifications(true);
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)REVALIDATE_TRANS, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    Object nextObj2 = null;
                    List transformations = this.modelResource.getModelTransformations().getTransformations();
                    this.invalidateSqlRootCache(transformations);
                    for (Object nextObj2 : transformations) {
                        if (!TransformationHelper.isSqlTransformationMappingRoot(nextObj2)) continue;
                        SqlTransformationMappingRoot mappingRoot = nextObj2;
                        TransformationValidator qv = new TransformationValidator(mappingRoot, false);
                        boolean supportsUpdates = false;
                        EObject mRootTarget = mappingRoot.getTarget();
                        SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)mRootTarget);
                        if (sqlAspect != null && sqlAspect instanceof SqlTableAspect) {
                            supportsUpdates = ((SqlTableAspect)sqlAspect).supportsUpdate(mRootTarget);
                        }
                        boolean selectValid = true;
                        boolean insertValid = true;
                        boolean updateValid = true;
                        boolean deleteValid = true;
                        selectValid = this.resetTransformation(mappingRoot, 0, (QueryValidator)qv);
                        if (supportsUpdates) {
                            insertValid = this.resetTransformation(mappingRoot, 1, (QueryValidator)qv);
                            updateValid = this.resetTransformation(mappingRoot, 2, (QueryValidator)qv);
                            deleteValid = this.resetTransformation(mappingRoot, 3, (QueryValidator)qv);
                        } else {
                            this.clearUUIDSqlString(mappingRoot, 1);
                            this.clearUUIDSqlString(mappingRoot, 2);
                            this.clearUUIDSqlString(mappingRoot, 3);
                        }
                        if (selectValid && insertValid && updateValid && deleteValid) continue;
                        brokenSqlTables.add(mRootTarget);
                    }
                    succeeded = true;
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log((Throwable)e);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    UiPlugin.getDefault().setIgnoreTransformationNotifications(false);
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                UiPlugin.getDefault().setIgnoreTransformationNotifications(false);
            }
        }
        return brokenSqlTables;
    }

    private boolean resetTransformation(SqlTransformationMappingRoot mappingRoot, int cmdType, QueryValidator qv) {
        String userSqlString = TransformationHelper.getSqlString((Object)mappingRoot, (int)cmdType);
        this.setUserString(mappingRoot, userSqlString, cmdType);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)mappingRoot, null);
        QueryValidationResult result = qv.validateSql(userSqlString, cmdType, false);
        return result.isParsable() && result.isResolvable() && result.isValidatable();
    }

    private void clearUUIDSqlString(SqlTransformationMappingRoot mappingRoot, int cmdType) {
        MappingHelper helper;
        if (mappingRoot != null && (helper = mappingRoot.getHelper()) != null && helper instanceof SqlTransformation) {
            SqlTransformation sqlHelper = (SqlTransformation)helper;
            switch (cmdType) {
                case 0: {
                    sqlHelper.setSelectSql(null);
                    break;
                }
                case 1: {
                    if (!sqlHelper.isInsertAllowed() || sqlHelper.isInsertSqlDefault()) break;
                    sqlHelper.setInsertSql(null);
                    break;
                }
                case 2: {
                    if (!sqlHelper.isUpdateAllowed() || sqlHelper.isUpdateSqlDefault()) break;
                    sqlHelper.setUpdateSql(null);
                    break;
                }
                case 3: {
                    if (!sqlHelper.isDeleteAllowed() || sqlHelper.isDeleteSqlDefault()) break;
                    sqlHelper.setDeleteSql(null);
                    break;
                }
            }
        }
    }

    private void setUserString(SqlTransformationMappingRoot mappingRoot, String userSqlStr, int cmdType) {
        if (cmdType == 0) {
            TransformationHelper.setSelectSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        } else if (cmdType == 1) {
            TransformationHelper.setInsertSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        } else if (cmdType == 2) {
            TransformationHelper.setUpdateSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        } else if (cmdType == 3) {
            TransformationHelper.setDeleteSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)this);
        }
    }

    public void warnUserAboutInvalidTransformations(List invalidSourceList) {
        if (!invalidSourceList.isEmpty()) {
            String title = UiConstants.Util.getString("RevalidateModelTransformationsAction.invalidTransformationsTitle", new Object[0]);
            String msg = UiConstants.Util.getString("RevalidateModelTransformationsAction.invalidTransformationsMessage", new Object[0]);
            ArrayList<String> copyOfList = new ArrayList<String>(invalidSourceList.size());
            for (Object nextObj : invalidSourceList) {
                String path = ModelObjectUtilities.getTrimmedFullPath((EObject)((EObject)nextObj));
                String name = ModelerCore.getModelEditor().getName((EObject)nextObj);
                String row = String.valueOf(path) + "/" + name;
                copyOfList.add(row);
            }
            ListMessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, null, (String)msg, copyOfList, null);
        }
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public boolean isApplicable(ISelection selection) {
        boolean result = false;
        Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)selection);
        if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject))) {
            try {
                this.modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
                if (ModelUtilities.isVirtual((ModelResource)this.modelResource)) {
                    result = true;
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return result;
    }

    private void invalidateSqlRootCache(List mappingRoots) {
        Object nextObj2 = null;
        for (Object nextObj2 : mappingRoots) {
            if (!(nextObj2 instanceof SqlTransformationMappingRoot)) continue;
            SqlTransformationMappingRoot mappingRoot = nextObj2;
            SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)false, (Object)this);
        }
    }
}

