/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.editors.EditTransformationHelper;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class EditTransformationAction
extends SortableSelectionAction
implements UiConstants {
    private static final String label = Util.getString("TransformationObjectEditorPage.editTransformationsId", (Object)-1);
    private static final String tooltip = Util.getString("TransformationObjectEditorPage.editTransformationsTooltip", (Object)-1);

    public EditTransformationAction() {
        super(label, -1);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_edit_transformation.gif"));
        this.setToolTipText(tooltip);
    }

    public boolean isValidSelection(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    public void run() {
        Object selectedObj;
        ISelection cachedSelection = this.getSelection();
        if (cachedSelection != null && !cachedSelection.isEmpty() && (selectedObj = SelectionUtilities.getSelectedObject((ISelection)cachedSelection)) != null && selectedObj instanceof IFile) {
            ModelResource modelResource = null;
            try {
                EditTransformationHelper helper;
                EObject target;
                modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                if (modelResource != null && (target = (helper = new EditTransformationHelper(modelResource)).queryUserToSelectTarget()) != null) {
                    helper.openAndEdit(target);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.selectionChanged(null, (ISelection)new StructuredSelection());
    }

    public boolean isApplicable(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    private boolean virtualModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalViewModel((IResource)((IFile)nextObj)) || ModelIdentifier.isXmlViewModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }
}

