/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.CreateMaterializedViewWizard;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CreateMaterializedViewsAction
extends SortableSelectionAction {
    public static final String OPEN_EDITOR_TITLE = UiConstants.Util.getString("CreateMaterializedViewsAction.openModelEditorTitle", new Object[0]);
    public static final String OPEN_EDITOR_MESSAGE = UiConstants.Util.getString("CreateMaterializedViewsAction.openModelEditorMessage", new Object[0]);
    public static final String ALWAY_FORCE_OPEN_MESSAGE = UiConstants.Util.getString("CreateMaterializedViewsAction.alwaysForceOpenMessage", new Object[0]);

    public CreateMaterializedViewsAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/materialized_views.png"));
    }

    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    protected boolean isValidSelection(ISelection selection) {
        boolean isValid = true;
        if (SelectionUtilities.isEmptySelection((ISelection)selection) || !SelectionUtilities.isAllEObjects((ISelection)selection)) {
            isValid = false;
        }
        if (isValid) {
            List objs = SelectionUtilities.getSelectedEObjects((ISelection)selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext() && isValid) {
                EObject next = (EObject)selections.next();
                isValid = this.isRelationalVirtualTable(next) && TransformationHelper.isVirtualSqlTable((Object)next);
                if (isValid) {
                    continue;
                }
                break;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    private boolean isRelationalVirtualTable(EObject eObject) {
        Resource resource;
        if (TransformationHelper.isVirtualSqlTable((Object)eObject) && (resource = eObject.eResource()) != null) {
            ModelResource mr = ModelUtilities.getModelResource((Resource)resource, (boolean)true);
            return ModelIdentifier.isRelationalViewModel((ModelResource)mr);
        }
        return false;
    }

    public void run() {
        IWorkbenchWindow iww = UiPlugin.getDefault().getCurrentWorkbenchWindow();
        EObject firstEObj = (EObject)SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).get(0);
        boolean userCancelled = false;
        if (!ModelEditorManager.isOpen((EObject)firstEObj)) {
            String autoOpen = UiPlugin.getDefault().getPreferenceStore().getString("autoOpenEditorIfNeeded");
            boolean forceOpen = false;
            if (autoOpen.equals("always")) {
                forceOpen = true;
            } else if (autoOpen.equals("never")) {
                forceOpen = false;
            }
            if (!forceOpen) {
                Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                MessageDialogWithToggle tDialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)OPEN_EDITOR_TITLE, (String)OPEN_EDITOR_MESSAGE, (String)ALWAY_FORCE_OPEN_MESSAGE, (boolean)false, (IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"autoOpenEditorIfNeeded");
                int result = tDialog.getReturnCode();
                switch (result) {
                    case 0: 
                    case 2: {
                        forceOpen = true;
                        break;
                    }
                    case 3: {
                        forceOpen = false;
                        userCancelled = true;
                    }
                }
            }
            if (forceOpen) {
                ModelEditorManager.open((EObject)firstEObj, (boolean)true);
            }
        }
        if (userCancelled) {
            return;
        }
        CreateMaterializedViewWizard wizard = new CreateMaterializedViewWizard();
        wizard.init(iww.getWorkbench(), (IStructuredSelection)new StructuredSelection(SelectionUtilities.getSelectedObjects((ISelection)this.getSelection())));
        WizardDialog dialog = new WizardDialog(wizard.getShell(), (IWizard)wizard);
        int rc = dialog.open();
    }
}

