/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.editor.DiagramToolBarManager;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.search.SearchPageUtil;

public class AddUnionSourceAction
extends TransformationAction {
    private static final String ACTION_DESCRIPTION_1 = "Add Union Transformation Source";
    private static final String ACTION_DESCRIPTION_MANY = "Add Union Transformation Sources";
    private static final String SQL_NOT_UPDATEABLE_TITLE = UiConstants.Util.getString("TransformationUpdateError.sqlNotResolvableDialog.title", new Object[0]);
    private static final String SQL_NOT_UPDATEABLE_TEXT = UiConstants.Util.getString("TransformationUpdateError.sqlNotResolvableDialog.text", new Object[0]);
    private static final String CANNOT_ADD_PROC_WITH_PARM_TITLE = UiConstants.Util.getString("org.teiid.designer.transformation.ui.actions.AddUnionSourceAction.cannotAddProcedureWithParm.title", new Object[0]);
    private static final String CANNOT_ADD_PROC_WITH_PARM_TEXT = UiConstants.Util.getString("org.teiid.designer.transformation.ui.actions.AddUnionSourceAction.cannotAddProcedureWithParm.text", new Object[0]);
    private ActionContributionItem thisToolItem;
    private DiagramToolBarManager toolBarManager;
    private ISelection oldSelection;
    private ISelection focusedSelection;

    public AddUnionSourceAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_add_union_to_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        ISelection selection = theSelection;
        if (this.wasToolBarItemSelected()) {
            if (!(thePart instanceof ModelEditor)) {
                selection = this.focusedSelection;
            }
        } else if (thePart instanceof ISearchResultViewPart) {
            List searchResults = SearchPageUtil.getEObjectsFromSearchSelection((ISelection)theSelection);
            if (searchResults != null) {
                selection = searchResults.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection(searchResults);
            }
            this.focusedSelection = selection;
        } else {
            this.focusedSelection = theSelection;
        }
        super.selectionChanged(thePart, selection);
        this.setEnabled(this.shouldEnable());
    }

    @Override
    protected void doRun() {
        if (!this.canProceed()) {
            MessageDialog.openWarning(null, (String)CANNOT_ADD_PROC_WITH_PARM_TITLE, (String)CANNOT_ADD_PROC_WITH_PARM_TEXT);
            return;
        }
        boolean isSingle = SelectionUtilities.isSingleSelection((ISelection)this.focusedSelection);
        boolean requiredStart = false;
        boolean canUndo = false;
        boolean succeeded = false;
        try {
            requiredStart = isSingle ? ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION_1, (Object)((Object)this)) : ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION_MANY, (Object)((Object)this));
            boolean dialogAns = true;
            if (!TransformationSqlHelper.canAddGroupToSelectSql((EObject)this.getTransformation())) {
                dialogAns = MessageDialog.openConfirm(null, (String)SQL_NOT_UPDATEABLE_TITLE, (String)SQL_NOT_UPDATEABLE_TEXT);
            }
            if (dialogAns) {
                if (SelectionUtilities.isSingleSelection((ISelection)this.focusedSelection)) {
                    TransformationSourceManager.addUnionSource(this.getTransformation(), SelectionUtilities.getSelectedEObject((ISelection)this.focusedSelection), this.useUnionAll());
                } else {
                    TransformationSourceManager.addUnionSources(this.getTransformation(), SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection), this.useUnionAll());
                }
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        if (this.toolBarManager != null) {
            this.toolBarManager.resetFocusedToolItem();
        }
        this.setFocusedSelection();
    }

    private boolean useUnionAll() {
        boolean unionAll = true;
        EObject transMappingRoot = this.getTransformation();
        if (TransformationHelper.isParsableSetQuery((Object)transMappingRoot)) {
            ISetQuery setQuery = (ISetQuery)TransformationHelper.getCommand((Object)transMappingRoot, (int)0);
            return setQuery.isAll();
        }
        return unionAll;
    }

    private boolean canProceed() {
        boolean bResult = true;
        return bResult;
    }

    private boolean shouldEnable() {
        boolean enable = false;
        if (!(this.isDependencyDiagram() || this.focusedSelection == null || this.focusedSelection.isEmpty() || this.getTransformation() == null || this.editorOpenWithPendingChanges())) {
            List eObjList;
            if (SelectionUtilities.isSingleSelection((ISelection)this.focusedSelection)) {
                EObject singleEObj = SelectionUtilities.getSelectedEObject((ISelection)this.focusedSelection);
                if (singleEObj != null) {
                    enable = TransformationSourceManager.canAddUnionSource(this.getTransformation(), singleEObj, (Object)this.getPart());
                }
            } else if (SelectionUtilities.isMultiSelection((ISelection)this.focusedSelection) && SelectionUtilities.isAllEObjects((ISelection)this.focusedSelection) && !(eObjList = SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection)).isEmpty()) {
                enable = TransformationSourceManager.canAddUnionSource(this.getTransformation(), eObjList, (Object)this.getPart());
            }
        }
        return enable;
    }

    private boolean editorOpenWithPendingChanges() {
        boolean openWithPending = false;
        TransformationObjectEditorPage toep = this.getTransObjectEditorPage();
        if (toep != null && toep.hasPendingChanges()) {
            openWithPending = true;
        }
        return openWithPending;
    }

    private TransformationObjectEditorPage getTransObjectEditorPage() {
        ModelObjectEditorPage moep;
        TransformationObjectEditorPage transOEP = null;
        IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
            transOEP = (TransformationObjectEditorPage)moep;
        }
        return transOEP;
    }

    private boolean wasToolBarItemSelected() {
        return this.toolBarManager != null && this.toolBarManager.getFocusedToolItem() != null && this.thisToolItem != null && this.thisToolItem.equals((Object)this.toolBarManager.getFocusedToolItem());
    }

    public void setItem(ActionContributionItem aci) {
        if (this.toolBarManager != null) {
            this.thisToolItem = aci;
        }
    }

    private void setFocusedSelection() {
        this.focusedSelection = this.wasToolBarItemSelected() ? this.oldSelection : this.getSelection();
        this.setEnabled(this.shouldEnable());
    }

    public void setToolBarManager(DiagramToolBarManager tbManager) {
        this.toolBarManager = tbManager;
    }
}

