/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.internal.datatypes.impl.DimensionImpl;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.AlgorithmsFactory;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.PlatformGraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.algorithms.styles.RenderingStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyle;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyleRegion;
import org.eclipse.graphiti.mm.algorithms.styles.UnderlineStyle;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class GaServiceImpl
implements IGaService {
    private static final IDimension calculatePolylineMinSize(Polyline polyline) {
        EList points = polyline.getPoints();
        int minX = points.isEmpty() ? 0 : ((Point)points.toArray()[0]).getX();
        int minY = points.isEmpty() ? 0 : ((Point)points.toArray()[0]).getY();
        int maxX = minX;
        int maxY = minY;
        for (Point point : points) {
            int x = point.getX();
            int y = point.getY();
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
        }
        return new DimensionImpl(Math.abs(maxX - minX) + 1, Math.abs(maxY - minY) + 1);
    }

    private static final int fitColorInt(int c) {
        c = Math.max(0, c);
        c = Math.min(255, c);
        return c;
    }

    private static final Integer getAngle(Style style) {
        Integer angle = style.getAngle();
        if (angle == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getAngle(parentStyle);
            }
            return null;
        }
        return angle;
    }

    private static final Double getRotation(Style style) {
        Double rotation = style.getRotation();
        if (rotation == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getRotation(parentStyle);
            }
            return null;
        }
        return rotation;
    }

    private static final Color getBackgroundColor(Style style) {
        Color bg = style.getBackground();
        if (bg == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getBackgroundColor(parentStyle);
            }
            return null;
        }
        return bg;
    }

    private static final Font getFont(Style style) {
        Font font = style.getFont();
        if (font == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getFont(parentStyle);
            }
            return null;
        }
        return font;
    }

    private static final Color getForegroundColor(Style style) {
        Color fg = style.getForeground();
        if (fg == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getForegroundColor(parentStyle);
            }
            return null;
        }
        return fg;
    }

    private static final Orientation getHorizontalAlignment(Style style) {
        Orientation ha = style.getHorizontalAlignment();
        if (ha == Orientation.UNSPECIFIED) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getHorizontalAlignment(parentStyle);
            }
            return null;
        }
        return ha;
    }

    private static final LineStyle getLineStyle(Style style) {
        LineStyle ls = style.getLineStyle();
        if (ls == LineStyle.UNSPECIFIED) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getLineStyle(parentStyle);
            }
            return null;
        }
        return ls;
    }

    private static final Integer getLineWidth(Style style) {
        Integer lw = style.getLineWidth();
        if (lw == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getLineWidth(parentStyle);
            }
            return null;
        }
        return lw;
    }

    private static final RenderingStyle getRenderingStyle(Style style) {
        RenderingStyle rs = style.getRenderingStyle();
        if (rs == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getRenderingStyle(parentStyle);
            }
            return null;
        }
        return rs;
    }

    private static final Double getTransparency(Style style) {
        Double trans = style.getTransparency();
        if (trans == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getTransparency(parentStyle);
            }
            return null;
        }
        return trans;
    }

    private static final Orientation getVerticalAlignment(Style style) {
        Orientation va = style.getVerticalAlignment();
        if (va == Orientation.UNSPECIFIED) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.getVerticalAlignment(parentStyle);
            }
            return null;
        }
        return va;
    }

    private static final Boolean isFilled(Style style) {
        Boolean filled = style.getFilled();
        if (filled == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.isFilled(parentStyle);
            }
            return null;
        }
        return filled;
    }

    private static final Boolean isLineVisible(Style style) {
        Boolean lv = style.getLineVisible();
        if (lv == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.isLineVisible(parentStyle);
            }
            return null;
        }
        return lv;
    }

    private static final Boolean isProportional(Style style) {
        Boolean prop = style.getProportional();
        if (prop == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.isProportional(parentStyle);
            }
            return null;
        }
        return prop;
    }

    private static final Boolean isStretchH(Style style) {
        Boolean sh = style.getStretchH();
        if (sh == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.isStretchH(parentStyle);
            }
            return null;
        }
        return sh;
    }

    private static final Boolean isStretchV(Style style) {
        Boolean sv = style.getStretchV();
        if (sv == null) {
            StyleContainer styleContainer = style.getStyleContainer();
            if (styleContainer instanceof Style) {
                Style parentStyle = (Style)styleContainer;
                return GaServiceImpl.isStretchV(parentStyle);
            }
            return null;
        }
        return sv;
    }

    private static final void setContainer(GraphicsAlgorithm ga, GraphicsAlgorithmContainer gaContainer) {
        if (gaContainer instanceof PictogramElement) {
            PictogramElement pe = (PictogramElement)gaContainer;
            pe.setGraphicsAlgorithm(ga);
        } else if (gaContainer instanceof GraphicsAlgorithm) {
            GraphicsAlgorithm parentGa = (GraphicsAlgorithm)gaContainer;
            parentGa.getGraphicsAlgorithmChildren().add((Object)ga);
        }
    }

    @Override
    public final IDimension calculateSize(GraphicsAlgorithm ga) {
        IDimension ret = null;
        if (ga instanceof Polyline) {
            Polyline pl = (Polyline)ga;
            ret = GaServiceImpl.calculatePolylineMinSize(pl);
        } else {
            ret = new DimensionImpl(ga.getWidth(), ga.getHeight());
        }
        return ret;
    }

    @Override
    public final IDimension calculateSize(GraphicsAlgorithm ga, boolean considerLineWidth) {
        int lineWidth;
        IDimension ret = this.calculateSize(ga);
        if (considerLineWidth && (lineWidth = this.getLineWidth(ga, true)) > 1) {
            int extent = lineWidth - 1;
            ret.setWidth(ret.getWidth() + extent);
            ret.setHeight(ret.getHeight() + extent);
        }
        return ret;
    }

    @Override
    public final MultiText createDefaultMultiText(Diagram diagram, GraphicsAlgorithmContainer gaContainer) {
        return this.createDefaultMultiText(diagram, gaContainer, "");
    }

    @Override
    public final MultiText createDefaultMultiText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, String value) {
        return (MultiText)this.createText(diagram, gaContainer, true, value, true);
    }

    @Override
    public final Text createDefaultText(Diagram diagram, GraphicsAlgorithmContainer gaContainer) {
        return this.createDefaultText(diagram, gaContainer, "");
    }

    @Override
    public final Text createDefaultText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, String value) {
        return (Text)this.createText(diagram, gaContainer, false, value, true);
    }

    @Override
    public final Ellipse createEllipse(GraphicsAlgorithmContainer gaContainer) {
        Ellipse ret = AlgorithmsFactory.eINSTANCE.createEllipse();
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)ret);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Ellipse createPlainEllipse(GraphicsAlgorithmContainer gaContainer) {
        Ellipse ret = AlgorithmsFactory.eINSTANCE.createEllipse();
        this.resetAll((AbstractStyle)ret);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Image createImage(GraphicsAlgorithmContainer gaContainer, String imageId) {
        Image ret = AlgorithmsFactory.eINSTANCE.createImage();
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)ret);
        ret.setId(imageId);
        ret.setProportional(Boolean.valueOf(false));
        ret.setStretchH(Boolean.valueOf(false));
        ret.setStretchV(Boolean.valueOf(false));
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Image createPlainImage(GraphicsAlgorithmContainer gaContainer, String imageId) {
        Image ret = AlgorithmsFactory.eINSTANCE.createImage();
        this.resetAll((AbstractStyle)ret);
        ret.setId(imageId);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Rectangle createInvisibleRectangle(PictogramElement pe) {
        Rectangle ret = this.createRectangle((GraphicsAlgorithmContainer)pe);
        if (GFPreferences.getInstance().areInvisibleRectanglesShown()) {
            IPeService peService = Graphiti.getPeService();
            Color bg = this.manageColor(peService.getDiagramForPictogramElement(pe), IColorConstant.LIGHT_GRAY);
            ret.setBackground(bg);
            Color fg = this.manageColor(peService.getDiagramForPictogramElement(pe), IColorConstant.YELLOW);
            ret.setForeground(fg);
            ret.setLineWidth(Integer.valueOf(2));
            ret.setTransparency(Double.valueOf(0.75));
        } else {
            ret.setFilled(Boolean.valueOf(false));
            ret.setLineVisible(Boolean.valueOf(false));
        }
        return ret;
    }

    @Override
    public final MultiText createMultiText(GraphicsAlgorithmContainer gaContainer) {
        return this.createMultiText(gaContainer, "");
    }

    @Override
    public final MultiText createPlainMultiText(GraphicsAlgorithmContainer gaContainer) {
        return this.createPlainMultiText(gaContainer, "");
    }

    @Override
    public final MultiText createMultiText(GraphicsAlgorithmContainer gaContainer, String value) {
        return (MultiText)this.createText(null, gaContainer, true, value, false);
    }

    @Override
    public final MultiText createPlainMultiText(GraphicsAlgorithmContainer gaContainer, String value) {
        return (MultiText)this.createPlainText(null, gaContainer, true, value);
    }

    @Override
    public final MultiText createMultiText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, String value, String fontName, int fontSize) {
        return this.createMultiText(diagram, gaContainer, value, fontName, fontSize, false, false);
    }

    @Override
    public final MultiText createMultiText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, String value, String fontName, int fontSize, boolean isFontItalic, boolean isFontBold) {
        MultiText text = this.createMultiText(gaContainer, value);
        Font font = this.manageFont(diagram, fontName, fontSize, isFontItalic, isFontBold);
        text.setFont(font);
        return text;
    }

    @Override
    public final PlatformGraphicsAlgorithm createPlatformGraphicsAlgorithm(GraphicsAlgorithmContainer gaContainer, String id) {
        PlatformGraphicsAlgorithm ret = AlgorithmsFactory.eINSTANCE.createPlatformGraphicsAlgorithm();
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)ret);
        ret.setId(id);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final PlatformGraphicsAlgorithm createPlainPlatformGraphicsAlgorithm(GraphicsAlgorithmContainer gaContainer, String id) {
        PlatformGraphicsAlgorithm ret = AlgorithmsFactory.eINSTANCE.createPlatformGraphicsAlgorithm();
        this.resetAll((AbstractStyle)ret);
        ret.setId(id);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Point createPoint(int x, int y) {
        return this.createPoint(x, y, 0, 0);
    }

    @Override
    public final Point createPoint(int x, int y, int before, int after) {
        Point ret = StylesFactory.eINSTANCE.createPoint();
        ret.setX(x);
        ret.setY(y);
        ret.setBefore(before);
        ret.setAfter(after);
        return ret;
    }

    @Override
    public final List<Point> createPointList(int[] xy) {
        assert (xy != null && xy.length % 2 == 0);
        ArrayList<Point> points = new ArrayList<Point>(xy.length / 2);
        int i = 0;
        while (i < xy.length) {
            points.add(this.createPoint(xy[i], xy[i + 1]));
            i += 2;
        }
        return points;
    }

    @Override
    public final List<Point> createPointList(int[] xy, int[] beforeAfter) {
        assert (xy != null && xy.length % 2 == 0);
        assert (beforeAfter != null && beforeAfter.length == xy.length);
        ArrayList<Point> points = new ArrayList<Point>(xy.length / 2);
        int i = 0;
        while (i < xy.length) {
            points.add(this.createPoint(xy[i], xy[i + 1], beforeAfter[i], beforeAfter[i + 1]));
            i += 2;
        }
        return points;
    }

    @Override
    public final Polygon createPolygon(GraphicsAlgorithmContainer gaContainer) {
        Polygon ret = AlgorithmsFactory.eINSTANCE.createPolygon();
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)ret);
        ret.setFilled(Boolean.valueOf(true));
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Polygon createPlainPolygon(GraphicsAlgorithmContainer gaContainer) {
        Polygon ret = AlgorithmsFactory.eINSTANCE.createPolygon();
        this.resetAll((AbstractStyle)ret);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Polygon createPolygon(GraphicsAlgorithmContainer gaContainer, Collection<Point> points) {
        Polygon ret = this.createPolygon(gaContainer);
        ret.getPoints().addAll(points);
        return ret;
    }

    @Override
    public final Polygon createPlainPolygon(GraphicsAlgorithmContainer gaContainer, Collection<Point> points) {
        Polygon ret = this.createPlainPolygon(gaContainer);
        ret.getPoints().addAll(points);
        return ret;
    }

    @Override
    public final Polygon createPolygon(GraphicsAlgorithmContainer gaContainer, int[] xy) {
        List<Point> points = this.createPointList(xy);
        Polygon ret = this.createPolygon(gaContainer, points);
        return ret;
    }

    @Override
    public final Polygon createPlainPolygon(GraphicsAlgorithmContainer gaContainer, int[] xy) {
        List<Point> points = this.createPointList(xy);
        Polygon ret = this.createPlainPolygon(gaContainer, points);
        return ret;
    }

    @Override
    public final Polygon createPolygon(GraphicsAlgorithmContainer gaContainer, int[] xy, int[] beforeAfter) {
        List<Point> points = this.createPointList(xy, beforeAfter);
        Polygon ret = this.createPolygon(gaContainer, points);
        return ret;
    }

    @Override
    public final Polygon createPlainPolygon(GraphicsAlgorithmContainer gaContainer, int[] xy, int[] beforeAfter) {
        List<Point> points = this.createPointList(xy, beforeAfter);
        Polygon ret = this.createPlainPolygon(gaContainer, points);
        return ret;
    }

    @Override
    public final Polyline createPolyline(GraphicsAlgorithmContainer gaContainer) {
        Polyline ret = AlgorithmsFactory.eINSTANCE.createPolyline();
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)ret);
        ret.setFilled(Boolean.valueOf(false));
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Polyline createPlainPolyline(GraphicsAlgorithmContainer gaContainer) {
        Polyline ret = AlgorithmsFactory.eINSTANCE.createPolyline();
        this.resetAll((AbstractStyle)ret);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Polyline createPolyline(GraphicsAlgorithmContainer gaContainer, Collection<Point> points) {
        Polyline ret = this.createPolyline(gaContainer);
        ret.getPoints().addAll(points);
        return ret;
    }

    @Override
    public final Polyline createPlainPolyline(GraphicsAlgorithmContainer gaContainer, Collection<Point> points) {
        Polyline ret = this.createPlainPolyline(gaContainer);
        ret.getPoints().addAll(points);
        return ret;
    }

    @Override
    public final Polyline createPolyline(GraphicsAlgorithmContainer gaContainer, int[] xy) {
        List<Point> points = this.createPointList(xy);
        Polyline ret = this.createPolyline(gaContainer, points);
        return ret;
    }

    @Override
    public final Polyline createPlainPolyline(GraphicsAlgorithmContainer gaContainer, int[] xy) {
        List<Point> points = this.createPointList(xy);
        Polyline ret = this.createPlainPolyline(gaContainer, points);
        return ret;
    }

    @Override
    public final Polyline createPolyline(GraphicsAlgorithmContainer gaContainer, int[] xy, int[] beforeAfter) {
        List<Point> points = this.createPointList(xy, beforeAfter);
        Polyline ret = this.createPolyline(gaContainer, points);
        return ret;
    }

    @Override
    public final Polyline createPlainPolyline(GraphicsAlgorithmContainer gaContainer, int[] xy, int[] beforeAfter) {
        List<Point> points = this.createPointList(xy, beforeAfter);
        Polyline ret = this.createPlainPolyline(gaContainer, points);
        return ret;
    }

    @Override
    public final Rectangle createRectangle(GraphicsAlgorithmContainer gaContainer) {
        Rectangle ret = AlgorithmsFactory.eINSTANCE.createRectangle();
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)ret);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Rectangle createPlainRectangle(GraphicsAlgorithmContainer gaContainer) {
        Rectangle ret = AlgorithmsFactory.eINSTANCE.createRectangle();
        this.resetAll((AbstractStyle)ret);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final RoundedRectangle createRoundedRectangle(GraphicsAlgorithmContainer gaContainer, int cornerWidth, int cornerHeight) {
        RoundedRectangle ret = AlgorithmsFactory.eINSTANCE.createRoundedRectangle();
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)ret);
        ret.setCornerWidth(cornerWidth);
        ret.setCornerHeight(cornerHeight);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final RoundedRectangle createPlainRoundedRectangle(GraphicsAlgorithmContainer gaContainer, int cornerWidth, int cornerHeight) {
        RoundedRectangle ret = AlgorithmsFactory.eINSTANCE.createRoundedRectangle();
        this.resetAll((AbstractStyle)ret);
        ret.setCornerWidth(cornerWidth);
        ret.setCornerHeight(cornerHeight);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Color createShiftedColor(Color color, int shift, Diagram diagram) {
        if (color == null) {
            throw new IllegalArgumentException("color must not be null");
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        red = GaServiceImpl.fitColorInt(red + shift);
        green = GaServiceImpl.fitColorInt(green + shift);
        blue = GaServiceImpl.fitColorInt(blue + shift);
        Color ret = this.manageColor(diagram, red, green, blue);
        return ret;
    }

    @Override
    public final IColorConstant createShiftedColor(IColorConstant colorConstant, int shift) {
        int red = colorConstant.getRed();
        int green = colorConstant.getGreen();
        int blue = colorConstant.getBlue();
        red = GaServiceImpl.fitColorInt(red + shift);
        green = GaServiceImpl.fitColorInt(green + shift);
        blue = GaServiceImpl.fitColorInt(blue + shift);
        ColorConstant ret = new ColorConstant(red, green, blue);
        return ret;
    }

    @Override
    public final Style createStyle(StyleContainer styleContainer, String id) {
        Style ret = StylesFactory.eINSTANCE.createStyle();
        ret.setId(id);
        ret.setStyleContainer(styleContainer);
        return ret;
    }

    @Override
    public final Style createPlainStyle(StyleContainer styleContainer, String id) {
        Style ret = StylesFactory.eINSTANCE.createStyle();
        this.resetAll((AbstractStyle)ret);
        ret.setId(id);
        ret.setStyleContainer(styleContainer);
        return ret;
    }

    @Override
    public final Text createText(GraphicsAlgorithmContainer gaContainer) {
        return this.createText(gaContainer, "");
    }

    @Override
    public final Text createPlainText(GraphicsAlgorithmContainer gaContainer) {
        return this.createPlainText(gaContainer, "");
    }

    private final AbstractText createText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, boolean multiText, String value, boolean createFont) {
        MultiText ret = multiText ? AlgorithmsFactory.eINSTANCE.createMultiText() : AlgorithmsFactory.eINSTANCE.createText();
        this.setDefaultTextAttributes(diagram, (AbstractText)ret, createFont);
        ret.setValue(value);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    private final AbstractText createPlainText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, boolean multiText, String value) {
        MultiText ret = multiText ? AlgorithmsFactory.eINSTANCE.createMultiText() : AlgorithmsFactory.eINSTANCE.createText();
        this.resetAll((AbstractStyle)ret);
        ret.setValue(value);
        GaServiceImpl.setContainer((GraphicsAlgorithm)ret, gaContainer);
        return ret;
    }

    @Override
    public final Text createText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, String value, String fontName, int fontSize) {
        return this.createText(diagram, gaContainer, value, fontName, fontSize, false, false);
    }

    @Override
    public final Text createText(Diagram diagram, GraphicsAlgorithmContainer gaContainer, String value, String fontName, int fontSize, boolean isFontItalic, boolean isFontBold) {
        Text text = this.createText(gaContainer, value);
        Font font = this.manageFont(diagram, fontName, fontSize, isFontItalic, isFontBold);
        text.setFont(font);
        return text;
    }

    @Override
    public final Text createText(GraphicsAlgorithmContainer gaContainer, String value) {
        return (Text)this.createText(null, gaContainer, false, value, false);
    }

    @Override
    public final Text createPlainText(GraphicsAlgorithmContainer gaContainer, String value) {
        return (Text)this.createPlainText(null, gaContainer, false, value);
    }

    @Override
    public TextStyleRegion createTextStyleRegion(AbstractText abstractText) {
        TextStyleRegion textStyleRegion = StylesFactory.eINSTANCE.createTextStyleRegion();
        abstractText.getStyleRegions().add((Object)textStyleRegion);
        return textStyleRegion;
    }

    @Override
    public TextStyleRegion createTextStyleRegion(AbstractText abstractText, int start, int end) {
        TextStyleRegion textStyleRegion = this.createTextStyleRegion(abstractText);
        textStyleRegion.setStart(start);
        textStyleRegion.setEnd(end);
        return textStyleRegion;
    }

    @Override
    public TextStyle createTextStyle(TextStyleRegion region) {
        TextStyle textStyle = StylesFactory.eINSTANCE.createTextStyle();
        region.setStyle(textStyle);
        return textStyle;
    }

    @Override
    public TextStyle createTextStyle(TextStyleRegion region, boolean underline, boolean strikeout, UnderlineStyle underlineStyle) {
        TextStyle textStyle = this.createTextStyle(region);
        textStyle.setStrikeout(strikeout);
        textStyle.setUnderline(underline);
        textStyle.setUnderlineStyle(underlineStyle);
        return textStyle;
    }

    public final void deleteFont(AbstractText abstractText) {
        Font oldFont = abstractText.getFont();
        this.deleteEObject((EObject)oldFont);
    }

    @Override
    public final void deleteFont(Font font) {
        this.deleteEObject((EObject)font);
    }

    @Override
    public final void deleteColor(Color color) {
        this.deleteEObject((EObject)color);
    }

    private final void deleteEObject(EObject eo) {
        if (eo != null) {
            EcoreUtil.delete((EObject)eo, (boolean)true);
        }
    }

    @Override
    public final void deleteRenderingStyle(AbstractStyle abstractStyle) {
        this.deleteEObject((EObject)abstractStyle.getRenderingStyle());
    }

    @Override
    public final Style findStyle(StyleContainer styleContainer, String id) {
        EList styles = styleContainer.getStyles();
        for (Style childStyle : styles) {
            if (id.equals(childStyle.getId())) {
                return childStyle;
            }
            Style findStyle = this.findStyle((StyleContainer)childStyle, id);
            if (findStyle == null) continue;
            return findStyle;
        }
        return null;
    }

    @Override
    public final int getAngle(AbstractText at, boolean checkStyles) {
        Integer angle = at.getAngle();
        if (angle == null) {
            Integer styleValue;
            Style style;
            if (checkStyles && (style = at.getStyle()) != null && (styleValue = GaServiceImpl.getAngle(style)) != null) {
                return styleValue;
            }
        } else {
            return angle;
        }
        return 0;
    }

    @Override
    public final double getRotation(AbstractText at, boolean checkStyles) {
        Double angle = at.getRotation();
        if (angle == null) {
            Double styleValue;
            Style style;
            if (checkStyles && (style = at.getStyle()) != null && (styleValue = GaServiceImpl.getRotation(style)) != null) {
                return styleValue;
            }
        } else {
            return angle;
        }
        return 0.0;
    }

    @Override
    public final Color getBackgroundColor(GraphicsAlgorithm ga, boolean checkStyles) {
        Color bc = ga.getBackground();
        if (bc == null) {
            Color styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.getBackgroundColor(style)) != null) {
                return styleValue;
            }
        } else {
            return bc;
        }
        return null;
    }

    @Override
    public final Font getFont(AbstractText at, boolean checkStyles) {
        Font font = at.getFont();
        if (font == null) {
            Font styleValue;
            Style style;
            if (checkStyles && (style = at.getStyle()) != null && (styleValue = GaServiceImpl.getFont(style)) != null) {
                return styleValue;
            }
        } else {
            return font;
        }
        return null;
    }

    @Override
    public final Color getForegroundColor(GraphicsAlgorithm ga, boolean checkStyles) {
        Color fc = ga.getForeground();
        if (fc == null) {
            Color styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.getForegroundColor(style)) != null) {
                return styleValue;
            }
        } else {
            return fc;
        }
        return null;
    }

    @Override
    public final Orientation getHorizontalAlignment(AbstractText at, boolean checkStyles) {
        Orientation ha = at.getHorizontalAlignment();
        if (ha == Orientation.UNSPECIFIED) {
            Orientation styleValue;
            Style style;
            if (checkStyles && (style = at.getStyle()) != null && (styleValue = GaServiceImpl.getHorizontalAlignment(style)) != null) {
                return styleValue;
            }
        } else {
            return ha;
        }
        return Orientation.ALIGNMENT_LEFT;
    }

    @Override
    public final LineStyle getLineStyle(GraphicsAlgorithm ga, boolean checkStyles) {
        LineStyle ls = ga.getLineStyle();
        if (ls == LineStyle.UNSPECIFIED) {
            LineStyle styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.getLineStyle(style)) != null) {
                return styleValue;
            }
        } else {
            return ls;
        }
        return LineStyle.SOLID;
    }

    @Override
    public final int getLineWidth(GraphicsAlgorithm ga, boolean checkStyles) {
        Integer lw = ga.getLineWidth();
        if (lw == null) {
            Integer styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.getLineWidth(style)) != null) {
                return styleValue;
            }
        } else {
            return lw;
        }
        return 1;
    }

    @Override
    public final RenderingStyle getRenderingStyle(GraphicsAlgorithm ga, boolean checkStyles) {
        RenderingStyle rs = ga.getRenderingStyle();
        if (rs == null) {
            RenderingStyle styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.getRenderingStyle(style)) != null) {
                return styleValue;
            }
        } else {
            return rs;
        }
        return null;
    }

    @Override
    public final double getTransparency(GraphicsAlgorithm ga, boolean checkStyles) {
        Double transparency = ga.getTransparency();
        if (transparency == null) {
            Double styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.getTransparency(style)) != null) {
                return styleValue;
            }
        } else {
            return transparency;
        }
        return 0.0;
    }

    @Override
    public final Orientation getVerticalAlignment(AbstractText at, boolean checkStyles) {
        Orientation va = at.getVerticalAlignment();
        if (va == Orientation.UNSPECIFIED) {
            Orientation styleValue;
            Style style;
            if (checkStyles && (style = at.getStyle()) != null && (styleValue = GaServiceImpl.getVerticalAlignment(style)) != null) {
                return styleValue;
            }
        } else {
            return va;
        }
        return Orientation.ALIGNMENT_CENTER;
    }

    @Override
    public final void resetAll(AbstractStyle abstractStyle) {
        abstractStyle.setBackground(null);
        abstractStyle.unsetFilled();
        abstractStyle.setForeground(null);
        abstractStyle.setLineStyle(LineStyle.UNSPECIFIED);
        abstractStyle.unsetLineVisible();
        abstractStyle.setLineWidth(null);
        this.deleteRenderingStyle(abstractStyle);
        abstractStyle.setTransparency(null);
        if (abstractStyle instanceof AbstractText) {
            AbstractText text = (AbstractText)abstractStyle;
            text.setRotation(null);
            text.setFont(null);
            text.setHorizontalAlignment(Orientation.UNSPECIFIED);
            text.setVerticalAlignment(Orientation.UNSPECIFIED);
        } else if (abstractStyle instanceof Image) {
            Image image = (Image)abstractStyle;
            image.setProportional(null);
            image.setStretchH(null);
            image.setStretchV(null);
        } else if (abstractStyle instanceof Style) {
            Style style = (Style)abstractStyle;
            style.setRotation(null);
            style.setFont(null);
            style.setHorizontalAlignment(Orientation.UNSPECIFIED);
            style.setVerticalAlignment(Orientation.UNSPECIFIED);
            style.setProportional(null);
            style.setStretchH(null);
            style.setStretchV(null);
        }
    }

    @Override
    public final boolean isFilled(GraphicsAlgorithm ga, boolean checkStyles) {
        if (!ga.isSetFilled()) {
            Boolean styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.isFilled(style)) != null) {
                return styleValue;
            }
        } else {
            return ga.getFilled();
        }
        return true;
    }

    @Override
    public final boolean isLineVisible(GraphicsAlgorithm ga, boolean checkStyles) {
        if (!ga.isSetLineVisible()) {
            Boolean styleValue;
            Style style;
            if (checkStyles && (style = ga.getStyle()) != null && (styleValue = GaServiceImpl.isLineVisible(style)) != null) {
                return styleValue;
            }
        } else {
            return ga.getLineVisible();
        }
        return true;
    }

    @Override
    public final boolean isProportional(Image image, boolean checkStyles) {
        Boolean prop = image.getProportional();
        if (prop == null) {
            Boolean styleValue;
            Style style;
            if (checkStyles && (style = image.getStyle()) != null && (styleValue = GaServiceImpl.isProportional(style)) != null) {
                return styleValue;
            }
        } else {
            return prop;
        }
        return false;
    }

    @Override
    public final boolean isStretchH(Image image, boolean checkStyles) {
        Boolean sh = image.getStretchH();
        if (sh == null) {
            Boolean styleValue;
            Style style;
            if (checkStyles && (style = image.getStyle()) != null && (styleValue = GaServiceImpl.isStretchH(style)) != null) {
                return styleValue;
            }
        } else {
            return sh;
        }
        return false;
    }

    @Override
    public final boolean isStretchV(Image image, boolean checkStyles) {
        Boolean sv = image.getStretchV();
        if (sv == null) {
            Boolean styleValue;
            Style style;
            if (checkStyles && (style = image.getStyle()) != null && (styleValue = GaServiceImpl.isStretchV(style)) != null) {
                return styleValue;
            }
        } else {
            return sv;
        }
        return false;
    }

    @Override
    public final Color manageColor(Diagram diagram, IColorConstant colorConstant) {
        return this.manageColor(diagram, colorConstant.getRed(), colorConstant.getGreen(), colorConstant.getBlue());
    }

    @Override
    public final Color manageColor(Diagram diagram, int red, int green, int blue) {
        EList colors = diagram.getColors();
        for (Color existingColor : colors) {
            if (existingColor.getRed() != red || existingColor.getGreen() != green || existingColor.getBlue() != blue) continue;
            return existingColor;
        }
        Color newColor = StylesFactory.eINSTANCE.createColor();
        newColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Red(), (Object)red);
        newColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Green(), (Object)green);
        newColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Blue(), (Object)blue);
        colors.add(newColor);
        return newColor;
    }

    @Override
    public final Font manageDefaultFont(Diagram diagram) {
        return this.manageDefaultFont(diagram, false, false);
    }

    @Override
    public final Font manageDefaultFont(Diagram diagram, boolean isItalic, boolean isBold) {
        return this.manageFont(diagram, "Arial", 8, isItalic, isBold);
    }

    @Override
    public final Font manageFont(Diagram diagram, String name, int size) {
        return this.manageFont(diagram, name, size, false, false);
    }

    @Override
    public final Font manageFont(Diagram diagram, String name, int size, boolean isItalic, boolean isBold) {
        EList fonts = diagram.getFonts();
        for (Font font : fonts) {
            if (!font.getName().equals(name) || font.getSize() != size || font.isBold() != isBold || font.isItalic() != isItalic) continue;
            return font;
        }
        Font newFont = StylesFactory.eINSTANCE.createFont();
        newFont.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Name(), (Object)name);
        newFont.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Size(), (Object)size);
        newFont.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Italic(), (Object)isItalic);
        newFont.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Bold(), (Object)isBold);
        fonts.add((Object)newFont);
        return newFont;
    }

    @Override
    public final void movePolylinePoint(Polyline polyline, int index, int deltaX, int deltaY) {
        Point point = (Point)polyline.getPoints().get(index);
        int oldX = point.getX();
        int oldY = point.getY();
        polyline.getPoints().set(index, (Object)this.createPoint(oldX + deltaX, oldY + deltaY));
    }

    protected void setDefaultGraphicsAlgorithmAttributes(GraphicsAlgorithm graphicsAlgorithm) {
        this.setLocationAndSize(graphicsAlgorithm, 0, 0, 0, 0);
        graphicsAlgorithm.setLineStyle(LineStyle.SOLID);
        graphicsAlgorithm.setLineWidth(Integer.valueOf(1));
        graphicsAlgorithm.setTransparency(Double.valueOf(0.0));
    }

    protected void setDefaultTextAttributes(Diagram diagram, AbstractText abstractText, boolean createFont) {
        this.setDefaultGraphicsAlgorithmAttributes((GraphicsAlgorithm)abstractText);
        abstractText.setFilled(Boolean.valueOf(false));
        if (createFont && diagram != null) {
            Font font = this.manageFont(diagram, "Arial", 8);
            abstractText.setFont(font);
        }
    }

    @Override
    public final void setHeight(GraphicsAlgorithm ga, int height) {
        ga.setHeight(height);
    }

    @Override
    public final void setLocationAndSize(GraphicsAlgorithm ga, int x, int y, int width, int height) {
        this.setLocationAndSize(ga, x, y, width, height, false);
    }

    @Override
    public final void setLocationAndSize(GraphicsAlgorithm ga, int x, int y, int width, int height, boolean avoidNegativeCoordinates) {
        this.setLocation(ga, x, y, avoidNegativeCoordinates);
        this.setSize(ga, width, height);
    }

    @Override
    public final void setLocation(GraphicsAlgorithm ga, int x, int y) {
        this.setLocation(ga, x, y, false);
    }

    @Override
    public final void setLocation(GraphicsAlgorithm ga, int x, int y, boolean avoidNegativeCoordinates) {
        int oldY;
        int oldX;
        if (ga == null) {
            return;
        }
        if (avoidNegativeCoordinates) {
            x = Math.max(x, 0);
            y = Math.max(y, 0);
        }
        if ((oldX = ga.getX()) != x) {
            ga.setX(x);
        }
        if ((oldY = ga.getY()) != y) {
            ga.setY(y);
        }
    }

    @Override
    public final void setSize(GraphicsAlgorithm ga, int width, int height) {
        this.setWidth(ga, width);
        this.setHeight(ga, height);
    }

    @Override
    public final void setWidth(GraphicsAlgorithm ga, int width) {
        ga.setWidth(width);
    }

    @Override
    public final void setRenderingStyle(AbstractStyle abstractStyle, AdaptedGradientColoredAreas adaptedGradientColoredAreas) {
        RenderingStyle renderingStyle;
        if (adaptedGradientColoredAreas != null && adaptedGradientColoredAreas.getAdaptedGradientColoredAreas() != null && !adaptedGradientColoredAreas.getAdaptedGradientColoredAreas().isEmpty() && adaptedGradientColoredAreas.getGradientType() != null) {
            renderingStyle = abstractStyle.getRenderingStyle();
            if (renderingStyle == null) {
                renderingStyle = StylesFactory.eINSTANCE.createRenderingStyle();
                abstractStyle.setRenderingStyle(renderingStyle);
            }
        } else {
            throw new IllegalArgumentException("Object AdaptedGradientColoredAreas or its attributes must not be null or empty");
        }
        renderingStyle.setAdaptedGradientColoredAreas(adaptedGradientColoredAreas);
    }
}

