/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.runtime.IRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public abstract class BaseRuntimeExtensionDescriptor
implements IRuntimeExtensionDescriptor {
    protected TargetRuntime targetRuntime;
    protected IFile configFile;
    protected long configFileTimestamp;
    protected final IConfigurationElement configurationElement;
    protected String id;

    public static <T extends BaseRuntimeExtensionDescriptor> T getDescriptor(EObject object, Class type) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null) {
            return (T)((BaseRuntimeExtensionDescriptor)adapter.getProperty(type.getName()));
        }
        return null;
    }

    public BaseRuntimeExtensionDescriptor() {
        this.configurationElement = null;
    }

    public BaseRuntimeExtensionDescriptor(IConfigurationElement e) {
        this.configurationElement = e;
        this.id = e.getAttribute("id");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void dispose() {
        List<IRuntimeExtensionDescriptor> list = this.targetRuntime.getRuntimeExtensionDescriptors(this.getExtensionName());
        list.remove(this);
    }

    public BaseRuntimeExtensionDescriptor(TargetRuntime rt) {
        this.targetRuntime = rt;
        this.configurationElement = rt.configurationElement;
    }

    @Override
    public IFile getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(IFile configFile) {
        this.configFile = configFile;
        this.configFileTimestamp = configFile != null ? configFile.getLocalTimeStamp() : 0L;
    }

    public long getConfigFileTimestamp() {
        return this.configFileTimestamp;
    }

    @Override
    public TargetRuntime getRuntime() {
        return this.targetRuntime;
    }

    @Override
    public void setRuntime(TargetRuntime targetRuntime) {
        this.targetRuntime = targetRuntime;
        List<IRuntimeExtensionDescriptor> list = targetRuntime.getRuntimeExtensionDescriptors(this.getExtensionName());
        list.add(this);
    }

    public EPackage getEPackage() {
        if (this.targetRuntime.getModelDescriptor() != null) {
            return this.targetRuntime.getModelDescriptor().getEPackage();
        }
        return Bpmn2Package.eINSTANCE;
    }

    public EStructuralFeature getFeature(String className, String featureName) {
        return this.getFeature(String.valueOf(className) + "." + featureName);
    }

    public EStructuralFeature getFeature(String name) {
        String[] parts = name.split("\\.");
        EClass eClass = (EClass)this.getEPackage().getEClassifier(parts[0]);
        if (eClass == null) {
            eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(parts[0]);
        }
        if (eClass != null) {
            EStructuralFeature feature = eClass.getEStructuralFeature(parts[1]);
            if (feature != null && ExtendedMetaData.INSTANCE.getFeatureKind(feature) == 0) {
                if (feature instanceof EAttribute) {
                    ExtendedMetaData.INSTANCE.setFeatureKind(feature, 2);
                } else {
                    ExtendedMetaData.INSTANCE.setFeatureKind(feature, 4);
                }
                ExtendedMetaData.INSTANCE.setNamespace(feature, eClass.getEPackage().getNsURI());
                ExtendedMetaData.INSTANCE.setName(feature, feature.getName());
            }
            return feature;
        }
        return null;
    }

    public EClassifier getClassifier(String name) {
        EClassifier eClass = this.getEPackage().getEClassifier(name);
        if (eClass == null) {
            eClass = Bpmn2Package.eINSTANCE.getEClassifier(name);
        }
        return eClass;
    }
}

