/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractAddPictogramElementFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AbstractBpmn2AddFeature<T extends BaseElement>
extends AbstractAddPictogramElementFeature {
    protected static final IGaService gaService = Graphiti.getGaService();
    protected static final IPeService peService = Graphiti.getPeService();
    protected Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)this.getDiagram());

    public AbstractBpmn2AddFeature(IFeatureProvider fp) {
        super(fp);
    }

    public abstract IAddFeature getAddLabelFeature(IFeatureProvider var1);

    protected BPMNShape findDIShape(BaseElement elem) {
        try {
            return DIUtils.findBPMNShape(elem);
        }
        catch (Exception e) {
            Activator.logError(e);
            return null;
        }
    }

    protected BPMNShape createDIShape(Shape shape, BaseElement elem, boolean applyDefaults) {
        BPMNShape bpmnShape = null;
        Diagram diagram = Graphiti.getPeService().getDiagramForShape(shape);
        if (diagram != null) {
            BPMNDiagram bpmnDiagram = (BPMNDiagram)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)diagram);
            bpmnShape = DIUtils.findBPMNShape(bpmnDiagram, elem);
        } else {
            bpmnShape = this.findDIShape(elem);
        }
        bpmnShape = DIUtils.createDIShape(shape, elem, bpmnShape, this.getFeatureProvider());
        if (applyDefaults && bpmnShape != null) {
            this.preferences.applyBPMNDIDefaults(bpmnShape, null);
        }
        return bpmnShape;
    }

    protected BPMNEdge createDIEdge(Connection connection, BaseElement elem) {
        BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)connection);
        BPMNEdge edge = DIUtils.findBPMNEdge(bpmnDiagram, (EObject)elem);
        return DIUtils.createDIEdge(connection, elem, edge, this.getFeatureProvider());
    }

    protected void adjustLocation(IAddContext context, int width, int height) {
        if (DIImport.isImporting((IContext)context)) {
            return;
        }
        int x = context.getX();
        int y = context.getY();
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        ((AddContext)context).setY(y -= height / 2);
        ((AddContext)context).setX(x -= width / 2);
    }

    protected void splitConnection(IAddContext context, ContainerShape containerShape) {
        if (context.getProperty((Object)"is.importing") != null) {
            return;
        }
        T newObject = this.getBusinessObject(context);
        Connection connection = context.getTargetConnection();
        if (connection != null) {
            ReconnectionContext rc;
            FixPointAnchor anchor;
            ILayoutService layoutService = Graphiti.getLayoutService();
            Anchor a0 = connection.getStart();
            Anchor a1 = connection.getEnd();
            double x0 = layoutService.getLocationRelativeToDiagram(a0).getX();
            double y0 = layoutService.getLocationRelativeToDiagram(a0).getY();
            double x1 = layoutService.getLocationRelativeToDiagram(a1).getX();
            double y1 = layoutService.getLocationRelativeToDiagram(a1).getY();
            double dx = x0 - (double)context.getX();
            double dy = y0 - (double)context.getY();
            double len0 = Math.sqrt(dx * dx + dy * dy);
            dx = (double)context.getX() - x1;
            dy = (double)context.getY() - y1;
            double len1 = Math.sqrt(dx * dx + dy * dy);
            AnchorContainer oldSourceContainer = connection.getStart().getParent();
            AnchorContainer oldTargetContainer = connection.getEnd().getParent();
            BaseElement baseElement = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
            ILocation targetLocation = layoutService.getLocationRelativeToDiagram((Shape)containerShape);
            if (newObject instanceof StartEvent || len0 < len1 && !(newObject instanceof EndEvent)) {
                anchor = AnchorUtil.createAnchor((AnchorContainer)containerShape, GraphicsUtil.getShapeCenter(oldTargetContainer));
                rc = new ReconnectionContext(connection, connection.getStart(), (Anchor)anchor, targetLocation);
                rc.setReconnectType(ReconnectionContext.RECONNECT_SOURCE);
                rc.setTargetPictogramElement((PictogramElement)containerShape);
            } else {
                anchor = AnchorUtil.createAnchor(oldTargetContainer, GraphicsUtil.getShapeCenter((AnchorContainer)containerShape));
                rc = new ReconnectionContext(connection, connection.getEnd(), (Anchor)anchor, targetLocation);
                rc.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                rc.setTargetPictogramElement((PictogramElement)containerShape);
            }
            IReconnectionFeature rf = this.getFeatureProvider().getReconnectionFeature((IReconnectionContext)rc);
            rf.reconnect((IReconnectionContext)rc);
            if (!(newObject instanceof EndEvent) && !(newObject instanceof StartEvent)) {
                CreateConnectionContext ccc = new CreateConnectionContext();
                if (len0 < len1) {
                    ccc.setSourcePictogramElement((PictogramElement)oldSourceContainer);
                    ccc.setTargetPictogramElement((PictogramElement)containerShape);
                    anchor = AnchorUtil.createAnchor(oldSourceContainer, GraphicsUtil.getShapeCenter((AnchorContainer)containerShape));
                    ccc.setSourceAnchor((Anchor)anchor);
                    anchor = AnchorUtil.createAnchor((AnchorContainer)containerShape, GraphicsUtil.getShapeCenter(oldTargetContainer));
                    ccc.setTargetAnchor((Anchor)anchor);
                } else {
                    ccc.setSourcePictogramElement((PictogramElement)containerShape);
                    ccc.setTargetPictogramElement((PictogramElement)oldTargetContainer);
                    anchor = AnchorUtil.createAnchor((AnchorContainer)containerShape, GraphicsUtil.getShapeCenter(oldTargetContainer));
                    ccc.setSourceAnchor((Anchor)anchor);
                    anchor = AnchorUtil.createAnchor(oldTargetContainer, GraphicsUtil.getShapeCenter((AnchorContainer)containerShape));
                    ccc.setTargetAnchor((Anchor)anchor);
                }
                Connection newConnection = null;
                ICreateConnectionFeature[] iCreateConnectionFeatureArray = this.getFeatureProvider().getCreateConnectionFeatures();
                int n = iCreateConnectionFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCreateFlowFeature acf;
                    ICreateConnectionFeature cf = iCreateConnectionFeatureArray[n2];
                    if (cf instanceof AbstractCreateFlowFeature && (acf = (AbstractCreateFlowFeature)cf).getBusinessObjectClass().isInstance((Object)baseElement)) {
                        newConnection = acf.create((ICreateConnectionContext)ccc);
                        DIUtils.updateDIEdge(newConnection);
                        break;
                    }
                    ++n2;
                }
            }
            DIUtils.updateDIEdge(connection);
        }
    }

    protected int getHeight(IAddContext context) {
        Object copiedBpmnShape = context.getProperty((Object)"copied.bpmn.shape");
        if (copiedBpmnShape instanceof BPMNShape) {
            Bounds b = ((BPMNShape)copiedBpmnShape).getBounds();
            if (b != null && this.isHorizontal((ITargetContext)context)) {
                return (int)b.getWidth();
            }
            return (int)b.getHeight();
        }
        if (context.getHeight() > 0) {
            return context.getHeight();
        }
        if (context.getProperty((Object)"is.importing") == null && this.isHorizontal((ITargetContext)context)) {
            if (context.getWidth() > 0) {
                return context.getWidth();
            }
            return this.getWidth();
        }
        return this.getHeight();
    }

    protected int getWidth(IAddContext context) {
        Bounds b;
        Object copiedBpmnShape = context.getProperty((Object)"copied.bpmn.shape");
        if (copiedBpmnShape instanceof BPMNShape && (b = ((BPMNShape)copiedBpmnShape).getBounds()) != null) {
            if (this.isHorizontal((ITargetContext)context)) {
                return (int)b.getHeight();
            }
            return (int)b.getWidth();
        }
        if (context.getWidth() > 0) {
            return context.getWidth();
        }
        if (context.getProperty((Object)"is.importing") == null && this.isHorizontal((ITargetContext)context)) {
            if (context.getHeight() > 0) {
                return context.getHeight();
            }
            return this.getHeight();
        }
        return this.getWidth();
    }

    protected int getHeight() {
        ShapeStyle ss = this.preferences.getShapeStyle(this.getBusinessObjectType());
        return ss.getDefaultHeight();
    }

    protected int getWidth() {
        ShapeStyle ss = this.preferences.getShapeStyle(this.getBusinessObjectType());
        return ss.getDefaultWidth();
    }

    protected boolean isHorizontal(ITargetContext context) {
        Object newObject;
        if (context instanceof IAddContext && !((newObject = ((IAddContext)context).getNewObject()) instanceof Lane) && !(newObject instanceof Participant)) {
            return false;
        }
        if (context.getProperty((Object)"is.importing") == null) {
            Lane targetLane;
            BPMNShape laneShape;
            Object copiedBpmnShape = context.getProperty((Object)"copied.bpmn.shape");
            if (copiedBpmnShape instanceof BPMNShape) {
                return ((BPMNShape)copiedBpmnShape).isIsHorizontal();
            }
            if (FeatureSupport.isTargetParticipant(context)) {
                Participant targetParticipant = FeatureSupport.getTargetParticipant(context);
                BPMNShape participantShape = this.findDIShape((BaseElement)targetParticipant);
                if (participantShape != null) {
                    return participantShape.isIsHorizontal();
                }
            } else if (FeatureSupport.isTargetLane(context) && (laneShape = this.findDIShape((BaseElement)(targetLane = FeatureSupport.getTargetLane(context)))) != null) {
                return laneShape.isIsHorizontal();
            }
        }
        return FeatureSupport.isHorizontal((IContext)context);
    }

    public abstract Class<? extends BaseElement> getBusinessObjectType();

    public T getBusinessObject(IAddContext context) {
        Object businessObject = context.getProperty((Object)"businessObject");
        if (businessObject instanceof BaseElement) {
            return (T)((BaseElement)businessObject);
        }
        return (T)((BaseElement)context.getNewObject());
    }

    public void putBusinessObject(IAddContext context, T businessObject) {
        context.putProperty((Object)"businessObject", businessObject);
    }

    public void postExecute(IExecutionInfo executionInfo) {
    }

    protected static GraphicsAlgorithmContainer getGraphicsAlgorithm(ContainerShape containerShape) {
        if (containerShape.getGraphicsAlgorithm() instanceof RoundedRectangle) {
            return containerShape.getGraphicsAlgorithm();
        }
        if (containerShape.getChildren().size() > 0) {
            Shape shape = (Shape)containerShape.getChildren().get(0);
            return shape.getGraphicsAlgorithm();
        }
        return null;
    }

    protected void decorateConnection(IAddConnectionContext context, Connection connection, T businessObject) {
    }

    protected void decorateShape(IAddContext context, ContainerShape containerShape, T businessObject) {
        ShapeDecoratorUtil.createValidationDecorator(containerShape);
    }

    public IReason updatePictogramElement(IAddContext addContext, PictogramElement pe) {
        UpdateContext updateContext = new UpdateContext(pe);
        for (Object key : addContext.getPropertyKeys()) {
            Object value = addContext.getProperty(key);
            updateContext.putProperty(key, value);
        }
        return this.getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
    }

    public IReason layoutPictogramElement(IAddContext addContext, PictogramElement pe) {
        LayoutContext layoutContext = new LayoutContext(pe);
        for (Object key : addContext.getPropertyKeys()) {
            Object value = addContext.getProperty(key);
            layoutContext.putProperty(key, value);
        }
        return this.getFeatureProvider().layoutIfPossible((ILayoutContext)layoutContext);
    }
}

