/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.validation;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.ide.camel.editor.validation.BasicNodeValidator;
import org.fusesource.ide.camel.editor.validation.ValidationResult;
import org.fusesource.ide.camel.editor.validation.ValidationSupport;
import org.fusesource.ide.camel.model.AbstractNode;

public final class ValidationFactory {
    private static Map<Class<? extends AbstractNode>, ValidationSupport> registeredValidators = new HashMap<Class<? extends AbstractNode>, ValidationSupport>();
    private static ValidationFactory instance;

    static {
        registeredValidators.put(AbstractNode.class, new BasicNodeValidator());
    }

    private ValidationFactory() {
    }

    public static synchronized ValidationFactory getInstance() {
        if (instance == null) {
            instance = new ValidationFactory();
        }
        return instance;
    }

    public ValidationResult validate(AbstractNode node) {
        ValidationResult result = null;
        for (Class<? extends AbstractNode> c : registeredValidators.keySet()) {
            if (!c.isInstance(node)) continue;
            ValidationSupport validator = registeredValidators.get(c);
            if (validator == null) {
                validator = registeredValidators.get(AbstractNode.class);
            }
            result = validator.validate(node);
        }
        return result;
    }
}

