/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICopyFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICopyContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.fusesource.ide.camel.editor.AbstractNodes;
import org.fusesource.ide.camel.editor.CamelModelIndependenceSolver;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.features.add.AddFlowFeature;
import org.fusesource.ide.camel.editor.features.add.AddNodeFeature;
import org.fusesource.ide.camel.editor.features.create.CreateDefinedBeanFigureFeature;
import org.fusesource.ide.camel.editor.features.create.CreateDefinedEndpointFigureFeature;
import org.fusesource.ide.camel.editor.features.create.CreateFlowFeature;
import org.fusesource.ide.camel.editor.features.custom.DeleteAllEndpointBreakpointsFeature;
import org.fusesource.ide.camel.editor.features.custom.DeleteEndpointBreakpointFeature;
import org.fusesource.ide.camel.editor.features.custom.DisableCamelBreakpointFeature;
import org.fusesource.ide.camel.editor.features.custom.EditConditionalBreakpoint;
import org.fusesource.ide.camel.editor.features.custom.EnableCamelBreakpointFeature;
import org.fusesource.ide.camel.editor.features.custom.LayoutDiagramFeature;
import org.fusesource.ide.camel.editor.features.custom.SetConditionalBreakpointFeature;
import org.fusesource.ide.camel.editor.features.custom.SetEndpointBreakpointFeature;
import org.fusesource.ide.camel.editor.features.delete.DeleteNodeFeature;
import org.fusesource.ide.camel.editor.features.delete.RemoveNodeFeature;
import org.fusesource.ide.camel.editor.features.other.CopyNodeFeature;
import org.fusesource.ide.camel.editor.features.other.LayoutNodeFeature;
import org.fusesource.ide.camel.editor.features.other.MoveNodeFeature;
import org.fusesource.ide.camel.editor.features.other.PasteNodeFeature;
import org.fusesource.ide.camel.editor.features.other.ReconnectNodesFeature;
import org.fusesource.ide.camel.editor.features.other.ResizeNodeFeature;
import org.fusesource.ide.camel.editor.features.other.UpdateNodeFeature;
import org.fusesource.ide.camel.editor.provider.generated.AddNodeMenuFactory;
import org.fusesource.ide.camel.editor.provider.generated.ProviderHelper;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.Flow;
import org.fusesource.ide.camel.model.generated.Bean;
import org.fusesource.ide.commons.camel.tools.BeanDef;
import org.fusesource.ide.commons.util.Strings;

public class CamelFeatureProvider
extends DefaultFeatureProvider {
    private AddNodeMenuFactory menuFactory = new AddNodeMenuFactory();
    private CamelModelIndependenceSolver modelIndependenceSolver;

    public CamelFeatureProvider(IDiagramTypeProvider dtp) {
        super(dtp);
        if (this.modelIndependenceSolver == null) {
            this.modelIndependenceSolver = new CamelModelIndependenceSolver();
        }
        this.setIndependenceSolver(this.modelIndependenceSolver);
    }

    public IAddFeature getAddFeature(IAddContext context) {
        if (context.getNewObject() instanceof Flow) {
            return new AddFlowFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof AbstractNode) {
            return new AddNodeFeature((IFeatureProvider)this);
        }
        return super.getAddFeature(context);
    }

    public ICreateFeature[] getCreateFeatures() {
        RiderDesignEditor rider;
        ICreateFeature[] features = ProviderHelper.getCreateFeatures((IFeatureProvider)this);
        AbstractNode selectedNode = null;
        IDiagramTypeProvider dtp = this.getDiagramTypeProvider();
        IDiagramEditor diagramEditor = dtp.getDiagramEditor();
        if (diagramEditor instanceof RiderDesignEditor && (selectedNode = (rider = (RiderDesignEditor)diagramEditor).getSelectedNode()) == null) {
            selectedNode = rider.getSelectedRoute();
        }
        if (selectedNode != null) {
            ArrayList<ICreateFeature> featureList = new ArrayList<ICreateFeature>();
            featureList.addAll(Arrays.asList(features));
            Set<Endpoint> endpoints = AbstractNodes.getAllEndpoints(selectedNode);
            SortedMap<String, BeanDef> beans = AbstractNodes.getAllBeans(selectedNode);
            this.addEndpointInstances(featureList, endpoints);
            this.addBeanInstances(featureList, beans);
            return featureList.toArray(new ICreateFeature[featureList.size()]);
        }
        return features;
    }

    private void addBeanInstances(List<ICreateFeature> featureList, Map<String, BeanDef> beans) {
        ArrayList<String> processedBeans = new ArrayList<String>();
        Set<Map.Entry<String, BeanDef>> entrySet = beans.entrySet();
        for (Map.Entry<String, BeanDef> entry : entrySet) {
            String name = entry.getKey();
            String aClass = entry.getValue().getClassName();
            if (Strings.isBlank((String)name) && Strings.isBlank((String)aClass) || !entry.getValue().getBeanType().equalsIgnoreCase("bean") || processedBeans.contains(name)) continue;
            processedBeans.add(name);
            Bean bean = new Bean();
            bean.setName(name);
            bean.setRef(name);
            bean.setBeanType(aClass);
            String title = bean.getDisplayText();
            String description = "bean '" + name + "' of type " + aClass;
            featureList.add((ICreateFeature)new CreateDefinedBeanFigureFeature((IFeatureProvider)this, title, description, bean));
        }
    }

    private void addEndpointInstances(List<ICreateFeature> featureList, Set<Endpoint> endpoints) {
        ArrayList<String> processedURIs = new ArrayList<String>();
        for (Endpoint endpoint : endpoints) {
            String id = endpoint.getId();
            String url = endpoint.getUri();
            if (Strings.isBlank((String)id) && Strings.isBlank((String)url) || processedURIs.contains(url)) continue;
            processedURIs.add(url);
            String description = endpoint.getDescription();
            String title = endpoint.getDisplayText();
            featureList.add((ICreateFeature)new CreateDefinedEndpointFigureFeature((IFeatureProvider)this, title, description, endpoint));
        }
    }

    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        Object bo;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof ContainerShape && (bo = this.getBusinessObjectForPictogramElement(pictogramElement)) instanceof AbstractNode) {
            return new UpdateNodeFeature((IFeatureProvider)this);
        }
        return super.getUpdateFeature(context);
    }

    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        Shape shape = context.getShape();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof AbstractNode) {
            return new MoveNodeFeature((IFeatureProvider)this);
        }
        return super.getMoveShapeFeature(context);
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        return new DeleteNodeFeature((IFeatureProvider)this);
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        return new RemoveNodeFeature((IFeatureProvider)this);
    }

    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        Shape shape = context.getShape();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof AbstractNode) {
            return new ResizeNodeFeature((IFeatureProvider)this);
        }
        return super.getResizeShapeFeature(context);
    }

    public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
        return new ReconnectNodesFeature((IFeatureProvider)this);
    }

    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractNode) {
            return new LayoutNodeFeature((IFeatureProvider)this);
        }
        return super.getLayoutFeature(context);
    }

    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        return new ICustomFeature[]{new LayoutDiagramFeature((IFeatureProvider)this), new SetEndpointBreakpointFeature((IFeatureProvider)this), new SetConditionalBreakpointFeature((IFeatureProvider)this), new EditConditionalBreakpoint((IFeatureProvider)this), new EnableCamelBreakpointFeature((IFeatureProvider)this), new DisableCamelBreakpointFeature((IFeatureProvider)this), new DeleteEndpointBreakpointFeature((IFeatureProvider)this), new DeleteAllEndpointBreakpointsFeature((IFeatureProvider)this)};
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new CreateFlowFeature((IFeatureProvider)this)};
    }

    public IFeature[] getDragAndDropFeatures(IPictogramElementContext context) {
        return this.getCreateConnectionFeatures();
    }

    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        return super.getDirectEditingFeature(context);
    }

    public ICopyFeature getCopyFeature(ICopyContext context) {
        return new CopyNodeFeature((IFeatureProvider)this);
    }

    public IPasteFeature getPasteFeature(IPasteContext context) {
        return new PasteNodeFeature((IFeatureProvider)this);
    }

    public CamelModelIndependenceSolver getModelIndependenceSolver() {
        return this.modelIndependenceSolver;
    }

    public void setModelIndependenceSolver(CamelModelIndependenceSolver modelIndependenceSolver) {
        this.modelIndependenceSolver = modelIndependenceSolver;
        this.setIndependenceSolver(this.modelIndependenceSolver);
    }
}

