/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.other;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.model.AbstractNode;

public class UpdateNodeFeature
extends AbstractUpdateFeature {
    public UpdateNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof AbstractNode;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        String pictogramName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            for (Shape shape : cs.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)shape.getGraphicsAlgorithm();
                pictogramName = text.getValue();
            }
        }
        String businessName = null;
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractNode) {
            AbstractNode eClass = (AbstractNode)bo;
            businessName = DiagramUtils.filterFigureLabel(eClass.getDisplayText());
        }
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.equals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)"Name is out of date");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        String businessName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractNode) {
            AbstractNode eClass = (AbstractNode)bo;
            businessName = DiagramUtils.filterFigureLabel(eClass.getDisplayText());
        }
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            boolean finished_label = false;
            boolean finished_icon = false;
            for (Shape shape : cs.getChildren()) {
                if (shape.getGraphicsAlgorithm() instanceof Text) {
                    Text text = (Text)shape.getGraphicsAlgorithm();
                    text.setValue(businessName);
                    finished_label = true;
                } else if (shape.getGraphicsAlgorithm() instanceof Image) {
                    AbstractNode addedClass = (AbstractNode)bo;
                    String iconKey = ImageProvider.getKeyForLargeIcon(addedClass.getIconName());
                    ((Image)shape.getGraphicsAlgorithm()).setId(iconKey);
                    finished_icon = true;
                }
                if (!finished_icon || !finished_label) continue;
                return false;
            }
        }
        return false;
    }
}

