/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.delete;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Flow;
import org.fusesource.ide.camel.model.RouteContainer;

public class DeleteNodeFeature
extends DefaultDeleteFeature {
    public DeleteNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void preDelete(IDeleteContext context) {
        super.preDelete(context);
        PictogramElement pe = context.getPictogramElement();
        Object[] businessObjectsForPictogramElement = this.getAllBusinessObjectsForPictogramElement(pe);
        if (businessObjectsForPictogramElement != null && businessObjectsForPictogramElement.length > 0) {
            Object bo = businessObjectsForPictogramElement[0];
            if (bo instanceof Flow) {
                this.deleteFlowFromModel((Flow)bo);
            } else if (bo instanceof AbstractNode) {
                this.deleteBOFromModel((AbstractNode)bo);
            } else if (bo instanceof EReferenceImpl) {
                EReferenceImpl eimpl = (EReferenceImpl)bo;
                EClassifier eType = eimpl.getEType();
                if (eType instanceof AbstractNode) {
                    AbstractNode target = (AbstractNode)eType;
                    Activator.getLogger().debug("==== trying to zap the target: " + target);
                    EObject eContainer = eimpl.eContainer();
                    if (eContainer instanceof AbstractNode) {
                        AbstractNode source = (AbstractNode)eContainer;
                        Activator.getLogger().debug("==== trying to source: " + source + " -> target: " + target);
                        source.removeConnection(target);
                    }
                }
            } else {
                Activator.getLogger().warning("Cannot figure out Node or Flow from BO: " + bo);
            }
        }
    }

    private void deleteBOFromModel(AbstractNode nodeToRemove) {
        if (nodeToRemove == null || nodeToRemove instanceof RouteContainer) {
            return;
        }
        nodeToRemove.detach();
    }

    private void deleteFlowFromModel(Flow bo) {
        bo.disconnect();
    }
}

