/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class SetEndpointBreakpointFeature
extends AbstractCustomFeature {
    public SetEndpointBreakpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        PictogramElement _pe = context.getPictogramElements()[0] instanceof Connection ? ((Connection)context.getPictogramElements()[0]).getStart().getParent() : context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement(_pe);
        IResource resource = this.getResource();
        if (bo instanceof AbstractNode) {
            AbstractNode _ep = (AbstractNode)bo;
            try {
                Boolean userWantsUpdate = null;
                IFile contextFile = this.getContextFile();
                String fileName = contextFile.getName();
                String projectName = contextFile.getProject().getName();
                if ((Strings.isBlank((String)_ep.getCamelContextId()) || Strings.isBlank((String)_ep.getId())) && (userWantsUpdate = Boolean.valueOf(this.askForIDUpdate(_ep))).booleanValue()) {
                    if (Strings.isBlank((String)_ep.getCamelContextId())) {
                        String newContextId = "context-" + UUID.randomUUID().toString();
                        _ep.getParent().getParent().setContextId(newContextId);
                    }
                    boolean foundUniqueId = false;
                    if (Strings.isBlank((String)_ep.getId())) {
                        String newNodeId = null;
                        while (!foundUniqueId) {
                            newNodeId = _ep.getNewID();
                            if (((RiderDesignEditor)this.getDiagramBehavior().getDiagramContainer()).getModel().getNode(newNodeId) != null) continue;
                            foundUniqueId = true;
                        }
                        if (!Strings.isBlank(newNodeId)) {
                            _ep.setId(newNodeId);
                        } else {
                            throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.camel.editor", "Unable to determine a unique ID for node " + _ep));
                        }
                    }
                    this.saveEditor();
                }
                if (userWantsUpdate == null || userWantsUpdate.booleanValue()) {
                    CamelDebugUtils.createAndRegisterEndpointBreakpoint((IResource)resource, (AbstractNode)_ep, (String)projectName, (String)fileName);
                }
            }
            catch (CoreException e) {
                IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
                Shell shell = container instanceof RiderDesignEditor ? ((RiderDesignEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error on adding breakpoint", (String)e.getStatus().getMessage());
                return;
            }
        }
        this.getDiagramBehavior().refreshRenderingDecorators(_pe);
    }

    public String getName() {
        return "Set Breakpoint";
    }

    public String getDescription() {
        return "Sets a breakpoint on the selected endpoint node";
    }

    public String getImageId() {
        return "org.fusesource.demo.icons.reddot";
    }

    public boolean isAvailable(IContext context) {
        ICustomContext cc = (ICustomContext)context;
        Object _pe = cc.getPictogramElements()[0] instanceof Connection ? ((Connection)cc.getPictogramElements()[0]).getStart().getParent() : cc.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)_pe);
        if (bo instanceof AbstractNode) {
            AbstractNode _ep = (AbstractNode)bo;
            IFile contextFile = this.getContextFile();
            String fileName = contextFile.getName();
            String projectName = contextFile.getProject().getName();
            return _ep.supportsBreakpoint() && CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName) == null;
        }
        return false;
    }

    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }

    protected IResource getResource() {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        if (container instanceof RiderDesignEditor) {
            return ((RiderDesignEditor)container).getCamelContextFile();
        }
        return null;
    }

    protected PictogramElement getPEFromContext(ICustomContext context) {
        return context.getPictogramElements()[0] instanceof Connection ? ((Connection)context.getPictogramElements()[0]).getStart().getParent() : context.getPictogramElements()[0];
    }

    protected IFile getContextFile() {
        return Activator.getDiagramEditor().asFileEditorInput(Activator.getDiagramEditor().getEditorInput()).getFile();
    }

    protected boolean askForIDUpdate(AbstractNode node) {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        Shell shell = container instanceof RiderDesignEditor ? ((RiderDesignEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
        return MessageDialog.openConfirm((Shell)shell, (String)"Please confirm...", (String)"Debugging is only possible if the context and the nodes which have breakpoints have a unique ID set. Do you want to generate the ID values now?\n\n(Warning: All changes in the editor will be written to the context file!)");
    }

    public boolean hasDoneChanges() {
        return false;
    }

    protected void saveEditor() throws CoreException {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        RiderDesignEditor editor = null;
        if (!(container instanceof RiderDesignEditor)) {
            throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.camel.editor", "Can't find the editor to set the breakpoint!"));
        }
        editor = (RiderDesignEditor)container;
        editor.getEditor().doSave((IProgressMonitor)new NullProgressMonitor());
    }
}

