/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.impl.DiagramImpl;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.features.create.CreateFlowFeature;
import org.fusesource.ide.camel.editor.features.create.ext.CreateConnectorFigureFeature;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.ConnectorEndpoint;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.catalog.components.Component;

public class CreateNodeConnectionFeature
extends AbstractCustomFeature {
    private Class<? extends AbstractNode> clazz;
    private Component component;
    private CreateConnectorFigureFeature conFeature;

    public CreateNodeConnectionFeature(IFeatureProvider fp, Class<? extends AbstractNode> clazz) {
        this(fp, clazz, null);
    }

    public CreateNodeConnectionFeature(IFeatureProvider fp, Class<? extends AbstractNode> clazz, ObjectCreationToolEntry octe) {
        super(fp);
        this.clazz = clazz;
        this.conFeature = octe != null && octe.getCreateFeature() instanceof CreateConnectorFigureFeature ? (CreateConnectorFigureFeature)octe.getCreateFeature() : null;
        this.component = this.conFeature != null ? this.conFeature.getConnector() : null;
    }

    public String getDescription() {
        return "Adds and connects a node to the current node";
    }

    public String getName() {
        return "&Add Node";
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(final ICustomContext context) {
        RouteSupport selectedRoute;
        AbstractNode node = null;
        try {
            node = this.createNode(context);
        }
        catch (Exception exception) {
            return;
        }
        if (node instanceof RouteSupport) {
            DiagramOperations.addNewRoute(Activator.getDiagramEditor());
            return;
        }
        boolean firstNode = context.getPictogramElements().length == 1 && context.getPictogramElements()[0] instanceof DiagramImpl;
        int x = context.getPictogramElements().length > 0 ? context.getPictogramElements()[0].getGraphicsAlgorithm().getX() + 150 : 150;
        int y = context.getPictogramElements().length > 0 ? context.getPictogramElements()[0].getGraphicsAlgorithm().getY() : 150;
        CreateContext cc = new CreateContext();
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        cc.setX(x);
        cc.setY(y);
        PictogramElement newNode = this.addGraphicalRepresentation((IAreaContext)cc, node);
        if (newNode != null && (selectedRoute = Activator.getDiagramEditor().getSelectedRoute()) != null) {
            selectedRoute.addChild(node);
        }
        PictogramElement srcState = null;
        PictogramElement destState = null;
        if (!firstNode) {
            CreateFlowFeature createFeature = new CreateFlowFeature(this.getFeatureProvider());
            CreateConnectionContext connectContext = new CreateConnectionContext();
            srcState = context.getPictogramElements()[0];
            if (srcState == (destState = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)node))) {
                Activator.getLogger().warning("Should not be the same element for different nodes: " + context.getPictogramElements()[0].getLink().getBusinessObjects().get(0) + " and " + node);
            }
            connectContext.setSourcePictogramElement(srcState);
            connectContext.setTargetPictogramElement(destState);
            Anchor srcAnchor = DiagramUtils.getAnchor(srcState);
            Anchor destAnchor = DiagramUtils.getAnchor(destState);
            if (destAnchor != null) {
                connectContext.setSourceAnchor(srcAnchor);
                connectContext.setTargetAnchor(destAnchor);
                if (createFeature.canCreate((ICreateConnectionContext)connectContext)) {
                    createFeature.execute((IContext)connectContext);
                }
            }
        }
        final PictogramElement dState = destState;
        final PictogramElement nNode = newNode;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderDesignEditor ed = Activator.getDiagramEditor();
                DiagramOperations.layoutDiagram(ed);
                if (dState != null) {
                    ed.setPictogramElementForSelection(dState);
                } else if (nNode != null) {
                    ed.setPictogramElementForSelection(nNode);
                } else {
                    ed.setPictogramElementForSelection(context.getPictogramElements()[0]);
                }
                ed.getDiagramBehavior().refresh();
            }
        });
    }

    protected AbstractNode createNode(ICustomContext context) throws Exception {
        if (this.conFeature != null) {
            this.conFeature.updateMavenDependencies(this.component.getDependencies());
            return new ConnectorEndpoint(this.component != null && this.component.getSyntax() != null ? this.component.getSyntax() : String.format("%s:", this.component.getScheme()));
        }
        return this.clazz.newInstance();
    }
}

