/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.add;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.graphics.Rectangle;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.editor.utils.ImageUtils;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.camel.model.AbstractNode;

public class AddNodeFeature
extends AbstractAddShapeFeature {
    public static final int INVISIBLE_RIGHT_SPACE = 0;
    public static final int IMAGE_LABEL_SPACE = 8;
    public static final int ROUNDED_RECTANGLE_WIDTH = 10;
    public static final int ROUNDED_RECTANGLE_HEIGHT = 10;
    public static final int BASE_RECT_SPACE_X = 4;
    public static final int BASE_RECT_SPACE_Y = 4;
    public static final int SHADOW_WIDTH = 5;
    public static final int SHADOW_HEIGHT = 5;
    public static final int LABEL_SPACER_X = 5;
    public static final int DEFAULT_FIGURE_CONTENT_WIDTH = 120;
    public static final int TEXT_LABEL_SIZE = 20;
    public static final int TOP_BOTTOM_SPACE = 5;

    public AddNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        Object newObject = context.getNewObject();
        return newObject instanceof AbstractNode && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        AbstractNode addedClass = (AbstractNode)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        String label = DiagramUtils.filterFigureLabel(addedClass.getDisplayText());
        Font f = StyleUtil.getStyleForCamelText(this.getDiagram()).getFont();
        IDimension fontDimension = GraphitiUi.getUiLayoutService().calculateTextSize(label, f);
        Dimension imageDimension = ImageUtils.getImageSize(addedClass.getIconName());
        int image_width = imageDimension.width;
        int image_height = imageDimension.height;
        int label_width = fontDimension.getWidth() + 5 + 5;
        int label_height = Math.max(fontDimension.getHeight(), 20);
        int content_width = Math.max(Math.max(label_width, image_width), 120);
        Rectangle baseRect = new Rectangle(context.getX(), context.getY(), content_width + 4 + 4 + 5 + 0, 8 + image_height + 5 + 8 + label_height + 5 + 5);
        Rectangle shadowRect = new Rectangle(9, 9, content_width, image_height + label_height + 8 + 5 + 5);
        Rectangle contentRect = new Rectangle(4, 4, content_width, image_height + label_height + 8 + 5 + 5);
        Rectangle imageRect = new Rectangle(4, 9, content_width, image_height);
        Rectangle labelRect = new Rectangle(4, 4 + image_height + 8, content_width, label_height + 5);
        IGaService gaService = Graphiti.getGaService();
        RoundedRectangle baseRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 10, 10);
        gaService.setLocationAndSize((GraphicsAlgorithm)baseRectangle, baseRect.x, baseRect.y, baseRect.width, baseRect.height);
        baseRectangle.setFilled(Boolean.valueOf(false));
        baseRectangle.setLineVisible(Boolean.valueOf(false));
        RoundedRectangle shadowRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)baseRectangle, 10, 10);
        shadowRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)baseRectangle);
        shadowRectangle.setStyle(StyleUtil.getShadowStyleForCamelClass(this.getDiagram()));
        shadowRectangle.setLineVisible(Boolean.valueOf(false));
        shadowRectangle.setFilled(Boolean.valueOf(true));
        gaService.setLocationAndSize((GraphicsAlgorithm)shadowRectangle, shadowRect.x, shadowRect.y, shadowRect.width, shadowRect.height);
        RoundedRectangle roundedRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)baseRectangle, 10, 10);
        roundedRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)baseRectangle);
        roundedRectangle.setStyle(StyleUtil.getStyleForCamelClass(this.getDiagram()));
        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, contentRect.x, contentRect.y, contentRect.width, contentRect.height);
        Shape shape = peCreateService.createShape(containerShape, false);
        Image image = gaService.createImage((GraphicsAlgorithmContainer)shape, ImageProvider.getKeyForLargeIcon(addedClass.getIconName()));
        gaService.setLocationAndSize((GraphicsAlgorithm)image, imageRect.x, imageRect.y, imageRect.width, imageRect.height);
        shape = peCreateService.createShape(containerShape, false);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)shape, label);
        Style style = StyleUtil.getStyleForCamelText(this.getDiagram());
        text.setStyle(style);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setFont(style.getFont());
        gaService.setLocationAndSize((GraphicsAlgorithm)text, labelRect.x, labelRect.y, labelRect.width, labelRect.height);
        IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setPictogramElement((PictogramElement)shape);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        this.layoutPictogramElement((PictogramElement)containerShape);
        this.link((PictogramElement)containerShape, addedClass);
        this.getFeatureProvider().link((PictogramElement)containerShape, (Object)addedClass);
        return containerShape;
    }

    public boolean hasDoneChanges() {
        return true;
    }
}

