/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.project.integration;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.Manifest;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;
import org.fusesource.ide.project.Activator;

public class CamelModuleFactory
extends ProjectModuleFactoryDelegate {
    public static final String MODULE_TYPE = "fuse.camel";
    public static final String VERSION = "1.0";
    private ArrayList<CamelModuleDelegate> moduleResourceRegistry = new ArrayList();

    public CamelModuleFactory() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceChangeListener rcl = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                CamelModuleDelegate del;
                if (event.getType() == 32 || event.getType() == 2) {
                    return;
                }
                if (event.getSource() instanceof IProject && (del = CamelModuleFactory.this.getModuleForProject((IProject)event.getSource())) != null) {
                    del.setModuleFile(CamelModuleFactory.this.generateDummyModuleFile());
                }
            }
        };
        workspace.addResourceChangeListener(rcl);
    }

    private ModuleFile generateDummyModuleFile() {
        return new ModuleFile("dummy" + System.currentTimeMillis(), null, System.currentTimeMillis());
    }

    private CamelModuleDelegate getModuleForProject(IProject project) {
        for (CamelModuleDelegate cmd : this.moduleResourceRegistry) {
            if (!cmd.getModule().getProject().equals((Object)project)) continue;
            return cmd;
        }
        return null;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return new CamelModuleDelegate();
    }

    protected IModule[] createModules(IProject project) {
        try {
            if (!project.hasNature("org.fusesource.ide.project.RiderProjectNature") || !this.supportsDeployment(project)) {
                return new IModule[0];
            }
        }
        catch (CoreException coreException) {
            return new IModule[0];
        }
        IModule module = this.createModule(this.getBundleSymbolicName(project), project.getName(), MODULE_TYPE, VERSION, project);
        return new IModule[]{module};
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path("META-INF/MANIFEST.MF"), new Path("META-INF/spring/"), new Path("pom.xml"), new Path("OSGI-INF/blueprint/"), new Path(".settings/org.eclipse.pde.core.prefs")};
    }

    protected Manifest getManifest(IProject project) {
        IFile manifest = project.getFile("target/classes/META-INF/MANIFEST.MF");
        if (!manifest.exists()) {
            manifest = project.getFile("META-INF/MANIFEST.MF");
        }
        if (manifest.exists()) {
            try {
                return new Manifest(new FileInputStream(manifest.getLocation().toFile()));
            }
            catch (IOException ex) {
                Activator.getLogger().error((Throwable)ex);
            }
        }
        return null;
    }

    protected boolean supportsDeployment(IProject project) {
        IFile pomFile = project.getFile("pom.xml");
        if (pomFile != null) {
            try {
                Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
                if (model != null && (model.getPackaging().equalsIgnoreCase("war") || model.getPackaging().equalsIgnoreCase("bundle"))) {
                    return true;
                }
            }
            catch (CoreException ex) {
                Activator.getLogger().error((Throwable)ex);
            }
        }
        return false;
    }

    protected String getBundleSymbolicName(IProject project) {
        String symbolicName = null;
        Manifest mf = this.getManifest(project);
        symbolicName = mf != null ? mf.getMainAttributes().getValue("Bundle-SymbolicName") : project.getName();
        return symbolicName;
    }

    public class CamelModuleDelegate
    extends ModuleDelegate {
        private ModuleFile moduleFile;

        public ModuleFile getModuleFile() {
            return this.moduleFile;
        }

        public void setModuleFile(ModuleFile file) {
            this.moduleFile = file;
        }

        public IStatus validate() {
            return Status.OK_STATUS;
        }

        public IModule[] getChildModules() {
            return new IModule[0];
        }

        public IModuleResource[] members() throws CoreException {
            return new IModuleResource[]{this.getModuleFile()};
        }
    }
}

