/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.EnumPropertyDescriptor;

public class Sampling
extends AbstractNode {
    public static final String PROPERTY_SAMPLEPERIOD = "Sampling.SamplePeriod";
    public static final String PROPERTY_MESSAGEFREQUENCY = "Sampling.MessageFrequency";
    public static final String PROPERTY_UNITS = "Sampling.Units";
    private Long samplePeriod;
    private Long messageFrequency;
    private TimeUnit units;

    public Sampling() {
    }

    public Sampling(SamplingDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "generic.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "samplingNode";
    }

    @Override
    public String getCategoryName() {
        return "Miscellaneous";
    }

    public Long getSamplePeriod() {
        return this.samplePeriod;
    }

    public void setSamplePeriod(Long samplePeriod) {
        Long oldValue = this.samplePeriod;
        this.samplePeriod = samplePeriod;
        if (!this.isSame(oldValue, samplePeriod)) {
            this.firePropertyChange(PROPERTY_SAMPLEPERIOD, oldValue, samplePeriod);
        }
    }

    public Long getMessageFrequency() {
        return this.messageFrequency;
    }

    public void setMessageFrequency(Long messageFrequency) {
        Long oldValue = this.messageFrequency;
        this.messageFrequency = messageFrequency;
        if (!this.isSame(oldValue, messageFrequency)) {
            this.firePropertyChange(PROPERTY_MESSAGEFREQUENCY, oldValue, messageFrequency);
        }
    }

    public TimeUnit getUnits() {
        return this.units;
    }

    public void setUnits(TimeUnit units) {
        TimeUnit oldValue = this.units;
        this.units = units;
        if (!this.isSame((Object)oldValue, (Object)units)) {
            this.firePropertyChange(PROPERTY_UNITS, (Object)oldValue, (Object)units);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descSamplePeriod = new TextPropertyDescriptor((Object)PROPERTY_SAMPLEPERIOD, Messages.propertyLabelSamplingSamplePeriod);
        TextPropertyDescriptor descMessageFrequency = new TextPropertyDescriptor((Object)PROPERTY_MESSAGEFREQUENCY, Messages.propertyLabelSamplingMessageFrequency);
        EnumPropertyDescriptor descUnits = new EnumPropertyDescriptor((Object)PROPERTY_UNITS, Messages.propertyLabelSamplingUnits, TimeUnit.class);
        descriptors.put(PROPERTY_SAMPLEPERIOD, (PropertyDescriptor)descSamplePeriod);
        descriptors.put(PROPERTY_MESSAGEFREQUENCY, (PropertyDescriptor)descMessageFrequency);
        descriptors.put(PROPERTY_UNITS, (PropertyDescriptor)descUnits);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_SAMPLEPERIOD.equals(id)) {
            this.setSamplePeriod(Objects.convertTo(value, Long.class));
            return;
        }
        if (PROPERTY_MESSAGEFREQUENCY.equals(id)) {
            this.setMessageFrequency(Objects.convertTo(value, Long.class));
            return;
        }
        if (PROPERTY_UNITS.equals(id)) {
            this.setUnits(Objects.convertTo(value, TimeUnit.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_SAMPLEPERIOD.equals(id)) {
            return this.getSamplePeriod();
        }
        if (PROPERTY_MESSAGEFREQUENCY.equals(id)) {
            return this.getMessageFrequency();
        }
        if (PROPERTY_UNITS.equals(id)) {
            return this.getUnits();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        SamplingDefinition answer = new SamplingDefinition();
        answer.setSamplePeriod(this.toXmlPropertyValue(PROPERTY_SAMPLEPERIOD, this.getSamplePeriod()));
        answer.setMessageFrequency(this.toXmlPropertyValue(PROPERTY_MESSAGEFREQUENCY, this.getMessageFrequency()));
        answer.setUnits(this.toXmlPropertyValue(PROPERTY_UNITS, this.getUnits()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return SamplingDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof SamplingDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof SamplingDefinition. Was " + processor.getClass().getName());
        }
        SamplingDefinition node = (SamplingDefinition)processor;
        this.setSamplePeriod(node.getSamplePeriod());
        this.setMessageFrequency(node.getMessageFrequency());
        this.setUnits(node.getUnits());
    }
}

